/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher.helper;

import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.spi.LookupService;
import io.smallrye.graphql.spi.ManagedInstance;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Flow;
import mutiny.zero.flow.adapters.AdaptersToReactiveStreams;
import org.eclipse.microprofile.graphql.GraphQLException;

public class ReflectionInvoker {
    private final LookupService lookupService = LookupService.get();
    private final ClassloadingService classloadingService = ClassloadingService.get();
    private final EventEmitter eventEmitter = EventEmitter.getInstance();
    private final Class<?> operationClass;
    private Method method;
    private int injectContextAt = -1;

    public ReflectionInvoker(String className) {
        this.operationClass = this.classloadingService.loadClass(className);
    }

    public ReflectionInvoker(String className, String methodName, List<String> parameterClasses) {
        this.operationClass = this.classloadingService.loadClass(className);
        this.setMethod(methodName, parameterClasses);
    }

    public void setMethod(String methodName, List<String> parameterClasses) {
        this.method = this.lookupMethod(this.operationClass, methodName, parameterClasses);
    }

    public <T> T invokePrivileged(Object ... arguments) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return this.invokePrivileged(tccl, arguments);
    }

    public <T> T invokePrivileged(final ClassLoader classLoader, final Object ... arguments) {
        try {
            return (T)AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                    try {
                        Object t = ReflectionInvoker.this.invoke(arguments);
                        return t;
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(originalTccl);
                    }
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public <T> T invoke(Object ... arguments) throws Exception {
        if (this.injectContextAt > -1) {
            arguments = this.injectContext(arguments);
        }
        try {
            ManagedInstance<?> operationInstance = this.lookupService.getInstance(this.operationClass);
            Object operationInstance1 = operationInstance.get();
            this.eventEmitter.fireBeforeMethodInvoke(new InvokeInfo(operationInstance1, this.method, arguments));
            Object result = this.method.invoke(operationInstance1, arguments);
            if (result instanceof Uni) {
                return (T)((Uni)result).onTermination().invoke(() -> operationInstance.destroyIfNecessary());
            }
            if (result instanceof Multi) {
                Multi multi = (Multi)result;
                multi = multi.onTermination().invoke(() -> operationInstance.destroyIfNecessary());
                return (T)AdaptersToReactiveStreams.publisher((Flow.Publisher)multi);
            }
            operationInstance.destroyIfNecessary();
            return (T)result;
        }
        catch (InvocationTargetException ex) {
            Throwable throwable = ex.getCause();
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof GraphQLException) {
                throw (GraphQLException)throwable;
            }
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw SmallRyeGraphQLServerMessages.msg.generalDataFetcherException(this.operationClass.getName() + ": " + this.method.getName(), throwable);
        }
    }

    private Method lookupMethod(Class<?> operationClass, String methodName, List<String> parameterClasses) {
        try {
            return operationClass.getMethod(methodName, this.getParameterClasses(parameterClasses));
        }
        catch (NoSuchMethodException e) {
            throw SmallRyeGraphQLServerMessages.msg.generalDataFetcherException(operationClass.getName() + ": " + methodName, e);
        }
    }

    private Class<?>[] getParameterClasses(List<String> parameterClasses) {
        if (parameterClasses != null && !parameterClasses.isEmpty()) {
            LinkedList cl = new LinkedList();
            int cnt = 0;
            for (String className : parameterClasses) {
                cl.add(this.classloadingService.loadClass(className));
                if (className.equals(Context.class.getName())) {
                    this.injectContextAt = cnt;
                }
                ++cnt;
            }
            return cl.toArray(new Class[0]);
        }
        return null;
    }

    private Object[] injectContext(Object[] arguments) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(arguments));
        list.set(this.injectContextAt, SmallRyeContextManager.getCurrentSmallRyeContext());
        return list.toArray();
    }

    public String toString() {
        return this.method.toString();
    }
}

