package io.smallrye.graphql;

import java.util.Locale;
import java.io.Serializable;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class SmallRyeGraphQLServerLogging_$logger implements SmallRyeGraphQLServerLogging, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = SmallRyeGraphQLServerLogging_$logger.class.getName();
    public SmallRyeGraphQLServerLogging_$logger(final Logger log) {
        this.log = log;
    }
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void emptyOrNullSchema() {
        log.logf(FQCN, WARN, null, emptyOrNullSchema$str());
    }
    protected String emptyOrNullSchema$str() {
        return "SRGQL010000: Schema is null, or it has no operations. Not bootstrapping SmallRye GraphQL";
    }
    @Override
    public final void noGraphQLMethodsFound() {
        log.logf(FQCN, WARN, null, noGraphQLMethodsFound$str());
    }
    protected String noGraphQLMethodsFound$str() {
        return "SRGQL010001: No GraphQL methods found. Try annotating your methods with @Query or @Mutation";
    }
    @Override
    public final void duplicateOperation(final String operationName) {
        log.logf(FQCN, WARN, null, duplicateOperation$str(), operationName);
    }
    protected String duplicateOperation$str() {
        return "SRGQL010002: Operation [%s] also exist as a batch operation - ignoring the non-batch operation";
    }
    @Override
    public final void stringInputForVariables(final String stringVars) {
        log.logf(FQCN, WARN, null, stringInputForVariables$str(), stringVars);
    }
    protected String stringInputForVariables$str() {
        return "SRGQL011000: We got a String as input for Variables, not sure what to do with that [%s]";
    }
    @Override
    public final void retrievedFromCache(final String query) {
        log.logf(FQCN, DEBUG, null, retrievedFromCache$str(), query);
    }
    protected String retrievedFromCache$str() {
        return "SRGQL011001: Retrieved from cache: %s";
    }
    @Override
    public final void addedToCache(final String query) {
        log.logf(FQCN, DEBUG, null, addedToCache$str(), query);
    }
    protected String addedToCache$str() {
        return "SRGQL011002: Added to cache: %s";
    }
    @Override
    public final void noArgConstructorMissing(final String typeName) {
        log.logf(FQCN, DEBUG, null, noArgConstructorMissing$str(), typeName);
    }
    protected String noArgConstructorMissing$str() {
        return "SRGQL011003: Cannot use the no-arg constructor to build instances of type %s";
    }
    @Override
    public final void dontKnowHoToHandleArgument(final String className, final String methodName) {
        log.logf(FQCN, WARN, null, dontKnowHoToHandleArgument$str(), className, methodName);
    }
    protected String dontKnowHoToHandleArgument$str() {
        return "SRGQL011004: Returning argument as is, because we did not know how to handle it [%s] on method [%s]";
    }
    @Override
    public final void payloadIn(final String payload) {
        log.logf(FQCN, INFO, null, payloadIn$str(), payload);
    }
    protected String payloadIn$str() {
        return "SRGQL011005: Payload In [%s]";
    }
    @Override
    public final void payloadOut(final String payload) {
        log.logf(FQCN, INFO, null, payloadOut$str(), payload);
    }
    protected String payloadOut$str() {
        return "SRGQL011006: Payload Out [%s]";
    }
    @Override
    public final void dataFetchingError(final Throwable cause) {
        log.logf(FQCN, ERROR, cause, dataFetchingError$str());
    }
    protected String dataFetchingError$str() {
        return "SRGQL012000: Data Fetching Error";
    }
    @Override
    public final void usingMetricsService(final String name) {
        log.logf(FQCN, DEBUG, null, usingMetricsService$str(), name);
    }
    protected String usingMetricsService$str() {
        return "SRGQL013001: Using %s lookup service for metrics";
    }
    @Override
    public final void usingTracingService(final String name) {
        log.logf(FQCN, DEBUG, null, usingTracingService$str(), name);
    }
    protected String usingTracingService$str() {
        return "SRGQL013002: Using %s lookup service for tracing";
    }
    @Override
    public final void usingLookupService(final String name) {
        log.logf(FQCN, DEBUG, null, usingLookupService$str(), name);
    }
    protected String usingLookupService$str() {
        return "SRGQL013003: Using %s service for object lookups";
    }
    @Override
    public final void usingClassLoadingService(final String name) {
        log.logf(FQCN, DEBUG, null, usingClassLoadingService$str(), name);
    }
    protected String usingClassLoadingService$str() {
        return "SRGQL013004: Using %s service for class loading";
    }
    @Override
    public final void transformError(final Throwable t) {
        log.logf(FQCN, ERROR, t, transformError$str());
    }
    protected String transformError$str() {
        return "SRGQL014000: Unable to transform data";
    }
    @Override
    public final void usingContextPropagationService(final String name) {
        log.logf(FQCN, DEBUG, null, usingContextPropagationService$str(), name);
    }
    protected String usingContextPropagationService$str() {
        return "SRGQL015000: Using %s service for context propagation";
    }
    @Override
    public final void enableFederation() {
        log.logf(FQCN, DEBUG, null, enableFederation$str());
    }
    protected String enableFederation$str() {
        return "SRGQL016000: Enable GraphQL Federation";
    }
}
