/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution;

import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class Classes {
    private static final List<String> NUMBERS = new ArrayList<String>();
    private static final List<String> DATES = new ArrayList<String>();
    private static final Map<String, Class> PRIMITIVE_CLASSES = new HashMap<String, Class>();
    private static final Map<String, Class> OBJECT_PRIMITIVE_MAPPING = new HashMap<String, Class>();
    public static final String ENUM = Enum.class.getName();
    public static final String OPTIONAL = Optional.class.getName();
    public static final String UUID = UUID.class.getName();
    public static final String URL = URL.class.getName();
    public static final String URI = URI.class.getName();
    public static final String LOCALDATE = LocalDate.class.getName();
    public static final String LOCALDATETIME = LocalDateTime.class.getName();
    public static final String LOCALTIME = LocalTime.class.getName();
    public static final String ZONEDDATETIME = ZonedDateTime.class.getName();
    public static final String OFFSETDATETIME = OffsetDateTime.class.getName();
    public static final String OFFSETTIME = OffsetTime.class.getName();
    public static final String INSTANT = Instant.class.getName();
    public static final String UTIL_DATE = java.util.Date.class.getName();
    public static final String SQL_DATE = Date.class.getName();
    public static final String SQL_TIMESTAMP = Timestamp.class.getName();
    public static final String SQL_TIME = Time.class.getName();
    public static final String CALENDAR = Calendar.class.getName();
    public static final String GREGORIAN_CALENDAR = GregorianCalendar.class.getName();
    public static final String DURATION = Duration.class.getName();
    public static final String PERIOD = Period.class.getName();
    public static final String BYTE = Byte.class.getName();
    public static final String BYTE_PRIMATIVE = Byte.TYPE.getName();
    public static final String SHORT = Short.class.getName();
    public static final String SHORT_PRIMATIVE = Short.TYPE.getName();
    public static final String INTEGER = Integer.class.getName();
    public static final String INTEGER_PRIMATIVE = Integer.TYPE.getName();
    public static final String BIG_INTEGER = BigInteger.class.getName();
    public static final String DOUBLE = Double.class.getName();
    public static final String DOUBLE_PRIMATIVE = Double.TYPE.getName();
    public static final String BIG_DECIMAL = BigDecimal.class.getName();
    public static final String LONG = Long.class.getName();
    public static final String LONG_PRIMATIVE = Long.TYPE.getName();
    public static final String FLOAT = Float.class.getName();
    public static final String FLOAT_PRIMATIVE = Float.TYPE.getName();
    public static final String BOOLEAN = Boolean.class.getName();
    public static final String BOOLEAN_PRIMITIVE = Boolean.TYPE.getName();
    public static final String CHARACTER = Character.class.getName();
    public static final String CHARACTER_PRIMITIVE = Character.TYPE.getName();

    private Classes() {
    }

    public static boolean isUUID(String className) {
        return className.equals(UUID);
    }

    public static boolean isURL(String className) {
        return className.equals(URL);
    }

    public static boolean isURI(String className) {
        return className.equals(URI);
    }

    public static boolean isPeriod(String className) {
        return className.equals(PERIOD);
    }

    public static boolean isDuration(String className) {
        return className.equals(DURATION);
    }

    public static boolean isPrimitive(String primitiveName) {
        return PRIMITIVE_CLASSES.containsKey(primitiveName);
    }

    public static boolean isCollection(Object c) {
        if (c == null) {
            return false;
        }
        return Collection.class.isAssignableFrom(c.getClass());
    }

    public static boolean isMap(Object c) {
        if (c == null) {
            return false;
        }
        return Map.class.isAssignableFrom(c.getClass());
    }

    public static Class getPrimativeClassType(String primitiveName) throws ClassNotFoundException {
        if (Classes.isPrimitive(primitiveName)) {
            return PRIMITIVE_CLASSES.get(primitiveName);
        }
        throw SmallRyeGraphQLServerMessages.msg.unknownPrimitiveType(primitiveName);
    }

    public static boolean isNumberLikeType(String className) {
        return NUMBERS.contains(className);
    }

    public static boolean isDateLikeType(String className) {
        return DATES.contains(className);
    }

    public static boolean isPrimitiveOf(String primitiveType, String boxedType) {
        if (OBJECT_PRIMITIVE_MAPPING.containsKey(boxedType)) {
            return OBJECT_PRIMITIVE_MAPPING.get(boxedType).getName().equals(primitiveType);
        }
        return false;
    }

    public static boolean isBoolean(String className) {
        return className.equals(BOOLEAN) || className.equals(BOOLEAN_PRIMITIVE);
    }

    public static boolean isCharacter(String className) {
        return className.equals(CHARACTER) || className.equals(CHARACTER_PRIMITIVE);
    }

    static {
        PRIMITIVE_CLASSES.put("boolean", Boolean.TYPE);
        PRIMITIVE_CLASSES.put("byte", Byte.TYPE);
        PRIMITIVE_CLASSES.put("char", Character.TYPE);
        PRIMITIVE_CLASSES.put("short", Short.TYPE);
        PRIMITIVE_CLASSES.put("int", Integer.TYPE);
        PRIMITIVE_CLASSES.put("long", Long.TYPE);
        PRIMITIVE_CLASSES.put("float", Float.TYPE);
        PRIMITIVE_CLASSES.put("double", Double.TYPE);
        OBJECT_PRIMITIVE_MAPPING.put(Boolean.class.getName(), Boolean.TYPE);
        OBJECT_PRIMITIVE_MAPPING.put(Byte.class.getName(), Byte.TYPE);
        OBJECT_PRIMITIVE_MAPPING.put(Character.class.getName(), Character.TYPE);
        OBJECT_PRIMITIVE_MAPPING.put(Short.class.getName(), Short.TYPE);
        OBJECT_PRIMITIVE_MAPPING.put(Integer.class.getName(), Integer.TYPE);
        OBJECT_PRIMITIVE_MAPPING.put(Long.class.getName(), Long.TYPE);
        OBJECT_PRIMITIVE_MAPPING.put(Float.class.getName(), Float.TYPE);
        OBJECT_PRIMITIVE_MAPPING.put(Double.class.getName(), Double.TYPE);
        NUMBERS.add(BYTE);
        NUMBERS.add(BYTE_PRIMATIVE);
        NUMBERS.add(SHORT);
        NUMBERS.add(SHORT_PRIMATIVE);
        NUMBERS.add(INTEGER);
        NUMBERS.add(INTEGER_PRIMATIVE);
        NUMBERS.add(BIG_INTEGER);
        NUMBERS.add(DOUBLE);
        NUMBERS.add(DOUBLE_PRIMATIVE);
        NUMBERS.add(BIG_DECIMAL);
        NUMBERS.add(LONG);
        NUMBERS.add(LONG_PRIMATIVE);
        NUMBERS.add(FLOAT);
        NUMBERS.add(FLOAT_PRIMATIVE);
        DATES.add(LOCALDATE);
        DATES.add(LOCALTIME);
        DATES.add(LOCALDATETIME);
        DATES.add(INSTANT);
        DATES.add(ZONEDDATETIME);
        DATES.add(OFFSETDATETIME);
        DATES.add(OFFSETTIME);
        DATES.add(UTIL_DATE);
        DATES.add(SQL_DATE);
        DATES.add(SQL_TIMESTAMP);
        DATES.add(SQL_TIME);
        DATES.add(CALENDAR);
        DATES.add(GREGORIAN_CALENDAR);
    }
}

