/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.datafetcher;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.context.SmallRyeContextManager;
import io.smallrye.graphql.execution.datafetcher.helper.ArgumentHelper;
import io.smallrye.graphql.execution.datafetcher.helper.BatchLoaderHelper;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.execution.metrics.MetricsEmitter;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.mutiny.Uni;
import java.util.HashMap;
import java.util.List;
import org.dataloader.DataLoader;

public class BatchDataFetcher<T>
implements DataFetcher<T> {
    private final Operation operation;
    private final Type type;
    private final ArgumentHelper argumentHelper;
    private final String batchLoaderName;
    private final BatchLoaderHelper batchLoaderHelper = new BatchLoaderHelper();
    private final EventEmitter eventEmitter = EventEmitter.getInstance();
    private final MetricsEmitter metricsEmitter = MetricsEmitter.getInstance();

    public BatchDataFetcher(Operation operation, Type type) {
        this.operation = operation;
        this.type = type;
        this.argumentHelper = new ArgumentHelper(operation.getArguments());
        this.batchLoaderName = this.batchLoaderHelper.getName(operation);
    }

    public T get(DataFetchingEnvironment dfe) throws Exception {
        SmallRyeContext smallryeContext = SmallRyeContextManager.populateFromDataFetchingEnvironment(this.type, (Field)this.operation, dfe);
        this.eventEmitter.fireBeforeDataFetch(smallryeContext);
        long measurementId = this.metricsEmitter.start(smallryeContext);
        try {
            List<Object> transformedArguments = this.argumentHelper.getArguments(dfe, true);
            Object source = dfe.getSource();
            DataLoader dataLoader = dfe.getDataLoader(this.batchLoaderName);
            HashMap<String, List<Object>> batchContext = new HashMap<String, List<Object>>();
            batchContext.put("arguments", transformedArguments);
            batchContext.put("dataFetchingEnvironment", (List<Object>)dfe);
            return (T)Uni.createFrom().completionStage(() -> dataLoader.load(source, (Object)batchContext)).onItemOrFailure().invoke(() -> this.metricsEmitter.end(measurementId)).subscribe().asCompletionStage();
        }
        catch (Exception e) {
            this.metricsEmitter.end(measurementId);
            throw e;
        }
    }
}

