/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.scalar.custom;

import graphql.language.FloatValue;
import graphql.language.Value;
import graphql.schema.Coercing;
import graphql.schema.CoercingParseLiteralException;
import graphql.schema.CoercingParseValueException;
import graphql.schema.CoercingSerializeException;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.api.CustomFloatScalar;
import io.smallrye.graphql.spi.ClassloadingService;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;

public class FloatCoercing
implements Coercing<Object, BigDecimal> {
    private final Class<? extends CustomFloatScalar> customScalarClass;

    public FloatCoercing(String customScalarClass) {
        ClassloadingService classloadingService = ClassloadingService.get();
        this.customScalarClass = classloadingService.loadClass(customScalarClass);
    }

    private CustomFloatScalar newInstance(BigDecimal graphqlPrimitiveValue) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        return graphqlPrimitiveValue == null ? null : this.customScalarClass.getConstructor(BigDecimal.class).newInstance(graphqlPrimitiveValue);
    }

    private static String typeName(Object input) {
        if (input == null) {
            return "null";
        }
        return input.getClass().getSimpleName();
    }

    private CustomFloatScalar convertImpl(Object input) throws NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        if (input instanceof BigDecimal) {
            return this.newInstance((BigDecimal)input);
        }
        if (input.getClass().isAssignableFrom(this.customScalarClass)) {
            return (CustomFloatScalar)input;
        }
        throw new RuntimeException("Unable to convert null input.");
    }

    public BigDecimal serialize(Object input) throws CoercingSerializeException {
        CustomFloatScalar result;
        try {
            result = this.convertImpl(input);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoercingSerializeException("Unable to serialize input " + String.valueOf(input), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingSerializeException("BigDecimal or class extending " + String.valueOf(this.customScalarClass), FloatCoercing.typeName(input), null);
        }
        return result.floatValueForSerialization();
    }

    public Object parseValue(Object input) throws CoercingParseValueException {
        CustomFloatScalar result;
        try {
            result = this.convertImpl(input);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoercingParseValueException("Unable to parse input: " + String.valueOf(input), (Throwable)e);
        }
        catch (RuntimeException e) {
            throw SmallRyeGraphQLServerMessages.msg.coercingParseValueException("BigDecimal or class extending " + String.valueOf(this.customScalarClass), FloatCoercing.typeName(input), null);
        }
        return result;
    }

    public Object parseLiteral(Object input) throws CoercingParseLiteralException {
        if (!(input instanceof FloatValue)) {
            throw new CoercingParseLiteralException("Expected a String AST type object but was '" + FloatCoercing.typeName(input) + "'.");
        }
        try {
            return this.newInstance(((FloatValue)input).getValue());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CoercingParseLiteralException("Unable to parse literal:" + String.valueOf(input), (Throwable)e);
        }
    }

    public Value<?> valueToLiteral(Object input) {
        BigDecimal s = this.serialize(input);
        return FloatValue.newFloatValue((BigDecimal)s).build();
    }
}

