/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Transformation;
import io.smallrye.graphql.transformation.Transformer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

public class CalendarTransformer
implements Transformer<Calendar, String> {
    private final String targetClassName;
    private final DateFormat dateFormat;

    public CalendarTransformer(Field field, String targetClassName) {
        this.dateFormat = CalendarTransformer.getDateFormat(field.getTransformation());
        this.targetClassName = targetClassName;
    }

    public CalendarTransformer(Field field) {
        this(field, field.getReference().getClassName());
    }

    @Override
    public Calendar in(String o) throws Exception {
        if (this.dateFormat == null) {
            throw SmallRyeGraphQLServerMessages.msg.notValidDateOrTimeType(this.targetClassName);
        }
        return new Calendar.Builder().setInstant(this.dateFormat.parse(o)).build();
    }

    @Override
    public String out(Calendar o) {
        return this.dateFormat.format(o.getTime());
    }

    private static DateFormat getDateFormat(Transformation formatter) {
        if (formatter == null) {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
        String format = formatter.getFormat();
        if (format == null) {
            return null;
        }
        String localeTag = formatter.getLocale();
        Locale locale = localeTag != null ? Locale.forLanguageTag(localeTag) : Locale.getDefault();
        return new SimpleDateFormat(format, locale);
    }
}

