/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql;

import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="SRGQL")
public interface SmallRyeGraphQLServerLogging {
    public static final SmallRyeGraphQLServerLogging log = (SmallRyeGraphQLServerLogging)Logger.getMessageLogger(SmallRyeGraphQLServerLogging.class, (String)SmallRyeGraphQLServerLogging.class.getPackage().getName());

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10000, value="Schema is null, or it has no operations. Not bootstrapping SmallRye GraphQL")
    public void emptyOrNullSchema();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10001, value="No GraphQL methods found. Try annotating your methods with @Query or @Mutation")
    public void noGraphQLMethodsFound();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10002, value="Operation [%s] also exist as a batch operation - ignoring the non-batch operation")
    public void duplicateOperation(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11000, value="We got a String as input for Variables, not sure what to do with that [%s]")
    public void stringInputForVariables(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=11001, value="Retrieved from cache: %s")
    public void retrievedFromCache(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=11002, value="Added to cache: %s")
    public void addedToCache(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=11003, value="Cannot use the no-arg constructor to build instances of type %s")
    public void noArgConstructorMissing(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=11004, value="Returning argument as is, because we did not know how to handle it [%s] on method [%s]")
    public void dontKnowHoToHandleArgument(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11005, value="Payload In [%s]")
    public void payloadIn(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11006, value="Payload Out [%s]")
    public void payloadOut(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=12000, value="Data Fetching Error")
    public void dataFetchingError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=13001, value="Using %s lookup service for metrics")
    public void usingMetricsService(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=13002, value="Using %s lookup service for tracing")
    public void usingTracingService(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=13003, value="Using %s service for object lookups")
    public void usingLookupService(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=13004, value="Using %s service for class loading")
    public void usingClassLoadingService(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14000, value="Unable to transform data")
    public void transformError(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=15000, value="Using %s service for context propagation")
    public void usingContextPropagationService(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=16000, value="Enable GraphQL Federation")
    public void enableFederation();
}

