/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DelegatingDataFetchingEnvironment;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class FederationDataFetcher
implements DataFetcher<List<Object>> {
    private final GraphQLObjectType queryType;
    private final GraphQLCodeRegistry codeRegistry;

    public FederationDataFetcher(GraphQLObjectType queryType, GraphQLCodeRegistry codeRegistry) {
        this.queryType = queryType;
        this.codeRegistry = codeRegistry;
    }

    public List<Object> get(DataFetchingEnvironment environment) throws Exception {
        return ((List)environment.getArgument("representations")).stream().map(representations -> this.fetchEntities(environment, (Map<String, Object>)representations)).collect(Collectors.toList());
    }

    private Object fetchEntities(DataFetchingEnvironment env, Map<String, Object> representations) {
        HashMap<String, Object> requestedArgs = new HashMap<String, Object>(representations);
        requestedArgs.remove("__typename");
        String typename = (String)representations.get("__typename");
        for (GraphQLFieldDefinition field : this.queryType.getFields()) {
            if (!this.matchesReturnType(field, typename) || !this.matchesArguments(requestedArgs, field)) continue;
            return this.execute(field, env, requestedArgs);
        }
        throw new RuntimeException("no query found for " + typename + " by " + requestedArgs.keySet());
    }

    private boolean matchesReturnType(GraphQLFieldDefinition field, String typename) {
        GraphQLOutputType returnType = field.getType();
        return returnType instanceof GraphQLNamedSchemaElement && ((GraphQLNamedSchemaElement)returnType).getName().equals(typename);
    }

    private boolean matchesArguments(Map<String, Object> requestedArguments, GraphQLFieldDefinition field) {
        Set argumentNames = field.getArguments().stream().map(GraphQLArgument::getName).collect(Collectors.toSet());
        return argumentNames.equals(requestedArguments.keySet());
    }

    private Object execute(GraphQLFieldDefinition field, DataFetchingEnvironment env, final Map<String, Object> requestedArgs) {
        DataFetcher dataFetcher = this.codeRegistry.getDataFetcher((GraphQLFieldsContainer)this.queryType, field);
        DelegatingDataFetchingEnvironment argsEnv = new DelegatingDataFetchingEnvironment(env){

            public Map<String, Object> getArguments() {
                return requestedArgs;
            }

            public boolean containsArgument(String name) {
                return requestedArgs.containsKey(name);
            }

            public <T> T getArgument(String name) {
                return (T)requestedArgs.get(name);
            }

            public <T> T getArgumentOrDefault(String name, T defaultValue) {
                return this.containsArgument(name) ? this.getArgument(name) : defaultValue;
            }
        };
        try {
            return dataFetcher.get((DataFetchingEnvironment)argsEnv);
        }
        catch (Exception e) {
            throw new RuntimeException("can't fetch data from " + field, e);
        }
    }
}

