/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.metrics;

import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.spi.MetricsService;
import io.smallrye.graphql.spi.config.Config;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ThreadLocalRandom;
import org.jboss.logging.Logger;

public class MetricsEmitter {
    private static final Logger LOG = Logger.getLogger(MetricsEmitter.class);
    private final List<MetricsService> enabledServices;

    public static MetricsEmitter getInstance() {
        return new MetricsEmitter();
    }

    private MetricsEmitter() {
        Config config = Config.get();
        boolean enabled = config.getConfigValue("smallrye.graphql.metrics.enabled", Boolean.TYPE, false);
        ServiceLoader<MetricsService> metricService = ServiceLoader.load(MetricsService.class);
        Iterator<MetricsService> it = metricService.iterator();
        ArrayList<MetricsService> enabledServices = new ArrayList<MetricsService>();
        while (enabled && it.hasNext()) {
            try {
                enabledServices.add(it.next());
            }
            catch (Throwable throwable) {}
        }
        this.enabledServices = enabledServices;
    }

    public Long start(Context context) {
        Long measurementId = ThreadLocalRandom.current().nextLong();
        this.enabledServices.forEach(metricsService -> metricsService.start(measurementId, context));
        return measurementId;
    }

    public void end(Long measurementId) {
        this.enabledServices.forEach(metricsService -> metricsService.end(measurementId));
    }
}

