/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.execution.metrics;

import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.spi.MetricsService;
import io.smallrye.graphql.spi.config.Config;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ThreadLocalRandom;
import org.jboss.logging.Logger;

public class MetricsEmitter {
    private static final Logger LOG = Logger.getLogger(MetricsEmitter.class);
    private static final ThreadLocal<MetricsEmitter> metricsEmitters = ThreadLocal.withInitial(MetricsEmitter::new);
    private final List<MetricsService> enabledServices;

    public static MetricsEmitter getInstance() {
        return metricsEmitters.get();
    }

    private MetricsEmitter() {
        Config config = Config.get();
        boolean enabled = config.getConfigValue("smallrye.graphql.metrics.enabled", Boolean.TYPE, false);
        ServiceLoader<MetricsService> metricService = ServiceLoader.load(MetricsService.class);
        Iterator<MetricsService> it = metricService.iterator();
        ArrayList<MetricsService> enabledServices = new ArrayList<MetricsService>();
        while (enabled && it.hasNext()) {
            try {
                enabledServices.add(it.next());
            }
            catch (Throwable throwable) {}
        }
        this.enabledServices = enabledServices;
    }

    public void subscriptionStart(Context context) {
        this.enabledServices.forEach(metricsService -> metricsService.subscriptionStart(context));
    }

    public void subscriptionEnd(Context context) {
        this.enabledServices.forEach(metricsService -> metricsService.subscriptionEnd(context));
    }

    public Long start(Context context) {
        Long measurementId = ThreadLocalRandom.current().nextLong();
        this.enabledServices.forEach(metricsService -> metricsService.start(measurementId, context));
        return measurementId;
    }

    public void end(Long measurementId) {
        this.enabledServices.forEach(metricsService -> metricsService.end(measurementId));
    }
}

