/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import com.apollographql.federation.graphqljava.Federation;
import graphql.introspection.Introspection;
import graphql.schema.Coercing;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import graphql.schema.visibility.BlockedFields;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.schema.visibility.NoIntrospectionGraphqlFieldVisibility;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.SmallRyeGraphQLServerMessages;
import io.smallrye.graphql.bootstrap.DataFetcherFactory;
import io.smallrye.graphql.bootstrap.FederationDataFetcher;
import io.smallrye.graphql.bootstrap.LinkProcessor;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.datafetcher.BatchDataFetcher;
import io.smallrye.graphql.execution.datafetcher.CollectionCreator;
import io.smallrye.graphql.execution.datafetcher.PlugableDataFetcher;
import io.smallrye.graphql.execution.error.ErrorInfoMap;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.execution.resolver.InterfaceOutputRegistry;
import io.smallrye.graphql.execution.resolver.InterfaceResolver;
import io.smallrye.graphql.execution.resolver.UnionOutputRegistry;
import io.smallrye.graphql.execution.resolver.UnionResolver;
import io.smallrye.graphql.json.JsonBCreator;
import io.smallrye.graphql.json.JsonInputRegistry;
import io.smallrye.graphql.scalar.GraphQLScalarTypes;
import io.smallrye.graphql.scalar.custom.FloatCoercing;
import io.smallrye.graphql.scalar.custom.IntCoercing;
import io.smallrye.graphql.scalar.custom.StringCoercing;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.CustomScalarType;
import io.smallrye.graphql.schema.model.DirectiveArgument;
import io.smallrye.graphql.schema.model.DirectiveInstance;
import io.smallrye.graphql.schema.model.DirectiveType;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.EnumValue;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Group;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.schema.model.UnionType;
import io.smallrye.graphql.schema.model.Wrapper;
import io.smallrye.graphql.spi.ClassloadingService;
import io.smallrye.graphql.spi.LookupService;
import io.smallrye.graphql.spi.config.Config;
import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.bind.Jsonb;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.graphql.Name;

public class Bootstrap {
    private final Schema schema;
    private final EventEmitter eventEmitter = EventEmitter.getInstance();
    private final DataFetcherFactory dataFetcherFactory = new DataFetcherFactory();
    private final Set<GraphQLDirective> directiveTypes = new LinkedHashSet<GraphQLDirective>();
    private final Map<String, GraphQLEnumType> enumMap = new HashMap<String, GraphQLEnumType>();
    private final Map<String, GraphQLInterfaceType> interfaceMap = new HashMap<String, GraphQLInterfaceType>();
    private final Map<String, GraphQLUnionType> unionMap = new HashMap<String, GraphQLUnionType>();
    private final Map<String, GraphQLInputObjectType> inputMap = new HashMap<String, GraphQLInputObjectType>();
    private final Map<String, GraphQLObjectType> typeMap = new HashMap<String, GraphQLObjectType>();
    private GraphQLSchema graphQLSchema;
    private final GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
    private final ClassloadingService classloadingService = ClassloadingService.get();
    private LinkProcessor linkProcessor = null;
    private static final String QUERY = "Query";
    private static final String QUERY_DESCRIPTION = "Query root";
    private static final String MUTATION = "Mutation";
    private static final String MUTATION_DESCRIPTION = "Mutation root";
    private static final String SUBSCRIPTION = "Subscription";
    private static final String SUBSCRIPTION_DESCRIPTION = "Subscription root";
    private static final String COMMA = ",";
    private static final JsonReaderFactory jsonReaderFactory = Json.createReaderFactory(null);
    private static final String CONTEXT = "io.smallrye.graphql.api.Context";
    private static final String OBSERVES = "javax.enterprise.event.Observes";
    private static final List<String> IGNORABLE_ARGUMENTS = Arrays.asList("io.smallrye.graphql.api.Context", "javax.enterprise.event.Observes");
    private static final String AUTOMAP_KEY_NAME = "key";
    private static final String AUTOMAP_KEY_DESC = "Get entry/entries for a certain key/s";
    private static final String AUTOMAP_KEY_KEY = "K";
    private static final String AUTOMAP_KEY_INPUT = "Input";

    public static GraphQLSchema bootstrap(Schema schema) {
        return Bootstrap.bootstrap(schema, false);
    }

    public static GraphQLSchema bootstrap(Schema schema, boolean skipInjectionValidation) {
        if (schema != null && schema.hasOperations()) {
            Bootstrap bootstrap = new Bootstrap(schema, skipInjectionValidation);
            bootstrap.generateGraphQLSchema();
            return bootstrap.graphQLSchema;
        }
        SmallRyeGraphQLServerLogging.log.emptyOrNullSchema();
        return null;
    }

    private Bootstrap(Schema schema, boolean skipInjectionValidation) {
        this.schema = schema;
        if (Config.get().isFederationEnabled()) {
            this.linkProcessor = new LinkProcessor(schema);
        }
        if (!Boolean.getBoolean("test.skip.injection.validation") && !skipInjectionValidation) {
            this.verifyInjectionIsAvailable();
        }
    }

    private void verifyInjectionIsAvailable() {
        LookupService lookupService = LookupService.get();
        Stream.of(this.schema.getQueries().stream().map(Operation::getClassName), this.schema.getMutations().stream().map(Operation::getClassName), this.schema.getGroupedQueries().values().stream().flatMap(Collection::stream).map(Operation::getClassName), this.schema.getGroupedMutations().values().stream().flatMap(Collection::stream).map(Operation::getClassName)).flatMap(stream -> stream).distinct().forEach(beanClassName -> {
            if (!lookupService.isResolvable(this.classloadingService.loadClass((String)beanClassName))) {
                throw SmallRyeGraphQLServerMessages.msg.canNotInjectClass((String)beanClassName, null);
            }
        });
    }

    private void generateGraphQLSchema() {
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        if (Config.get().isFederationEnabled()) {
            this.linkProcessor.createLinkImports();
        }
        this.createGraphQLCustomScalarTypes();
        this.createGraphQLEnumTypes();
        this.createGraphQLDirectiveTypes();
        this.createGraphQLInterfaceTypes();
        this.createGraphQLUnionTypes();
        this.createGraphQLObjectTypes();
        this.createGraphQLInputObjectTypes();
        this.addQueries(schemaBuilder);
        this.addMutations(schemaBuilder);
        this.addSubscriptions(schemaBuilder);
        schemaBuilder.withSchemaAppliedDirectives((Collection)Arrays.stream(this.createGraphQLDirectives(this.schema.getDirectiveInstances())).map(GraphQLDirective::toAppliedDirective).collect(Collectors.toList()));
        schemaBuilder.description(this.schema.getDescription());
        schemaBuilder.additionalDirectives(this.directiveTypes);
        schemaBuilder.additionalTypes(new HashSet<GraphQLEnumType>(this.enumMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInterfaceType>(this.interfaceMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLUnionType>(this.unionMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLObjectType>(this.typeMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInputObjectType>(this.inputMap.values()));
        this.codeRegistryBuilder.fieldVisibility(this.getGraphqlFieldVisibility());
        schemaBuilder = schemaBuilder.codeRegistry(this.codeRegistryBuilder.build());
        ErrorInfoMap.register(this.schema.getErrors());
        schemaBuilder = this.eventEmitter.fireBeforeSchemaBuild(schemaBuilder);
        Map<String, Jsonb> overrides = this.eventEmitter.fireOverrideJsonbConfig();
        JsonInputRegistry.override(overrides);
        if (Config.get().isFederationEnabled()) {
            SmallRyeGraphQLServerLogging.log.enableFederation();
            GraphQLSchema rawSchema = schemaBuilder.build();
            this.graphQLSchema = Federation.transform((GraphQLSchema)rawSchema).fetchEntities((DataFetcher)new FederationDataFetcher(rawSchema.getQueryType(), rawSchema.getCodeRegistry())).resolveEntityType(this.fetchEntityType()).setFederation2(true).build();
        } else {
            this.graphQLSchema = schemaBuilder.build();
        }
    }

    private TypeResolver fetchEntityType() {
        return env -> {
            Object src = env.getObject();
            if (src == null) {
                return null;
            }
            Name annotation = src.getClass().getAnnotation(Name.class);
            String typeName = annotation == null ? src.getClass().getSimpleName() : annotation.value();
            GraphQLObjectType result = env.getSchema().getObjectType(typeName);
            if (result == null) {
                throw new RuntimeException("can't resolve federated entity type " + src.getClass().getName());
            }
            return result;
        };
    }

    private void createGraphQLCustomScalarTypes() {
        if (this.schema.hasCustomScalarTypes()) {
            for (CustomScalarType customScalarType : this.schema.getCustomScalarTypes()) {
                this.createGraphQLCustomScalarType(customScalarType);
            }
        }
    }

    private void createGraphQLCustomScalarType(CustomScalarType customScalarType) {
        String scalarName = customScalarType.getName();
        Coercing<?, ?> coercing = Bootstrap.getCoercing(customScalarType);
        GraphQLScalarType graphQLScalarType = GraphQLScalarType.newScalar().name(scalarName).description("Scalar for " + scalarName).coercing(coercing).build();
        GraphQLScalarTypes.registerCustomScalar(scalarName, customScalarType.getClassName(), graphQLScalarType);
    }

    private static Coercing<?, ?> getCoercing(CustomScalarType customScalarType) {
        CustomScalarType.CustomScalarPrimitiveType primitiveType = customScalarType.getCustomScalarPrimitiveType();
        Object coercing = null;
        switch (primitiveType) {
            case STRING_TYPE: {
                coercing = new StringCoercing(customScalarType.getClassName());
                break;
            }
            case INT_TYPE: {
                coercing = new IntCoercing(customScalarType.getClassName());
                break;
            }
            case FLOAT_TYPE: {
                coercing = new FloatCoercing(customScalarType.getClassName());
            }
        }
        return coercing;
    }

    private void createGraphQLDirectiveTypes() {
        if (this.schema.hasDirectiveTypes()) {
            for (DirectiveType directiveType : this.schema.getDirectiveTypes()) {
                this.createGraphQLDirectiveType(directiveType);
            }
        }
    }

    private void createGraphQLDirectiveType(DirectiveType directiveType) {
        GraphQLDirective.Builder directiveBuilder = GraphQLDirective.newDirective().name(Config.get().isFederationEnabled() ? this.linkProcessor.newNameDirective(directiveType.getName()) : directiveType.getName()).description(directiveType.getDescription());
        for (String location : directiveType.getLocations()) {
            directiveBuilder.validLocation(Introspection.DirectiveLocation.valueOf((String)location));
        }
        for (String argumentName : directiveType.argumentNames()) {
            DirectiveArgument argumentType = directiveType.argumentType(argumentName);
            GraphQLInputType inputType = this.createGraphQLInputType((Field)argumentType);
            GraphQLArgument.Builder argumentBuilder = GraphQLArgument.newArgument().name(argumentName).type(inputType);
            if (argumentType.hasDefaultValue()) {
                argumentBuilder = argumentBuilder.defaultValueProgrammatic(this.sanitizeDefaultValue((Field)argumentType));
            }
            directiveBuilder = directiveBuilder.argument(argumentBuilder.build());
        }
        directiveBuilder.repeatable(directiveType.isRepeatable());
        this.directiveTypes.add(directiveBuilder.build());
    }

    private void addQueries(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType.Builder queryBuilder = GraphQLObjectType.newObject().name(QUERY).description(QUERY_DESCRIPTION);
        if (this.schema.hasQueries()) {
            this.addRootObject(queryBuilder, this.schema.getQueries(), QUERY);
        }
        if (this.schema.hasGroupedQueries()) {
            this.addGroupedRootObject(queryBuilder, this.schema.getGroupedQueries(), QUERY);
        }
        GraphQLObjectType query = queryBuilder.build();
        schemaBuilder.query(query);
    }

    private void addMutations(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType mutation;
        GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject().name(MUTATION).description(MUTATION_DESCRIPTION);
        if (this.schema.hasMutations()) {
            this.addRootObject(mutationBuilder, this.schema.getMutations(), MUTATION);
        }
        if (this.schema.hasGroupedMutations()) {
            this.addGroupedRootObject(mutationBuilder, this.schema.getGroupedMutations(), MUTATION);
        }
        if ((mutation = mutationBuilder.build()).getFieldDefinitions() != null && !mutation.getFieldDefinitions().isEmpty()) {
            schemaBuilder.mutation(mutation);
        }
    }

    private void addSubscriptions(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType subscription;
        GraphQLObjectType.Builder subscriptionBuilder = GraphQLObjectType.newObject().name(SUBSCRIPTION).description(SUBSCRIPTION_DESCRIPTION);
        if (this.schema.hasSubscriptions()) {
            this.addRootObject(subscriptionBuilder, this.schema.getSubscriptions(), SUBSCRIPTION);
        }
        if (this.schema.hasGroupedSubscriptions()) {
            this.addGroupedRootObject(subscriptionBuilder, this.schema.getGroupedSubscriptions(), SUBSCRIPTION);
        }
        if ((subscription = subscriptionBuilder.build()).getFieldDefinitions() != null && !subscription.getFieldDefinitions().isEmpty()) {
            schemaBuilder.subscription(subscription);
        }
    }

    private void addRootObject(GraphQLObjectType.Builder rootBuilder, Set<Operation> operations, String rootName) {
        for (Operation operation : operations) {
            operation = this.eventEmitter.fireCreateOperation(operation);
            GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(rootName, operation);
            rootBuilder.field(graphQLFieldDefinition);
        }
    }

    private void addGroupedRootObject(GraphQLObjectType.Builder rootBuilder, Map<Group, Set<Operation>> operationMap, String rootName) {
        Set<Map.Entry<Group, Set<Operation>>> operationsSet = operationMap.entrySet();
        for (Map.Entry<Group, Set<Operation>> operationsEntry : operationsSet) {
            Group group = operationsEntry.getKey();
            Set<Operation> operations = operationsEntry.getValue();
            GraphQLObjectType namedType = this.createNamedType(rootName, group, operations);
            GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name(group.getName()).description(group.getDescription());
            graphQLFieldDefinitionBuilder.type((GraphQLOutputType)namedType);
            DataFetcher dummyDataFetcher = dfe -> namedType.getName();
            GraphQLFieldDefinition namedField = graphQLFieldDefinitionBuilder.build();
            this.codeRegistryBuilder.dataFetcherIfAbsent(FieldCoordinates.coordinates((String)rootName, (String)namedField.getName()), dummyDataFetcher);
            rootBuilder.field(namedField);
        }
    }

    private GraphQLObjectType createNamedType(String parent, Group group, Set<Operation> operations) {
        String namedTypeName = group.getName() + parent;
        GraphQLObjectType.Builder objectTypeBuilder = GraphQLObjectType.newObject().name(namedTypeName).description(group.getDescription());
        for (Operation operation : operations) {
            operation = this.eventEmitter.fireCreateOperation(operation);
            GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(namedTypeName, operation);
            objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
        }
        return objectTypeBuilder.build();
    }

    private void createGraphQLEnumTypes() {
        if (this.schema.hasEnums()) {
            for (EnumType enumType : this.schema.getEnums().values()) {
                this.createGraphQLEnumType(enumType);
            }
        }
    }

    private void createGraphQLEnumType(EnumType enumType) {
        GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(Config.get().isFederationEnabled() ? this.linkProcessor.newName(enumType.getName()) : enumType.getName()).description(enumType.getDescription());
        if (enumType.hasDirectiveInstances()) {
            enumBuilder = enumBuilder.withDirectives(this.createGraphQLDirectives(enumType.getDirectiveInstances()));
        }
        for (EnumValue value : enumType.getValues()) {
            GraphQLEnumValueDefinition.Builder definitionBuilder = GraphQLEnumValueDefinition.newEnumValueDefinition().name(value.getValue()).value((Object)value.getValue()).description(value.getDescription());
            if (value.hasDirectiveInstances()) {
                definitionBuilder = definitionBuilder.withDirectives(this.createGraphQLDirectives(value.getDirectiveInstances()));
            }
            enumBuilder = enumBuilder.value(definitionBuilder.build());
        }
        GraphQLEnumType graphQLEnumType = enumBuilder.build();
        this.enumMap.put(enumType.getClassName(), graphQLEnumType);
    }

    private void createGraphQLInterfaceTypes() {
        if (this.schema.hasInterfaces()) {
            for (Type interfaceType : this.schema.getInterfaces().values()) {
                this.createGraphQLInterfaceType(interfaceType);
            }
        }
    }

    private void createGraphQLInterfaceType(Type interfaceType) {
        GraphQLInterfaceType.Builder interfaceTypeBuilder = GraphQLInterfaceType.newInterface().name(interfaceType.getName()).description(interfaceType.getDescription());
        if (interfaceType.hasFields()) {
            interfaceTypeBuilder = interfaceTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields((Reference)interfaceType, interfaceType.getFields().values()));
        }
        if (interfaceType.hasDirectiveInstances()) {
            for (DirectiveInstance directiveInstance : interfaceType.getDirectiveInstances()) {
                interfaceTypeBuilder.withDirective(this.createGraphQLDirectiveFrom(directiveInstance));
            }
        }
        if (interfaceType.hasInterfaces()) {
            DirectiveInstance directiveInstance;
            Iterator interfaces = interfaceType.getInterfaces();
            directiveInstance = interfaces.iterator();
            while (directiveInstance.hasNext()) {
                Reference i = (Reference)directiveInstance.next();
                interfaceTypeBuilder = interfaceTypeBuilder.withInterface(GraphQLTypeReference.typeRef((String)i.getName()));
            }
        }
        if (interfaceType.hasOperations()) {
            for (Operation operation : interfaceType.getOperations().values()) {
                String name = operation.getName();
                if (!interfaceType.hasBatchOperation(name)) {
                    operation = this.eventEmitter.fireCreateOperation(operation);
                    GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(interfaceType.getName(), operation);
                    interfaceTypeBuilder = interfaceTypeBuilder.field(graphQLFieldDefinition);
                    continue;
                }
                SmallRyeGraphQLServerLogging.log.duplicateOperation(operation.getName());
            }
        }
        if (interfaceType.hasBatchOperations()) {
            for (Operation operation : interfaceType.getBatchOperations().values()) {
                operation = this.eventEmitter.fireCreateOperation(operation);
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromBatchOperation(interfaceType.getName(), operation);
                interfaceTypeBuilder = interfaceTypeBuilder.field(graphQLFieldDefinition);
            }
        }
        GraphQLInterfaceType graphQLInterfaceType = interfaceTypeBuilder.build();
        this.codeRegistryBuilder.typeResolver(graphQLInterfaceType, (TypeResolver)new InterfaceResolver(interfaceType));
        this.interfaceMap.put(interfaceType.getName(), graphQLInterfaceType);
    }

    private void createGraphQLUnionTypes() {
        if (this.schema.hasUnions() && this.schema.hasTypes()) {
            for (UnionType unionType : this.schema.getUnions().values()) {
                this.createGraphQLUnionType(unionType);
            }
        }
    }

    private void createGraphQLUnionType(UnionType unionType) {
        GraphQLUnionType.Builder unionTypeBuilder = GraphQLUnionType.newUnionType().name(unionType.getName()).description(unionType.getDescription());
        for (Type type : this.schema.getTypes().values()) {
            if (!type.isMemberOfUnion((Reference)unionType)) continue;
            unionTypeBuilder.possibleType(GraphQLTypeReference.typeRef((String)type.getName()));
        }
        if (unionType.hasDirectiveInstances()) {
            for (DirectiveInstance directiveInstance : unionType.getDirectiveInstances()) {
                unionTypeBuilder.withDirective(this.createGraphQLDirectiveFrom(directiveInstance));
            }
        }
        GraphQLUnionType graphQLUnionType = unionTypeBuilder.build();
        this.codeRegistryBuilder.typeResolver(graphQLUnionType, (TypeResolver)new UnionResolver(unionType));
        this.unionMap.put(unionType.getName(), graphQLUnionType);
    }

    private void createGraphQLInputObjectTypes() {
        if (this.schema.hasInputs()) {
            for (InputType inputType : this.schema.getInputs().values()) {
                this.createGraphQLInputObjectType(inputType);
            }
        }
    }

    private GraphQLInputObjectType createGraphQLInputObjectType(InputType inputType) {
        GraphQLInputObjectType.Builder inputObjectTypeBuilder = GraphQLInputObjectType.newInputObject().name(inputType.getName()).description(inputType.getDescription());
        if (inputType.hasDirectiveInstances()) {
            inputObjectTypeBuilder = inputObjectTypeBuilder.withDirectives(this.createGraphQLDirectives(inputType.getDirectiveInstances()));
        }
        if (inputType.hasFields()) {
            inputObjectTypeBuilder = inputObjectTypeBuilder.fields(this.createGraphQLInputObjectFieldsFromFields(inputType.getFields().values()));
            JsonInputRegistry.register(inputType);
        }
        GraphQLInputObjectType graphQLInputObjectType = inputObjectTypeBuilder.build();
        if (!this.inputMap.containsKey(inputType.getName())) {
            this.inputMap.put(inputType.getName(), graphQLInputObjectType);
        }
        return graphQLInputObjectType;
    }

    private void createGraphQLObjectTypes() {
        if (this.schema.hasTypes()) {
            for (Type type : this.schema.getTypes().values()) {
                this.createGraphQLObjectType(type);
            }
        }
    }

    private void createGraphQLObjectType(Type type) {
        GraphQLObjectType.Builder objectTypeBuilder = GraphQLObjectType.newObject().name(type.getName()).description(type.getDescription());
        if (type.hasDirectiveInstances()) {
            for (DirectiveInstance directiveInstance : type.getDirectiveInstances()) {
                objectTypeBuilder.withDirective(this.createGraphQLDirectiveFrom(directiveInstance));
            }
        }
        if (type.hasFields()) {
            objectTypeBuilder = objectTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields((Reference)type, type.getFields().values()));
        }
        if (type.hasOperations()) {
            for (Operation operation : type.getOperations().values()) {
                String name = operation.getName();
                if (!type.hasBatchOperation(name)) {
                    operation = this.eventEmitter.fireCreateOperation(operation);
                    GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(type.getName(), operation);
                    objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
                    continue;
                }
                SmallRyeGraphQLServerLogging.log.duplicateOperation(operation.getName());
            }
        }
        if (type.hasBatchOperations()) {
            for (Operation operation : type.getBatchOperations().values()) {
                operation = this.eventEmitter.fireCreateOperation(operation);
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromBatchOperation(type.getName(), operation);
                objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
            }
        }
        if (type.hasInterfaces()) {
            Set interfaces = type.getInterfaces();
            for (Reference i : interfaces) {
                if (!this.interfaceMap.containsKey(i.getName())) continue;
                GraphQLInterfaceType graphQLInterfaceType = this.interfaceMap.get(i.getName());
                objectTypeBuilder = objectTypeBuilder.withInterface(graphQLInterfaceType);
            }
        }
        GraphQLObjectType graphQLObjectType = objectTypeBuilder.build();
        this.typeMap.put(type.getName(), graphQLObjectType);
        InterfaceOutputRegistry.register(type, graphQLObjectType);
        UnionOutputRegistry.register(type, graphQLObjectType);
    }

    private GraphQLDirective createGraphQLDirectiveFrom(DirectiveInstance directiveInstance) {
        DirectiveType directiveType = directiveInstance.getType();
        GraphQLDirective.Builder directiveBuilder = GraphQLDirective.newDirective().name(Config.get().isFederationEnabled() ? this.linkProcessor.newNameDirective(directiveType.getName()) : directiveType.getName()).repeatable(directiveType.isRepeatable());
        for (Map.Entry entry : directiveInstance.getValues().entrySet()) {
            String argumentName = (String)entry.getKey();
            DirectiveArgument argumentType = directiveType.argumentType(argumentName);
            if (argumentType == null) {
                throw new IllegalArgumentException("Definition of directive type @" + directiveType.getName() + " does not contain an argument named " + argumentName + ", but directive instance " + directiveInstance + " does contain a value for it");
            }
            GraphQLInputType inputType = this.createGraphQLInputType((Field)argumentType);
            GraphQLArgument.Builder argumentBuilder = GraphQLArgument.newArgument().name(argumentName).type(inputType).valueProgrammatic(entry.getValue());
            if (argumentType.hasDefaultValue()) {
                argumentBuilder = argumentBuilder.defaultValueProgrammatic(this.sanitizeDefaultValue((Field)argumentType));
            }
            directiveBuilder.argument(argumentBuilder.build());
        }
        for (String argumentName : directiveType.argumentNames()) {
            if (directiveInstance.getValues().containsKey(argumentName)) continue;
            DirectiveArgument argumentType = directiveType.argumentType(argumentName);
            if (argumentType.isNotNull() && !argumentType.hasDefaultValue()) {
                throw new IllegalArgumentException("Definition of type @" + directiveType.getName() + " contains a required argument named " + argumentName + ", but directive instance " + directiveInstance + " does not contain a value for it");
            }
            GraphQLInputType inputType = this.createGraphQLInputType((Field)argumentType);
            GraphQLArgument.Builder argumentBuilder = GraphQLArgument.newArgument().name(argumentName).type(inputType);
            if (argumentType.hasDefaultValue()) {
                argumentBuilder = argumentBuilder.defaultValueProgrammatic(this.sanitizeDefaultValue((Field)argumentType));
            }
            directiveBuilder.argument(argumentBuilder.build());
        }
        directiveBuilder.validLocations((Introspection.DirectiveLocation[])directiveInstance.getType().getLocations().stream().map(location -> (Introspection.DirectiveLocation)Introspection.DirectiveLocation.valueOf(Introspection.DirectiveLocation.class, (String)location)).toArray(Introspection.DirectiveLocation[]::new));
        return directiveBuilder.build();
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromBatchOperation(String operationTypeName, Operation operation) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType((Field)operation, true));
        if (operation.hasArguments()) {
            fieldBuilder = fieldBuilder.arguments(this.createGraphQLArguments(operation.getArguments()));
        }
        BatchDataFetcher datafetcher = new BatchDataFetcher(operation, this.getTypeForField((Field)operation));
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)operationTypeName, (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromOperation(String operationTypeName, Operation operation) {
        Optional<GraphQLArgument> autoMapArgument;
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType((Field)operation, false));
        if (operation.hasArguments()) {
            fieldBuilder = fieldBuilder.arguments(this.createGraphQLArguments(operation.getArguments()));
        }
        if ((autoMapArgument = this.getAutoMapArgument((Field)operation)).isPresent()) {
            fieldBuilder.argument(autoMapArgument.get());
        }
        if (operation.hasDirectiveInstances()) {
            fieldBuilder = fieldBuilder.withDirectives(this.createGraphQLDirectives(operation.getDirectiveInstances()));
        }
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        DataFetcher datafetcher = this.dataFetcherFactory.getDataFetcher(operation, this.getTypeForField((Field)operation));
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)operationTypeName, (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private GraphQLDirective[] createGraphQLDirectives(Collection<DirectiveInstance> directiveInstances) {
        return (GraphQLDirective[])directiveInstances.stream().map(this::createGraphQLDirectiveFrom).toArray(GraphQLDirective[]::new);
    }

    private List<GraphQLFieldDefinition> createGraphQLFieldDefinitionsFromFields(Reference owner, Collection<Field> fields) {
        ArrayList<GraphQLFieldDefinition> graphQLFieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        for (Field field : fields) {
            graphQLFieldDefinitions.add(this.createGraphQLFieldDefinitionFromField(owner, field));
        }
        return graphQLFieldDefinitions;
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromField(Reference owner, Field field) {
        Optional<GraphQLArgument> autoMapArgument;
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(field.getName()).description(field.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType(field, false));
        if (field.hasDirectiveInstances()) {
            for (DirectiveInstance directiveInstance : field.getDirectiveInstances()) {
                fieldBuilder.withDirective(this.createGraphQLDirectiveFrom(directiveInstance));
            }
        }
        if ((autoMapArgument = this.getAutoMapArgument(field)).isPresent()) {
            fieldBuilder.argument(autoMapArgument.get());
        }
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        PlugableDataFetcher datafetcher = this.dataFetcherFactory.getFieldDataFetcher(field, this.getTypeForField(field), owner);
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)owner.getName(), (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private Optional<GraphQLArgument> getAutoMapArgument(Field field) {
        if (field.hasWrapper() && field.getWrapper().isMap() && !field.isAdaptingWith()) {
            Map parametrizedTypeArguments = field.getReference().getAllParametrizedTypes();
            Reference keyReference = (Reference)parametrizedTypeArguments.get(AUTOMAP_KEY_KEY);
            ReferenceType type = keyReference.getType();
            if (type.equals((Object)ReferenceType.SCALAR) || type.equals((Object)ReferenceType.ENUM)) {
                GraphQLInputType keyInput = this.getGraphQLInputType(keyReference);
                GraphQLArgument byKey = GraphQLArgument.newArgument().name(AUTOMAP_KEY_NAME).description(AUTOMAP_KEY_DESC).type((GraphQLInputType)GraphQLList.list((GraphQLType)keyInput)).build();
                return Optional.of(byKey);
            }
            String complexKeyName = keyReference.getName() + AUTOMAP_KEY_INPUT;
            if (this.schema.getInputs().containsKey(complexKeyName)) {
                InputType complexKeyInputType = (InputType)this.schema.getInputs().get(complexKeyName);
                GraphQLInputObjectType keyInput = this.inputMap.containsKey(complexKeyInputType.getName()) ? this.inputMap.get(complexKeyInputType.getName()) : this.createGraphQLInputObjectType(complexKeyInputType);
                GraphQLArgument byKey = GraphQLArgument.newArgument().name(AUTOMAP_KEY_NAME).description(AUTOMAP_KEY_DESC).type((GraphQLInputType)GraphQLList.list((GraphQLType)keyInput)).build();
                return Optional.of(byKey);
            }
        }
        return Optional.empty();
    }

    private List<GraphQLInputObjectField> createGraphQLInputObjectFieldsFromFields(Collection<Field> fields) {
        ArrayList<GraphQLInputObjectField> graphQLInputObjectFields = new ArrayList<GraphQLInputObjectField>();
        for (Field field : fields) {
            graphQLInputObjectFields.add(this.createGraphQLInputObjectFieldFromField(field));
        }
        return graphQLInputObjectFields;
    }

    private GraphQLInputObjectField createGraphQLInputObjectFieldFromField(Field field) {
        GraphQLInputObjectField.Builder inputFieldBuilder = GraphQLInputObjectField.newInputObjectField().name(field.getName()).description(field.getDescription());
        inputFieldBuilder = inputFieldBuilder.type(this.createGraphQLInputType(field));
        if (field.hasDirectiveInstances()) {
            for (DirectiveInstance directiveInstance : field.getDirectiveInstances()) {
                inputFieldBuilder.withDirective(this.createGraphQLDirectiveFrom(directiveInstance));
            }
        }
        if (field.hasDefaultValue()) {
            inputFieldBuilder = inputFieldBuilder.defaultValueProgrammatic(this.sanitizeDefaultValue(field));
        }
        return inputFieldBuilder.build();
    }

    private GraphQLInputType createGraphQLInputType(Field field) {
        GraphQLInputType graphQLInputType = this.getGraphQLInputType(field.getReference());
        Wrapper wrapper = this.dataFetcherFactory.unwrap(field, false);
        if (wrapper != null && wrapper.isCollectionOrArrayOrMap()) {
            Stack<Wrapper> stackOfWrappers = new Stack<Wrapper>();
            for (Wrapper currentWrapper = wrapper; currentWrapper != null; currentWrapper = currentWrapper.getWrapper()) {
                stackOfWrappers.add(currentWrapper);
            }
            do {
                if (!(wrapper = (Wrapper)stackOfWrappers.pop()).isCollectionOrArrayOrMap()) continue;
                if (wrapper.isWrappedTypeNotNull()) {
                    graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
                }
                graphQLInputType = GraphQLList.list((GraphQLType)graphQLInputType);
            } while (!stackOfWrappers.empty());
        }
        if (field.isNotNull()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        return graphQLInputType;
    }

    private GraphQLOutputType createGraphQLOutputType(Field field, boolean isBatch) {
        GraphQLOutputType graphQLOutputType = this.referenceGraphQLOutputType(field);
        Wrapper wrapper = this.dataFetcherFactory.unwrap(field, isBatch);
        if (wrapper != null && wrapper.isCollectionOrArrayOrMap()) {
            Stack<Wrapper> stackOfWrappers = new Stack<Wrapper>();
            for (Wrapper currentWrapper = wrapper; currentWrapper != null; currentWrapper = currentWrapper.getWrapper()) {
                stackOfWrappers.add(currentWrapper);
            }
            do {
                if (!(wrapper = (Wrapper)stackOfWrappers.pop()).isCollectionOrArrayOrMap()) continue;
                if (wrapper.isWrappedTypeNotNull()) {
                    graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
                }
                graphQLOutputType = GraphQLList.list((GraphQLType)graphQLOutputType);
            } while (!stackOfWrappers.empty());
        }
        if (field.isNotNull()) {
            graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
        }
        return graphQLOutputType;
    }

    private GraphQLOutputType referenceGraphQLOutputType(Field field) {
        Reference reference = this.getCorrectFieldReference(field);
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(reference);
            }
            case ENUM: {
                return (GraphQLOutputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private GraphQLInputType referenceGraphQLInputType(Field field) {
        Reference reference = this.getCorrectFieldReference(field);
        return this.getGraphQLInputType(reference);
    }

    private GraphQLInputType getGraphQLInputType(Reference reference) {
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(reference);
            }
            case ENUM: {
                return (GraphQLInputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private Reference getCorrectFieldReference(Field field) {
        if (field.getReference().isAdaptingWith()) {
            return field.getReference().getAdaptWith().getToReference();
        }
        if (field.isAdaptingWith()) {
            return field.getAdaptWith().getToReference();
        }
        if (field.getReference().isAdaptingTo()) {
            return field.getReference().getAdaptTo().getReference();
        }
        if (field.isAdaptingTo()) {
            return field.getAdaptTo().getReference();
        }
        return field.getReference();
    }

    private GraphQLScalarType getCorrectScalarType(Reference fieldReference) {
        String newName;
        GraphQLScalarType graphQLScalarType = GraphQLScalarTypes.getScalarByName(fieldReference.getName());
        String string = newName = Config.get().isFederationEnabled() ? this.linkProcessor.newName(fieldReference.getName()) : fieldReference.getName();
        if (fieldReference.getName().equals(newName)) {
            return graphQLScalarType;
        }
        GraphQLScalarType newGraphQLScalarType = GraphQLScalarTypes.getScalarByName(newName);
        if (newGraphQLScalarType == null) {
            newGraphQLScalarType = GraphQLScalarType.newScalar((GraphQLScalarType)graphQLScalarType).name(newName).build();
            GraphQLScalarTypes.registerCustomScalar(newName, fieldReference.getClassName(), newGraphQLScalarType);
        }
        return newGraphQLScalarType;
    }

    private List<GraphQLArgument> createGraphQLArguments(List<Argument> arguments) {
        ArrayList<GraphQLArgument> graphQLArguments = new ArrayList<GraphQLArgument>();
        for (Argument argument : arguments) {
            if (argument.isSourceArgument() || IGNORABLE_ARGUMENTS.contains(argument.getReference().getClassName())) continue;
            graphQLArguments.add(this.createGraphQLArgument(argument));
        }
        return graphQLArguments;
    }

    private GraphQLArgument createGraphQLArgument(Argument argument) {
        GraphQLArgument.Builder argumentBuilder = GraphQLArgument.newArgument().name(argument.getName()).description(argument.getDescription());
        if (argument.hasDefaultValue()) {
            argumentBuilder = argumentBuilder.defaultValueProgrammatic(this.sanitizeDefaultValue((Field)argument));
        }
        GraphQLInputType graphQLInputType = this.createGraphQLInputType((Field)argument);
        argumentBuilder = argumentBuilder.type(graphQLInputType);
        if (argument.hasDirectiveInstances()) {
            for (DirectiveInstance directiveInstance : argument.getDirectiveInstances()) {
                argumentBuilder.withDirective(this.createGraphQLDirectiveFrom(directiveInstance));
            }
        }
        return argumentBuilder.build();
    }

    private Object sanitizeDefaultValue(Field field) {
        String jsonString = field.getDefaultValue();
        if (jsonString == null) {
            return null;
        }
        if (this.isJsonString(jsonString)) {
            Class<Object> deserType;
            Wrapper wrapper = this.dataFetcherFactory.unwrap(field, false);
            if (wrapper != null && wrapper.isCollectionOrArrayOrMap()) {
                deserType = this.classloadingService.loadClass(field.getWrapper().getWrapperClassName());
                if (Collection.class.isAssignableFrom(deserType)) {
                    deserType = CollectionCreator.newCollection(field.getWrapper().getWrapperClassName(), 0).getClass();
                }
            } else {
                Reference reference = this.getCorrectFieldReference(field);
                ReferenceType referenceType = reference.getType();
                deserType = referenceType.equals((Object)ReferenceType.INPUT) || referenceType.equals((Object)ReferenceType.TYPE) ? Map.class : this.classloadingService.loadClass(field.getReference().getClassName());
            }
            Jsonb jsonB = JsonBCreator.getJsonB(deserType.getName());
            return jsonB.fromJson(jsonString, deserType);
        }
        if (Classes.isNumberLikeType(field.getReference().getGraphQLClassName())) {
            return new BigDecimal(jsonString);
        }
        if (Classes.isBoolean(field.getReference().getGraphQLClassName())) {
            return Boolean.parseBoolean(jsonString);
        }
        return jsonString;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isJsonString(String string) {
        if (string != null && !string.isEmpty() && (string.contains("{") || string.contains("["))) {
            try (StringReader stringReader = new StringReader(string);){
                boolean bl;
                block14: {
                    JsonReader jsonReader = jsonReaderFactory.createReader((Reader)stringReader);
                    try {
                        jsonReader.readValue();
                        bl = true;
                        if (jsonReader == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (jsonReader != null) {
                            try {
                                jsonReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    jsonReader.close();
                }
                return bl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private GraphqlFieldVisibility getGraphqlFieldVisibility() {
        Config config = Config.get();
        String fieldVisibility = config.getFieldVisibility();
        if (fieldVisibility != null && !fieldVisibility.isEmpty()) {
            if (fieldVisibility.equals("no-introspection")) {
                return NoIntrospectionGraphqlFieldVisibility.NO_INTROSPECTION_FIELD_VISIBILITY;
            }
            String[] patterns = fieldVisibility.split(COMMA);
            BlockedFields.Builder blockedFields = BlockedFields.newBlock();
            for (String pattern : patterns) {
                blockedFields = blockedFields.addPattern(pattern);
            }
            return blockedFields.build();
        }
        return DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
    }

    private Type getTypeForField(Field field) {
        Map types = this.schema.getTypes();
        return (Type)types.get(field.getReference().getName());
    }
}

