/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health;

import io.smallrye.health.SmallRyeHealth;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.health.Health;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.jboss.logging.Logger;

@ApplicationScoped
public class SmallRyeHealthReporter {
    private static Logger LOG = Logger.getLogger(SmallRyeHealthReporter.class);
    private static final String ROOT_CAUSE = "rootCause";
    private static final String STACK_TRACE = "stackTrace";
    private static final Map<String, ?> JSON_CONFIG = Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true);
    @Inject
    @Health
    Instance<HealthCheck> checks;
    @Inject
    @ConfigProperty(name="io.smallrye.health.uncheckedExceptionDataStyle", defaultValue="rootCause")
    String uncheckedExceptionDataStyle;
    @Inject
    @ConfigProperty(name="io.smallrye.health.emptyChecksOutcome", defaultValue="UP")
    String emptyChecksOutcome;
    private List<HealthCheck> additionalChecks = new ArrayList<HealthCheck>();

    void setUncheckedExceptionDataStyle(String uncheckedExceptionDataStyle) {
        if (uncheckedExceptionDataStyle != null) {
            this.uncheckedExceptionDataStyle = uncheckedExceptionDataStyle;
        }
    }

    void setEmptyChecksOutcome(String emptyChecksOutcome) {
        if (emptyChecksOutcome != null) {
            this.emptyChecksOutcome = emptyChecksOutcome;
        }
    }

    public void reportHealth(OutputStream out, SmallRyeHealth health) {
        JsonWriterFactory factory = Json.createWriterFactory(JSON_CONFIG);
        JsonWriter writer = factory.createWriter(out);
        writer.writeObject(health.getPayload());
        writer.close();
    }

    public SmallRyeHealth getHealth() {
        JsonArrayBuilder results = Json.createArrayBuilder();
        HealthCheckResponse.State outcome = HealthCheckResponse.State.UP;
        if (this.checks != null) {
            for (HealthCheck check : this.checks) {
                outcome = this.fillCheck(check, results, outcome);
            }
        }
        if (!this.additionalChecks.isEmpty()) {
            for (HealthCheck check : this.additionalChecks) {
                outcome = this.fillCheck(check, results, outcome);
            }
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        JsonArray checkResults = results.build();
        builder.add("outcome", checkResults.isEmpty() ? this.emptyChecksOutcome : outcome.toString());
        builder.add("checks", (JsonValue)checkResults);
        return new SmallRyeHealth(builder.build());
    }

    private HealthCheckResponse.State fillCheck(HealthCheck check, JsonArrayBuilder results, HealthCheckResponse.State globalOutcome) {
        String state;
        if (check == null) {
            return globalOutcome;
        }
        JsonObject each = this.jsonObject(check);
        results.add((JsonValue)each);
        if (globalOutcome == HealthCheckResponse.State.UP && (state = each.getString("state")).equals("DOWN")) {
            return HealthCheckResponse.State.DOWN;
        }
        return globalOutcome;
    }

    private JsonObject jsonObject(HealthCheck check) {
        try {
            return this.jsonObject(check.call());
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error processing Health Checks", (Throwable)e);
            HealthCheckResponseBuilder response = HealthCheckResponse.named((String)check.getClass().getName()).down();
            if (null != this.uncheckedExceptionDataStyle) {
                switch (this.uncheckedExceptionDataStyle) {
                    case "rootCause": {
                        response.withData(ROOT_CAUSE, SmallRyeHealthReporter.getRootCause(e).getMessage());
                        break;
                    }
                    case "stackTrace": {
                        response.withData(STACK_TRACE, SmallRyeHealthReporter.getStackTrace(e));
                        break;
                    }
                }
            }
            return this.jsonObject(response.build());
        }
    }

    private JsonObject jsonObject(HealthCheckResponse response) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("name", response.getName());
        builder.add("state", response.getState().toString());
        response.getData().ifPresent(d -> {
            JsonObjectBuilder data = Json.createObjectBuilder();
            for (Map.Entry entry : d.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof String) {
                    data.add((String)entry.getKey(), (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    data.add((String)entry.getKey(), ((Long)value).longValue());
                    continue;
                }
                if (!(value instanceof Boolean)) continue;
                data.add((String)entry.getKey(), ((Boolean)value).booleanValue());
            }
            builder.add("data", (JsonValue)data.build());
        });
        return builder.build();
    }

    public void addHealthCheck(HealthCheck check) {
        if (check != null) {
            this.additionalChecks.add(check);
        }
    }

    public void removeHealthCheck(HealthCheck check) {
        this.additionalChecks.remove(check);
    }

    private static String getStackTrace(Throwable t) {
        StringWriter string = new StringWriter();
        try (PrintWriter pw = new PrintWriter(string);){
            t.printStackTrace(pw);
        }
        return string.toString();
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable cause = t.getCause();
        if (cause == null || cause == t) {
            return t;
        }
        return SmallRyeHealthReporter.getRootCause(cause);
    }
}

