/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.auth.cdi.ClaimValueWrapper;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@RequestScoped
public class CommonJwtProducer {
    private static Logger log = Logger.getLogger(CommonJwtProducer.class);
    private static final String TMP = "tmp";
    @Inject
    JsonWebToken currentToken;

    public <T> ClaimValue<Optional<T>> generalClaimValueProducer(InjectionPoint ip) {
        String name = this.getName(ip);
        ClaimValueWrapper<Optional<Optional<T>>> wrapper = new ClaimValueWrapper<Optional<Optional<T>>>(name);
        T value = this.getValue(name, false);
        Optional<T> optValue = Optional.ofNullable(value);
        wrapper.setValue(optValue);
        return wrapper;
    }

    public JsonValue generalJsonValueProducer(InjectionPoint ip) {
        String name = this.getName(ip);
        Object value = this.getValue(name, false);
        JsonValue jsonValue = CommonJwtProducer.wrapValue(value);
        return jsonValue;
    }

    public <T> T getValue(String name, boolean isOptional) {
        if (this.currentToken == null) {
            log.debugf("getValue(%s), null JsonWebToken", (Object)name);
            return null;
        }
        Optional claimValue = this.currentToken.claim(name);
        if (!isOptional && !claimValue.isPresent()) {
            log.debugf("Failed to find Claim for: %s", (Object)name);
        }
        log.debugf("getValue(%s), isOptional=%s, claimValue=%s", (Object)name, (Object)isOptional, (Object)claimValue);
        return claimValue.orElse(null);
    }

    public String getName(InjectionPoint ip) {
        String name = null;
        for (Annotation ann : ip.getQualifiers()) {
            if (!(ann instanceof Claim)) continue;
            Claim claim = (Claim)ann;
            name = claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name();
        }
        return name;
    }

    private static JsonObject replaceMap(Map<String, Object> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                JsonObject entryJsonObject = CommonJwtProducer.replaceMap((Map)entryValue);
                builder.add(entry.getKey(), (JsonValue)entryJsonObject);
                continue;
            }
            if (entryValue instanceof List) {
                JsonArray array = (JsonArray)CommonJwtProducer.wrapValue(entryValue);
                builder.add(entry.getKey(), (JsonValue)array);
                continue;
            }
            if (entryValue instanceof Long || entryValue instanceof Integer) {
                long lvalue = ((Number)entryValue).longValue();
                builder.add(entry.getKey(), lvalue);
                continue;
            }
            if (entryValue instanceof Double || entryValue instanceof Float) {
                double dvalue = ((Number)entryValue).doubleValue();
                builder.add(entry.getKey(), dvalue);
                continue;
            }
            if (entryValue instanceof Boolean) {
                boolean flag = (Boolean)entryValue;
                builder.add(entry.getKey(), flag);
                continue;
            }
            if (!(entryValue instanceof String)) continue;
            builder.add(entry.getKey(), entryValue.toString());
        }
        return builder.build();
    }

    private static JsonValue wrapValue(Object value) {
        JsonValue jsonValue = null;
        if (value instanceof JsonValue) {
            jsonValue = (JsonValue)value;
        } else if (value instanceof String) {
            jsonValue = Json.createObjectBuilder().add(TMP, value.toString()).build().getJsonString(TMP);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            jsonValue = number instanceof Long || number instanceof Integer ? Json.createObjectBuilder().add(TMP, number.longValue()).build().getJsonNumber(TMP) : Json.createObjectBuilder().add(TMP, number.doubleValue()).build().getJsonNumber(TMP);
        } else if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            jsonValue = flag != false ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (value instanceof Collection) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            Collection list = (Collection)value;
            for (Object element : list) {
                if (element instanceof String) {
                    arrayBuilder.add(element.toString());
                    continue;
                }
                JsonValue jvalue = CommonJwtProducer.wrapValue(element);
                arrayBuilder.add(jvalue);
            }
            jsonValue = arrayBuilder.build();
        } else if (value instanceof Map) {
            jsonValue = CommonJwtProducer.replaceMap((Map)value);
        }
        return jsonValue;
    }
}

