/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;

public class DefaultJWTCallerPrincipal
extends JWTCallerPrincipal {
    private static Logger logger = Logger.getLogger(DefaultJWTCallerPrincipal.class);
    private JwtClaims claimsSet;

    public DefaultJWTCallerPrincipal(String rawToken, String tokenType, JwtClaims claimsSet) {
        super(rawToken, tokenType);
        this.claimsSet = claimsSet;
        this.fixJoseTypes();
    }

    public DefaultJWTCallerPrincipal(String tokenType, JwtClaims claimsSet) {
        this(DefaultJWTCallerPrincipal.getRawToken(claimsSet), tokenType, claimsSet);
    }

    public DefaultJWTCallerPrincipal(JwtClaims claimsSet) {
        this("JWT", claimsSet);
    }

    protected static String getRawToken(JwtClaims claimsSet) {
        Object rawToken = claimsSet.getClaimValue(Claims.raw_token.name());
        return rawToken != null ? rawToken.toString() : null;
    }

    public Set<String> getAudience() {
        HashSet<String> audSet = null;
        try {
            if (this.claimsSet.hasClaim(Claims.aud.name())) {
                List audList = this.claimsSet.getStringListClaimValue(Claims.aud.name());
                audSet = new HashSet(audList);
            }
        }
        catch (MalformedClaimException e) {
            try {
                String aud = this.claimsSet.getStringClaimValue(Claims.aud.name());
                audSet = new HashSet<String>();
                audSet.add(aud);
            }
            catch (MalformedClaimException e1) {
                logger.warn((Object)"getAudience failure: ", (Throwable)e);
            }
        }
        return audSet;
    }

    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        try {
            List globalGroups = this.claimsSet.getStringListClaimValue(Claims.groups.name());
            if (globalGroups != null) {
                groups.addAll(globalGroups);
            }
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)"getGroups failure: ", (Throwable)e);
        }
        return groups;
    }

    @Override
    protected Collection<String> doGetClaimNames() {
        return this.claimsSet.getClaimNames();
    }

    @Override
    protected Object getClaimValue(String claimName) {
        Claims claimType = this.getClaimType(claimName);
        Object claim = null;
        switch (claimType) {
            case exp: 
            case iat: 
            case auth_time: 
            case nbf: 
            case updated_at: {
                try {
                    claim = this.claimsSet.getClaimValue(claimType.name(), Long.class);
                    if (claim != null) break;
                    claim = new Long(0L);
                }
                catch (MalformedClaimException malformedClaimException) {}
                break;
            }
            case groups: {
                claim = this.getGroups();
                break;
            }
            case aud: {
                claim = this.getAudience();
                break;
            }
            case UNKNOWN: {
                claim = this.claimsSet.getClaimValue(claimName);
                break;
            }
            default: {
                claim = this.claimsSet.getClaimValue(claimType.name());
            }
        }
        return claim;
    }

    private void fixJoseTypes() {
        if (this.claimsSet.hasClaim(Claims.address.name())) {
            this.replaceMap(Claims.address.name());
        }
        if (this.claimsSet.hasClaim(Claims.jwk.name())) {
            this.replaceMap(Claims.jwk.name());
        }
        if (this.claimsSet.hasClaim(Claims.sub_jwk.name())) {
            this.replaceMap(Claims.sub_jwk.name());
        }
        Set<String> customClaimNames = this.filterCustomClaimNames(this.claimsSet.getClaimNames());
        for (String name : customClaimNames) {
            Object claimValue = this.claimsSet.getClaimValue(name);
            if (claimValue instanceof List) {
                this.replaceList(name);
                continue;
            }
            if (claimValue instanceof Map) {
                this.replaceMap(name);
                continue;
            }
            if (!(claimValue instanceof Number)) continue;
            this.replaceNumber(name);
        }
    }

    protected Set<String> filterCustomClaimNames(Collection<String> claimNames) {
        HashSet<String> customNames = new HashSet<String>(claimNames);
        for (Claims claim : Claims.values()) {
            customNames.remove(claim.name());
        }
        return customNames;
    }

    protected void replaceMap(String name) {
        try {
            Map map = (Map)this.claimsSet.getClaimValue(name, Map.class);
            JsonObject jsonObject = this.replaceMapClaims(map);
            this.claimsSet.setClaim(name, (Object)jsonObject);
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)("replaceMap failure for: " + name), (Throwable)e);
        }
    }

    protected void replaceList(String name) {
        try {
            JsonArray array = (JsonArray)this.wrapClaimValue(this.claimsSet.getClaimValue(name, List.class));
            this.claimsSet.setClaim(name, (Object)array);
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)("replaceList failure for: " + name), (Throwable)e);
        }
    }

    protected void replaceNumber(String name) {
        try {
            Number number = (Number)this.claimsSet.getClaimValue(name, Number.class);
            JsonNumber jsonNumber = (JsonNumber)this.wrapClaimValue(number);
            this.claimsSet.setClaim(name, (Object)jsonNumber);
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)("replaceNumber failure for: " + name), (Throwable)e);
        }
    }
}

