/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.KeyLocationResolver;
import io.smallrye.jwt.auth.principal.ParseException;
import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;

public class DefaultJWTTokenParser {
    private static Logger logger = Logger.getLogger(DefaultJWTTokenParser.class);
    private static final String ROLE_MAPPINGS = "roleMappings";
    private HttpsJwks httpsJwks;

    public JwtContext parse(String token, JWTAuthContextInfo authContextInfo) throws ParseException {
        try {
            JwtConsumerBuilder builder = new JwtConsumerBuilder().setRequireExpirationTime().setRequireSubject().setSkipDefaultAudienceValidation().setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RS256"}));
            if (authContextInfo.isRequireIssuer()) {
                builder.setExpectedIssuer(true, authContextInfo.getIssuedBy());
            } else {
                builder.setExpectedIssuer(false, null);
            }
            if (authContextInfo.getSignerKey() != null) {
                builder.setVerificationKey((Key)authContextInfo.getSignerKey());
            } else if (authContextInfo.isFollowMpJwt11Rules()) {
                builder.setVerificationKeyResolver((VerificationKeyResolver)new KeyLocationResolver(authContextInfo.getJwksUri()));
            } else {
                List<JsonWebKey> jsonWebKeys = this.loadJsonWebKeys(authContextInfo);
                builder.setVerificationKeyResolver((VerificationKeyResolver)new JwksVerificationKeyResolver(jsonWebKeys));
            }
            if (authContextInfo.getExpGracePeriodSecs() > 0) {
                builder.setAllowedClockSkewInSeconds(authContextInfo.getExpGracePeriodSecs());
            } else {
                builder.setEvaluationTime(NumericDate.fromSeconds((long)0L));
            }
            JwtConsumer jwtConsumer = builder.build();
            JwtContext jwtContext = jwtConsumer.process(token);
            JwtClaims claimsSet = jwtContext.getJwtClaims();
            claimsSet.setClaim(Claims.raw_token.name(), (Object)token);
            if (!claimsSet.hasClaim(Claims.groups.name()) && authContextInfo.getDefaultGroupsClaim() != null) {
                claimsSet.setClaim(Claims.groups.name(), Collections.singletonList(authContextInfo.getDefaultGroupsClaim()));
            }
            if (claimsSet.hasClaim(ROLE_MAPPINGS)) {
                try {
                    Map rolesMapping = (Map)claimsSet.getClaimValue(ROLE_MAPPINGS, Map.class);
                    List groups = claimsSet.getStringListClaimValue(Claims.groups.name());
                    ArrayList<String> allGroups = new ArrayList<String>(groups);
                    for (String key : rolesMapping.keySet()) {
                        if (!groups.contains(key)) continue;
                        String toRole = (String)rolesMapping.get(key);
                        allGroups.add(toRole);
                    }
                    claimsSet.setStringListClaim("groups", allGroups);
                    logger.infof("Updated groups to: %s", allGroups);
                }
                catch (Exception e) {
                    logger.warnf((Throwable)e, "Failed to access rolesMapping claim", new Object[0]);
                }
            }
            return jwtContext;
        }
        catch (InvalidJwtException e) {
            logger.warnf("Token is invalid: %s", (Object)e.getMessage());
            throw new ParseException("Failed to verify token", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<JsonWebKey> loadJsonWebKeys(JWTAuthContextInfo authContextInfo) {
        DefaultJWTTokenParser defaultJWTTokenParser = this;
        synchronized (defaultJWTTokenParser) {
            if (authContextInfo.getJwksUri() == null) {
                return Collections.emptyList();
            }
            if (this.httpsJwks == null) {
                this.httpsJwks = new HttpsJwks(authContextInfo.getJwksUri());
                this.httpsJwks.setDefaultCacheDuration(authContextInfo.getJwksRefreshInterval().longValue() * 60L);
            }
        }
        try {
            return this.httpsJwks.getJsonWebKeys().stream().filter(jsonWebKey -> "sig".equals(jsonWebKey.getUse())).filter(jsonWebKey -> "RS256".equals(jsonWebKey.getAlgorithm())).collect(Collectors.toList());
        }
        catch (IOException | JoseException e) {
            throw new IllegalStateException(String.format("Unable to fetch JWKS from %s.", authContextInfo.getJwksUri()), e);
        }
    }
}

