/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.security.auth.Subject;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

public abstract class JWTCallerPrincipal
implements JsonWebToken {
    private static final String TMP = "tmp";
    private String rawToken;
    private String tokenType;

    public JWTCallerPrincipal(String rawToken, String tokenType) {
        this.rawToken = rawToken;
        this.tokenType = tokenType;
    }

    public String getName() {
        String principalName = (String)this.getClaim(Claims.upn.name());
        if (principalName == null && (principalName = (String)this.getClaim(Claims.preferred_username.name())) == null) {
            principalName = (String)this.getClaim(Claims.sub.name());
        }
        return principalName;
    }

    public Set<String> getClaimNames() {
        HashSet<String> names = new HashSet<String>(this.doGetClaimNames());
        names.add(Claims.raw_token.name());
        return names;
    }

    protected abstract Collection<String> doGetClaimNames();

    public <T> T getClaim(String claimName) {
        Object claimValue = Claims.raw_token.name().equals(claimName) ? this.rawToken : this.getClaimValue(claimName);
        return (T)claimValue;
    }

    protected abstract Object getClaimValue(String var1);

    public boolean implies(Subject subject) {
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean showAll) {
        String toString = "DefaultJWTCallerPrincipal{id='" + this.getTokenID() + '\'' + ", name='" + this.getName() + '\'' + ", expiration=" + this.getExpirationTime() + ", notBefore=" + this.getClaim(Claims.nbf.name()) + ", issuedAt=" + this.getIssuedAtTime() + ", issuer='" + this.getIssuer() + '\'' + ", audience=" + this.getAudience() + ", subject='" + this.getSubject() + '\'' + ", type='" + this.tokenType + '\'' + ", issuedFor='" + this.getClaim("azp") + '\'' + ", authTime=" + this.getClaim("auth_time") + ", givenName='" + this.getClaim("given_name") + '\'' + ", familyName='" + this.getClaim("family_name") + '\'' + ", middleName='" + this.getClaim("middle_name") + '\'' + ", nickName='" + this.getClaim("nickname") + '\'' + ", preferredUsername='" + this.getClaim("preferred_username") + '\'' + ", email='" + this.getClaim("email") + '\'' + ", emailVerified=" + this.getClaim(Claims.email_verified.name()) + ", allowedOrigins=" + this.getClaim("allowedOrigins") + ", updatedAt=" + this.getClaim("updated_at") + ", acr='" + this.getClaim("acr") + '\'';
        StringBuilder tmp = new StringBuilder(toString);
        tmp.append(", groups=[");
        for (String group : this.getGroups()) {
            tmp.append(group);
            tmp.append(',');
        }
        tmp.setLength(tmp.length() - 1);
        tmp.append("]}");
        return tmp.toString();
    }

    protected JsonObject replaceMapClaims(Map<String, Object> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                JsonObject entryJsonObject = this.replaceMapClaims((Map)entryValue);
                builder.add(entry.getKey(), (JsonValue)entryJsonObject);
                continue;
            }
            if (entryValue instanceof List) {
                JsonArray array = (JsonArray)this.wrapClaimValue(entryValue);
                builder.add(entry.getKey(), (JsonValue)array);
                continue;
            }
            if (entryValue instanceof Long || entryValue instanceof Integer) {
                long lvalue = ((Number)entryValue).longValue();
                builder.add(entry.getKey(), lvalue);
                continue;
            }
            if (entryValue instanceof Double || entryValue instanceof Float) {
                double dvalue = ((Number)entryValue).doubleValue();
                builder.add(entry.getKey(), dvalue);
                continue;
            }
            if (entryValue instanceof Boolean) {
                boolean flag = (Boolean)entryValue;
                builder.add(entry.getKey(), flag);
                continue;
            }
            if (!(entryValue instanceof String)) continue;
            builder.add(entry.getKey(), entryValue.toString());
        }
        return builder.build();
    }

    protected JsonValue wrapClaimValue(Object value) {
        JsonValue jsonValue = null;
        if (value instanceof JsonValue) {
            jsonValue = (JsonValue)value;
        } else if (value instanceof String) {
            jsonValue = Json.createObjectBuilder().add(TMP, value.toString()).build().getJsonString(TMP);
        } else if (value instanceof Number) {
            Number number = (Number)value;
            jsonValue = number instanceof Long || number instanceof Integer ? Json.createObjectBuilder().add(TMP, number.longValue()).build().getJsonNumber(TMP) : Json.createObjectBuilder().add(TMP, number.doubleValue()).build().getJsonNumber(TMP);
        } else if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            jsonValue = flag != false ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (value instanceof Collection) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            Collection list = (Collection)value;
            for (Object element : list) {
                if (element instanceof String) {
                    arrayBuilder.add(element.toString());
                    continue;
                }
                JsonValue jvalue = this.wrapClaimValue(element);
                arrayBuilder.add(jvalue);
            }
            jsonValue = arrayBuilder.build();
        } else if (value instanceof Map) {
            jsonValue = this.replaceMapClaims((Map)value);
        }
        return jsonValue;
    }

    protected Claims getClaimType(String claimName) {
        Claims claimType = Claims.UNKNOWN;
        try {
            claimType = Claims.valueOf((String)claimName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return claimType;
    }
}

