/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.KeyUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.Key;
import java.security.PublicKey;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.jboss.logging.Logger;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class KeyLocationResolver
implements VerificationKeyResolver {
    private static final Logger log = Logger.getLogger(KeyLocationResolver.class);
    private String location;
    private String content;

    public KeyLocationResolver(String location) {
        this.location = location;
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        try {
            this.loadContents();
        }
        catch (IOException e) {
            throw new UnresolvableKeyException("Failed to load a key from: " + this.location, (Throwable)e);
        }
        String kid = jws.getHeaders().getStringHeaderValue("kid");
        PublicKey key = this.tryAsJWK(kid);
        if (key == null) {
            key = this.tryAsPEM();
        }
        if (key == null) {
            throw new UnresolvableKeyException("Failed to read location as any of JWK, JWKS, PEM; " + this.location);
        }
        return key;
    }

    private PublicKey tryAsPEM() {
        PublicKey publicKey = null;
        try {
            publicKey = KeyUtils.decodePublicKey(this.content);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to read location as PEM", (Throwable)e);
        }
        return publicKey;
    }

    private PublicKey tryAsJWK(String kid) {
        PublicKey publicKey = null;
        try {
            log.debugf("Trying location as JWK(S)...", new Object[0]);
            JsonObject jwk = null;
            JsonObject jwks = Json.createReader((Reader)new StringReader(this.content)).readObject();
            JsonArray keys = jwks.getJsonArray("keys");
            if (keys != null) {
                if (kid != null) {
                    for (int i = 0; i < keys.size(); ++i) {
                        JsonObject currentJwk = keys.getJsonObject(i);
                        if (!kid.equals(currentJwk.getString("kid", null))) continue;
                        jwk = currentJwk;
                        break;
                    }
                } else if (keys.size() == 1) {
                    jwk = keys.getJsonObject(0);
                }
            } else if (kid == null || kid.equals(jwks.getString("kid", null))) {
                jwk = jwks;
            }
            if (jwk != null) {
                publicKey = PublicJsonWebKey.Factory.newPublicJwk((String)jwk.toString()).getPublicKey();
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to read location as JWK(S)", (Throwable)e);
        }
        return publicKey;
    }

    private void loadContents() throws IOException {
        InputStream is;
        StringWriter contents = new StringWriter();
        if (this.location.startsWith("classpath:") || this.location.indexOf(58) < 0) {
            is = KeyLocationResolver.getAsResource(this.location);
        } else {
            URL locationURL = new URL(this.location);
            is = locationURL.openStream();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("-----BEGIN") && !line.startsWith("-----END")) {
                    contents.write(line);
                }
                line = reader.readLine();
            }
        }
        this.content = contents.toString();
    }

    private static InputStream getAsResource(String location) throws IOException {
        String path = location.startsWith("classpath:") ? location.substring(10) : location;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream(path);
        if (is == null) {
            throw new IOException("No resource with named " + location + " exists");
        }
        return is;
    }
}

