/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth;

import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory;
import io.smallrye.jwt.auth.principal.ParseException;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

public abstract class AbstractBearerTokenExtractor {
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String COOKIE_HEADER = "Cookie";
    protected static final String BEARER = "Bearer";
    protected static final String BEARER_SCHEME_PREFIX = "Bearer ";
    private static Logger logger = Logger.getLogger(AbstractBearerTokenExtractor.class);
    private final JWTAuthContextInfo authContextInfo;

    protected AbstractBearerTokenExtractor(JWTAuthContextInfo authContextInfo) {
        this.authContextInfo = authContextInfo;
    }

    public String getBearerToken() {
        String bearerValue;
        String tokenHeaderName = this.authContextInfo.getTokenHeader();
        logger.debugf("tokenHeaderName = %s", (Object)tokenHeaderName);
        if (COOKIE_HEADER.equals(tokenHeaderName)) {
            String tokenCookieName = this.authContextInfo.getTokenCookie();
            if (tokenCookieName == null) {
                tokenCookieName = BEARER;
            }
            logger.debugf("tokenCookieName = %s", (Object)tokenCookieName);
            bearerValue = this.getCookieValue(tokenCookieName);
            if (bearerValue == null) {
                logger.debugf("Cookie %s was null", (Object)tokenCookieName);
            }
        } else if (AUTHORIZATION_HEADER.equals(tokenHeaderName)) {
            String tokenHeader = this.getHeaderValue(tokenHeaderName);
            if (tokenHeader != null) {
                if (AbstractBearerTokenExtractor.isBearerScheme(tokenHeader)) {
                    bearerValue = tokenHeader.substring(BEARER_SCHEME_PREFIX.length());
                } else {
                    logger.debugf("Authorization header does not contain a Bearer prefix", new Object[0]);
                    bearerValue = null;
                }
            } else {
                logger.debugf("Authorization header was null", new Object[0]);
                bearerValue = null;
            }
        } else {
            bearerValue = this.getHeaderValue(tokenHeaderName);
            if (bearerValue == null) {
                logger.debugf("Header %s was null", (Object)tokenHeaderName);
            }
        }
        return bearerValue;
    }

    private static boolean isBearerScheme(String authorizationHeader) {
        if (authorizationHeader.length() < BEARER_SCHEME_PREFIX.length()) {
            return false;
        }
        String scheme = authorizationHeader.substring(0, BEARER_SCHEME_PREFIX.length());
        return BEARER_SCHEME_PREFIX.equalsIgnoreCase(scheme);
    }

    public JsonWebToken validate(String bearerToken) throws ParseException {
        JWTCallerPrincipalFactory factory = JWTCallerPrincipalFactory.instance();
        JWTCallerPrincipal callerPrincipal = factory.parse(bearerToken, this.authContextInfo);
        return callerPrincipal;
    }

    protected abstract String getHeaderValue(String var1);

    protected abstract String getCookieValue(String var1);
}

