/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.auth.cdi.ClaimValueWrapper;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;

public class ClaimValueProducer<T> {
    @Inject
    CommonJwtProducer util;

    @Produces
    @Claim(value="")
    ClaimValue<T> produce(InjectionPoint ip) {
        ClaimValue cv;
        ClaimValue returnValue = cv = this.util.generalClaimValueProducer(ip);
        Optional value = (Optional)cv.getValue();
        Type matchType = ip.getType();
        Object actualType = Object.class;
        boolean isOptional = false;
        if (matchType instanceof ParameterizedType) {
            actualType = ((ParameterizedType)matchType).getActualTypeArguments()[0];
            isOptional = matchType.getTypeName().equals(Optional.class.getTypeName());
            if (isOptional) {
                actualType = ((ParameterizedType)matchType).getActualTypeArguments()[0];
            }
        }
        if (!actualType.getTypeName().startsWith(Optional.class.getTypeName())) {
            Object nestedValue = value.orElse(null);
            ClaimValueWrapper<Optional<Object>> wrapper = new ClaimValueWrapper<Optional<Object>>(cv.getName());
            wrapper.setValue((Optional<Object>)nestedValue);
            returnValue = wrapper;
        }
        return returnValue;
    }
}

