/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import java.util.Optional;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claim;
import org.jboss.logging.Logger;

public class JsonValueProducer {
    private static Logger log = Logger.getLogger(JsonValueProducer.class);
    @Inject
    CommonJwtProducer util;

    @Produces
    @Claim(value="")
    public JsonString getJsonString(InjectionPoint ip) {
        return (JsonString)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonString> getOptionalJsonString(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    @Produces
    @Claim(value="")
    public JsonNumber getJsonNumber(InjectionPoint ip) {
        return (JsonNumber)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonNumber> getOptionalJsonNumber(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    @Produces
    @Claim(value="")
    public JsonArray getJsonArray(InjectionPoint ip) {
        return (JsonArray)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonArray> getOptionalJsonArray(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    @Produces
    @Claim(value="")
    public JsonObject getJsonObject(InjectionPoint ip) {
        return (JsonObject)this.getValue(ip);
    }

    @Produces
    @Claim(value="")
    public Optional<JsonObject> getOptionalJsonObject(InjectionPoint ip) {
        return this.getOptionalValue(ip);
    }

    public <T extends JsonValue> T getValue(InjectionPoint ip) {
        log.debugf("JsonValueProducer(%s).produce", (Object)ip);
        JsonValue jsonValue = this.util.generalJsonValueProducer(ip);
        return (T)jsonValue;
    }

    public <T extends JsonValue> Optional<T> getOptionalValue(InjectionPoint ip) {
        log.debugf("JsonValueProducer(%s).produce", (Object)ip);
        JsonValue jsonValue = this.util.generalJsonValueProducer(ip);
        return Optional.ofNullable(jsonValue);
    }
}

