/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.security.Key;
import java.security.PublicKey;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.jboss.logging.Logger;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class KeyLocationResolver
implements VerificationKeyResolver {
    private static final Logger log = Logger.getLogger(KeyLocationResolver.class);
    private String content;
    private HttpsJwks httpsJwks;
    private volatile PublicKey verificationKey;
    private JWTAuthContextInfo authContextInfo;

    public KeyLocationResolver(JWTAuthContextInfo authContextInfo) throws UnresolvableKeyException {
        this.authContextInfo = authContextInfo;
        try {
            this.loadContents();
        }
        catch (Exception e) {
            throw new UnresolvableKeyException("Failed to load a key from: " + authContextInfo.getPublicKeyLocation(), (Throwable)e);
        }
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        if (this.verificationKey != null) {
            return this.verificationKey;
        }
        PublicKey key = this.tryAsJWK(jws);
        if (key == null) {
            key = this.tryAsPEM();
        }
        if (key == null) {
            throw new UnresolvableKeyException("Failed to read location as any of JWK, JWKS, PEM. " + this.authContextInfo.getPublicKeyLocation());
        }
        return key;
    }

    private PublicKey tryAsPEM() {
        try {
            this.verificationKey = KeyUtils.decodePublicKey(this.content);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to read location as PEM", (Throwable)e);
        }
        return this.verificationKey;
    }

    private PublicKey tryAsJWK(JsonWebSignature jws) throws UnresolvableKeyException {
        PublicKey publicKey;
        block18: {
            String kid = jws.getHeaders().getStringHeaderValue("kid");
            if (kid != null) {
                if (this.authContextInfo.getTokenKeyId() != null && !kid.equals(this.authContextInfo.getTokenKeyId())) {
                    log.debugf("Invalid token 'kid' header: %s, expected: %s", (Object)kid, (Object)this.authContextInfo.getTokenKeyId());
                    throw new UnresolvableKeyException("Invalid token 'kid' header");
                }
            } else {
                kid = this.authContextInfo.getTokenKeyId();
            }
            publicKey = null;
            try {
                log.debugf("Trying location as JWK(S)...", new Object[0]);
                if (this.httpsJwks != null) {
                    List keys = this.httpsJwks.getJsonWebKeys();
                    if (kid != null) {
                        for (JsonWebKey currentJwk : keys) {
                            if (!kid.equals(currentJwk.getKeyId())) continue;
                            publicKey = ((PublicJsonWebKey)PublicJsonWebKey.class.cast(currentJwk)).getPublicKey();
                            break block18;
                        }
                        break block18;
                    }
                    if (keys.size() == 1) {
                        publicKey = ((PublicJsonWebKey)PublicJsonWebKey.class.cast(keys.get(0))).getPublicKey();
                    }
                    break block18;
                }
                JsonObject jwk = null;
                JsonObject jwks = Json.createReader((Reader)new StringReader(this.content)).readObject();
                JsonArray keys = jwks.getJsonArray("keys");
                if (keys != null) {
                    if (kid != null) {
                        for (int i = 0; i < keys.size(); ++i) {
                            JsonObject currentJwk = keys.getJsonObject(i);
                            if (!kid.equals(currentJwk.getString("kid", null))) continue;
                            jwk = currentJwk;
                            break;
                        }
                    } else if (keys.size() == 1) {
                        jwk = keys.getJsonObject(0);
                    }
                } else if (kid == null || kid.equals(jwks.getString("kid", null))) {
                    jwk = jwks;
                }
                if (jwk != null) {
                    publicKey = PublicJsonWebKey.Factory.newPublicJwk((String)jwk.toString()).getPublicKey();
                }
            }
            catch (Exception e) {
                log.debug((Object)"Failed to read location as JWK(S)", (Throwable)e);
            }
        }
        if (this.httpsJwks == null && publicKey != null && this.authContextInfo.getTokenKeyId() != null) {
            this.verificationKey = publicKey;
        }
        return publicKey;
    }

    private void loadContents() throws Exception {
        URI location = URI.create(this.authContextInfo.getPublicKeyLocation());
        if ("https".equals(location.getScheme())) {
            this.httpsJwks = new HttpsJwks(this.authContextInfo.getPublicKeyLocation());
            this.httpsJwks.setDefaultCacheDuration(this.authContextInfo.getJwksRefreshInterval().longValue() * 60L);
            return;
        }
        InputStream is = null;
        if (location.getScheme() != null) {
            is = "classpath".equals(location.getScheme()) ? KeyLocationResolver.getAsClasspathResource(location.getSchemeSpecificPart()) : ("file".equals(location.getScheme()) ? KeyLocationResolver.getAsFileSystemResource(location.getRawSchemeSpecificPart()) : new URL(this.authContextInfo.getPublicKeyLocation()).openStream());
        } else {
            is = KeyLocationResolver.getAsClasspathResource(this.authContextInfo.getPublicKeyLocation());
            if (is == null) {
                is = KeyLocationResolver.getAsFileSystemResource(this.authContextInfo.getPublicKeyLocation());
            }
        }
        if (is == null) {
            throw new IOException("No resource with the named " + location + " location exists");
        }
        StringWriter contents = new StringWriter();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("-----BEGIN") && !line.startsWith("-----END")) {
                    contents.write(line);
                }
                line = reader.readLine();
            }
        }
        this.content = contents.toString();
    }

    private static InputStream getAsFileSystemResource(String publicKeyLocation) throws IOException {
        File f = new File(publicKeyLocation);
        return f.exists() ? new FileInputStream(f) : null;
    }

    private static InputStream getAsClasspathResource(String location) throws IOException {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
    }
}

