/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.config;

import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.SmallryeJwtUtils;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.security.interfaces.RSAPublicKey;
import java.util.Optional;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Dependent
public class JWTAuthContextInfoProvider {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String NONE = "NONE";
    private static final Logger log = Logger.getLogger(JWTAuthContextInfoProvider.class);
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey", defaultValue="NONE")
    private Optional<String> mpJwtPublicKey;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.issuer", defaultValue="NONE")
    private String mpJwtIssuer;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.location", defaultValue="NONE")
    private Optional<String> mpJwtLocation;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.requireiss", defaultValue="true")
    private Optional<Boolean> mpJwtRequireIss;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.header", defaultValue="Authorization")
    private String tokenHeader;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.cookie")
    private Optional<String> tokenCookie;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.kid")
    private Optional<String> tokenKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.require.named-principal", defaultValue="false")
    private Optional<Boolean> requireNamedPrincipal;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.sub")
    private Optional<String> defaultSubClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.sub")
    private Optional<String> subPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.groups")
    private Optional<String> defaultGroupsClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.groups")
    private Optional<String> groupsPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.expiration.grace", defaultValue="60")
    private Optional<Integer> expGracePeriodSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.refresh-interval", defaultValue="60")
    private Optional<Integer> jwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.whitelist.algorithms")
    private Optional<String> whitelistAlgorithms;

    public static JWTAuthContextInfoProvider createWithKey(String publicKey, String issuer) {
        return JWTAuthContextInfoProvider.create(publicKey, NONE, issuer);
    }

    public static JWTAuthContextInfoProvider createWithKeyLocation(String publicKeyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, publicKeyLocation, issuer);
    }

    private static JWTAuthContextInfoProvider create(String publicKey, String publicKeyLocation, String issuer) {
        JWTAuthContextInfoProvider provider = new JWTAuthContextInfoProvider();
        provider.mpJwtPublicKey = Optional.of(publicKey);
        provider.mpJwtLocation = Optional.of(publicKeyLocation);
        provider.mpJwtIssuer = issuer;
        return provider;
    }

    @Produces
    @ApplicationScoped
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        log.debugf("init, mpJwtPublicKey=%s, mpJwtIssuer=%s, mpJwtLocation=%s", (Object)this.mpJwtPublicKey.orElse("missing"), (Object)this.mpJwtIssuer, (Object)this.mpJwtLocation.orElse("missing"));
        if (NONE.equals(this.mpJwtPublicKey.get()) && NONE.equals(this.mpJwtLocation.get())) {
            log.debugf("Neither mpJwtPublicKey nor mpJwtLocation properties are configured, JWTAuthContextInfo will not be available", new Object[0]);
            return Optional.empty();
        }
        JWTAuthContextInfo contextInfo = new JWTAuthContextInfo();
        if (this.mpJwtPublicKey.isPresent() && !NONE.equals(this.mpJwtPublicKey.get())) {
            this.decodeMpJwtPublicKey(contextInfo);
        }
        if (this.mpJwtIssuer != null && !this.mpJwtIssuer.equals(NONE)) {
            contextInfo.setIssuedBy(this.mpJwtIssuer);
        } else {
            contextInfo.setRequireIssuer(false);
        }
        if (this.mpJwtRequireIss != null && this.mpJwtRequireIss.isPresent()) {
            contextInfo.setRequireIssuer(this.mpJwtRequireIss.get());
        } else {
            contextInfo.setRequireIssuer(true);
        }
        if (this.mpJwtLocation.isPresent() && !NONE.equals(this.mpJwtLocation.get())) {
            contextInfo.setPublicKeyLocation(this.mpJwtLocation.get());
        }
        if (this.tokenHeader != null) {
            contextInfo.setTokenHeader(this.tokenHeader);
        }
        if (this.tokenKeyId != null && this.tokenKeyId.isPresent()) {
            contextInfo.setTokenKeyId(this.tokenKeyId.get());
        }
        if (this.requireNamedPrincipal != null && this.requireNamedPrincipal.isPresent()) {
            contextInfo.setRequireNamedPrincipal(this.requireNamedPrincipal.get());
        }
        SmallryeJwtUtils.setContextTokenCookie(contextInfo, this.tokenCookie);
        if (this.defaultSubClaim != null && this.defaultSubClaim.isPresent()) {
            contextInfo.setDefaultSubjectClaim(this.defaultSubClaim.get());
        }
        SmallryeJwtUtils.setContextSubPath(contextInfo, this.subPath);
        if (this.defaultGroupsClaim != null && this.defaultGroupsClaim.isPresent()) {
            contextInfo.setDefaultGroupsClaim(this.defaultGroupsClaim.get());
        }
        SmallryeJwtUtils.setContextGroupsPath(contextInfo, this.groupsPath);
        if (this.expGracePeriodSecs != null && this.expGracePeriodSecs.isPresent()) {
            contextInfo.setExpGracePeriodSecs(this.expGracePeriodSecs.get());
        }
        if (this.jwksRefreshInterval != null && this.jwksRefreshInterval.isPresent()) {
            contextInfo.setJwksRefreshInterval(this.jwksRefreshInterval.get());
        }
        SmallryeJwtUtils.setWhitelistAlgorithms(contextInfo, this.whitelistAlgorithms);
        return Optional.of(contextInfo);
    }

    protected void decodeMpJwtPublicKey(JWTAuthContextInfo contextInfo) {
        try {
            RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodeJWKSPublicKey(this.mpJwtPublicKey.get());
            contextInfo.setSignerKey(pk);
            log.debugf("mpJwtPublicKey parsed as JWK(S)", new Object[0]);
        }
        catch (Exception e) {
            log.debugf("mpJwtPublicKey failed as JWK(S), %s", (Object)e.getMessage());
            try {
                RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey(this.mpJwtPublicKey.get());
                contextInfo.setSignerKey(pk);
                log.debugf("mpJwtPublicKey parsed as PEM", new Object[0]);
            }
            catch (Exception e1) {
                throw new DeploymentException((Throwable)e1);
            }
        }
    }

    public Optional<String> getMpJwtPublicKey() {
        return this.mpJwtPublicKey;
    }

    public String getMpJwtIssuer() {
        return this.mpJwtIssuer;
    }

    public Optional<String> getMpJwtLocation() {
        return this.mpJwtLocation;
    }

    public Optional<Boolean> getMpJwtRequireIss() {
        return this.mpJwtRequireIss;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public Optional<String> getTokenCookie() {
        return this.tokenCookie;
    }

    public Optional<String> getTokenKeyId() {
        return this.tokenKeyId;
    }

    public Optional<Integer> getExpGracePeriodSecs() {
        return this.expGracePeriodSecs;
    }

    public Optional<Integer> getJwksRefreshInterval() {
        return this.jwksRefreshInterval;
    }

    public Optional<String> getDefaultGroupsClaim() {
        return this.defaultGroupsClaim;
    }

    public Optional<String> getGroupsPath() {
        return this.groupsPath;
    }

    public Optional<String> getSubjectPath() {
        return this.subPath;
    }

    public Optional<String> getDefaultSubjectClaim() {
        return this.defaultSubClaim;
    }

    public Optional<String> getWhitelistAlgorithms() {
        return this.whitelistAlgorithms;
    }

    @Produces
    @ApplicationScoped
    public JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().orElseThrow(JWTAuthContextInfoProvider.throwException());
    }

    private static Supplier<IllegalStateException> throwException() {
        String error = "JWTAuthContextInfo has not been initialized. Please make sure that either 'mp.jwt.verify.publickey' or 'mp.jwt.verify.publickey.location' properties are set.";
        return () -> new IllegalStateException("JWTAuthContextInfo has not been initialized. Please make sure that either 'mp.jwt.verify.publickey' or 'mp.jwt.verify.publickey.location' properties are set.");
    }
}

