/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import io.smallrye.jwt.auth.jaxrs.JWTSecurityContext;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory;
import io.smallrye.jwt.auth.principal.ParseException;
import java.io.IOException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;

@Priority(value=1000)
@Provider
public class JWTAuthFilter
implements ContainerRequestFilter {
    @Inject
    private JWTAuthContextInfo authContextInfo;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        String authHeaderVal = requestContext.getHeaderString("Authorization");
        System.err.printf("JWTAuthFilter.authHeaderVal: %s\n", authHeaderVal);
        if (authHeaderVal.startsWith("Bearer")) {
            try {
                String bearerToken = authHeaderVal.substring(7);
                JWTCallerPrincipal jwtPrincipal = this.validate(bearerToken);
                SecurityContext securityContext = requestContext.getSecurityContext();
                JWTSecurityContext jwtSecurityContext = new JWTSecurityContext(securityContext, jwtPrincipal);
                requestContext.setSecurityContext((SecurityContext)jwtSecurityContext);
                System.out.printf("Success\n", new Object[0]);
            }
            catch (Exception ex) {
                System.err.printf("Failed with ex=%s\n", ex.getMessage());
                ex.printStackTrace();
                requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
            }
        } else {
            System.err.printf("Failed due to missing Authorization bearer token\n", new Object[0]);
            requestContext.abortWith(Response.status((Response.Status)Response.Status.UNAUTHORIZED).build());
        }
    }

    protected JWTCallerPrincipal validate(String bearerToken) throws ParseException {
        JWTCallerPrincipalFactory factory = JWTCallerPrincipalFactory.instance();
        JWTCallerPrincipal callerPrincipal = factory.parse(bearerToken, this.authContextInfo);
        return callerPrincipal;
    }
}

