/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import java.io.IOException;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.lang.JoseException;

public class JWTAuthContextInfo {
    private RSAPublicKey signerKey;
    private String issuedBy;
    private int expGracePeriodSecs = 60;
    private String jwksUri;
    private Integer jwksRefreshInterval;
    private HttpsJwks httpsJwks;
    private boolean requireIssuer = true;
    private boolean followMpJwt11Rules;

    public JWTAuthContextInfo() {
    }

    public JWTAuthContextInfo(RSAPublicKey signerKey, String issuedBy) {
        this.signerKey = signerKey;
        this.issuedBy = issuedBy;
    }

    public JWTAuthContextInfo(JWTAuthContextInfo orig) {
        this.signerKey = orig.signerKey;
        this.issuedBy = orig.issuedBy;
        this.expGracePeriodSecs = orig.expGracePeriodSecs;
        this.jwksUri = orig.jwksUri;
        this.jwksRefreshInterval = orig.jwksRefreshInterval;
    }

    public RSAPublicKey getSignerKey() {
        return this.signerKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JsonWebKey> loadJsonWebKeys() {
        JWTAuthContextInfo jWTAuthContextInfo = this;
        synchronized (jWTAuthContextInfo) {
            if (this.jwksUri == null) {
                return Collections.emptyList();
            }
            if (this.httpsJwks == null) {
                this.httpsJwks = new HttpsJwks(this.jwksUri);
                this.httpsJwks.setDefaultCacheDuration(this.jwksRefreshInterval.longValue() * 60L);
            }
        }
        try {
            return this.httpsJwks.getJsonWebKeys().stream().filter(jsonWebKey -> "sig".equals(jsonWebKey.getUse())).filter(jsonWebKey -> "RS256".equals(jsonWebKey.getAlgorithm())).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Unable to fetch JWKS from %s.", this.jwksUri), e);
        }
        catch (JoseException e) {
            throw new IllegalStateException(String.format("Unable to parse JWKS from %s.", this.jwksUri), e);
        }
    }

    public void setSignerKey(RSAPublicKey signerKey) {
        this.signerKey = signerKey;
    }

    public String getIssuedBy() {
        return this.issuedBy;
    }

    public void setIssuedBy(String issuedBy) {
        this.issuedBy = issuedBy;
    }

    public int getExpGracePeriodSecs() {
        return this.expGracePeriodSecs;
    }

    public void setExpGracePeriodSecs(int expGracePeriodSecs) {
        this.expGracePeriodSecs = expGracePeriodSecs;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public Integer getJwksRefreshInterval() {
        return this.jwksRefreshInterval;
    }

    public void setJwksRefreshInterval(Integer jwksRefreshInterval) {
        this.jwksRefreshInterval = jwksRefreshInterval;
    }

    public boolean isRequireIssuer() {
        return this.requireIssuer;
    }

    public void setRequireIssuer(boolean requireIssuer) {
        this.requireIssuer = requireIssuer;
    }

    public boolean isFollowMpJwt11Rules() {
        return this.followMpJwt11Rules;
    }

    public void setFollowMpJwt11Rules(boolean followMpJwt11Rules) {
        this.followMpJwt11Rules = followMpJwt11Rules;
    }
}

