/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.config;

import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.security.interfaces.RSAPublicKey;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Dependent
public class JWTAuthContextInfoProvider {
    private static final String NONE = "NONE";
    private static final Logger log = Logger.getLogger(JWTAuthContextInfoProvider.class);
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey", defaultValue="NONE")
    private Optional<String> mpJwtublicKey;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.issuer", defaultValue="NONE")
    private String mpJwtIssuer;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.location", defaultValue="NONE")
    private Optional<String> mpJwtLocation;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.requireiss", defaultValue="true")
    private Optional<Boolean> mpJwtRequireIss;

    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        log.debugf("init, mpJwtublicKey=%s, mpJwtIssuer=%s, mpJwtLocation=%s", (Object)this.mpJwtublicKey.orElse("missing"), (Object)this.mpJwtIssuer, (Object)this.mpJwtLocation.orElse("missing"));
        if (NONE.equals(this.mpJwtublicKey.get()) && NONE.equals(this.mpJwtLocation.get())) {
            return Optional.empty();
        }
        JWTAuthContextInfo contextInfo = new JWTAuthContextInfo();
        if (this.mpJwtublicKey.isPresent() && !NONE.equals(this.mpJwtublicKey.get())) {
            try {
                RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodeJWKSPublicKey(this.mpJwtublicKey.get());
                contextInfo.setSignerKey(pk);
                log.debugf("mpJwtublicKey parsed as JWK(S)", new Object[0]);
            }
            catch (Exception e) {
                log.debugf("mpJwtublicKey failed as JWK(S), %s", (Object)e.getMessage());
                try {
                    RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey(this.mpJwtublicKey.get());
                    contextInfo.setSignerKey(pk);
                    log.debugf("mpJwtublicKey parsed as PEM", new Object[0]);
                }
                catch (Exception e1) {
                    throw new DeploymentException((Throwable)e1);
                }
            }
        }
        if (this.mpJwtIssuer != null && !this.mpJwtIssuer.equals(NONE)) {
            contextInfo.setIssuedBy(this.mpJwtIssuer);
        } else {
            contextInfo.setRequireIssuer(false);
        }
        if (this.mpJwtRequireIss != null && this.mpJwtRequireIss.isPresent()) {
            contextInfo.setRequireIssuer(this.mpJwtRequireIss.get());
        } else {
            contextInfo.setRequireIssuer(true);
        }
        if (this.mpJwtLocation.isPresent() && !NONE.equals(this.mpJwtLocation.get())) {
            contextInfo.setJwksUri(this.mpJwtLocation.get());
            contextInfo.setFollowMpJwt11Rules(true);
        }
        return Optional.of(contextInfo);
    }

    public Optional<String> getMpJwtublicKey() {
        return this.mpJwtublicKey;
    }

    public String getMpJwtIssuer() {
        return this.mpJwtIssuer;
    }

    public Optional<String> getMpJwtLocation() {
        return this.mpJwtLocation;
    }

    public Optional<Boolean> getMpJwtRequireIss() {
        return this.mpJwtRequireIss;
    }

    @Produces
    public JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().get();
    }
}

