/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;

public class KeyUtils {
    private static final String RSA = "RSA";

    public static PrivateKey readPrivateKey(String pemResName) throws Exception {
        InputStream contentIS = KeyUtils.class.getResourceAsStream(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        PrivateKey privateKey = KeyUtils.decodePrivateKey(new String(tmp, 0, length));
        return privateKey;
    }

    public static PublicKey readPublicKey(String pemResName) throws Exception {
        InputStream contentIS = KeyUtils.class.getResourceAsStream(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        PublicKey publicKey = KeyUtils.decodePublicKey(new String(tmp, 0, length));
        return publicKey;
    }

    public static KeyPair generateKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA);
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.genKeyPair();
        return keyPair;
    }

    public static PrivateKey decodePrivateKey(String pemEncoded) throws Exception {
        pemEncoded = KeyUtils.removeBeginEnd(pemEncoded);
        byte[] pkcs8EncodedBytes = Base64.getDecoder().decode(pemEncoded);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8EncodedBytes);
        KeyFactory kf = KeyFactory.getInstance(RSA);
        PrivateKey privKey = kf.generatePrivate(keySpec);
        return privKey;
    }

    public static PublicKey decodeJWKSPublicKey(String jwksValue) throws Exception {
        JsonObject jwks;
        try {
            jwks = Json.createReader((Reader)new StringReader(jwksValue)).readObject();
        }
        catch (Exception e) {
            byte[] decoded = Base64.getDecoder().decode(jwksValue);
            jwks = Json.createReader((InputStream)new ByteArrayInputStream(decoded)).readObject();
        }
        JsonArray keys = jwks.getJsonArray("keys");
        JsonObject jwk = keys != null ? keys.getJsonObject(0) : jwks;
        String e = jwk.getString("e");
        String n = jwk.getString("n");
        byte[] ebytes = Base64.getUrlDecoder().decode(e);
        BigInteger publicExponent = new BigInteger(1, ebytes);
        byte[] nbytes = Base64.getUrlDecoder().decode(n);
        BigInteger modulus = new BigInteger(1, nbytes);
        KeyFactory kf = KeyFactory.getInstance(RSA);
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
        PublicKey publicKey = kf.generatePublic(rsaPublicKeySpec);
        return publicKey;
    }

    public static PublicKey decodePublicKey(String pemEncoded) throws Exception {
        pemEncoded = KeyUtils.removeBeginEnd(pemEncoded);
        byte[] encodedBytes = Base64.getDecoder().decode(pemEncoded);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance(RSA);
        return kf.generatePublic(spec);
    }

    private static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN(.*)KEY-----", "");
        pem = pem.replaceAll("-----END(.*)KEY-----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        return pem.trim();
    }

    private KeyUtils() {
    }
}

