/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;

public class JWTSecurityContext
implements SecurityContext {
    private SecurityContext delegate;
    private JWTCallerPrincipal principal;

    JWTSecurityContext(SecurityContext delegate, JWTCallerPrincipal principal) {
        this.delegate = delegate;
        this.principal = principal;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isUserInRole(String role) {
        return this.principal.getGroups().contains(role);
    }

    public boolean isSecure() {
        return this.delegate.isSecure();
    }

    public String getAuthenticationScheme() {
        return this.delegate.getAuthenticationScheme();
    }
}

