/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;

public class DefaultJWTCallerPrincipal
extends JWTCallerPrincipal {
    private static Logger logger = Logger.getLogger(DefaultJWTCallerPrincipal.class);
    private JwtClaims claimsSet;

    public DefaultJWTCallerPrincipal(String rawToken, String tokenType, JwtClaims claimsSet) {
        super(rawToken, tokenType);
        this.claimsSet = claimsSet;
        this.fixJoseTypes();
    }

    public Set<String> getAudience() {
        HashSet<String> audSet = null;
        try {
            if (this.claimsSet.hasClaim(Claims.aud.name())) {
                List audList = this.claimsSet.getStringListClaimValue("aud");
                audSet = new HashSet(audList);
            }
        }
        catch (MalformedClaimException e) {
            try {
                String aud = this.claimsSet.getStringClaimValue("aud");
                audSet = new HashSet<String>();
                audSet.add(aud);
            }
            catch (MalformedClaimException malformedClaimException) {
                // empty catch block
            }
        }
        return audSet;
    }

    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        try {
            List globalGroups = this.claimsSet.getStringListClaimValue("groups");
            if (globalGroups != null) {
                groups.addAll(globalGroups);
            }
        }
        catch (MalformedClaimException e) {
            e.printStackTrace();
        }
        return groups;
    }

    @Override
    protected Collection<String> doGetClaimNames() {
        return this.claimsSet.getClaimNames();
    }

    @Override
    protected Object getClaimValue(String claimName) {
        Claims claimType = Claims.UNKNOWN;
        Object claim = null;
        try {
            claimType = Claims.valueOf((String)claimName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (claimType) {
            case exp: 
            case iat: 
            case auth_time: 
            case nbf: 
            case updated_at: {
                try {
                    claim = this.claimsSet.getClaimValue(claimType.name(), Long.class);
                    if (claim != null) break;
                    claim = new Long(0L);
                }
                catch (MalformedClaimException malformedClaimException) {}
                break;
            }
            case groups: {
                claim = this.getGroups();
                break;
            }
            case aud: {
                claim = this.getAudience();
                break;
            }
            case UNKNOWN: {
                claim = this.claimsSet.getClaimValue(claimName);
                break;
            }
            default: {
                claim = this.claimsSet.getClaimValue(claimType.name());
            }
        }
        return claim;
    }

    private void fixJoseTypes() {
        if (this.claimsSet.hasClaim(Claims.address.name())) {
            this.replaceMap(Claims.address.name());
        }
        if (this.claimsSet.hasClaim(Claims.jwk.name())) {
            this.replaceMap(Claims.jwk.name());
        }
        if (this.claimsSet.hasClaim(Claims.sub_jwk.name())) {
            this.replaceMap(Claims.sub_jwk.name());
        }
        Set<String> customClaimNames = this.filterCustomClaimNames(this.claimsSet.getClaimNames());
        for (String name : customClaimNames) {
            Object claimValue = this.claimsSet.getClaimValue(name);
            if (claimValue instanceof List) {
                this.replaceList(name);
                continue;
            }
            if (claimValue instanceof Map) {
                this.replaceMap(name);
                continue;
            }
            if (!(claimValue instanceof Number)) continue;
            this.replaceNumber(name);
        }
    }

    private Set<String> filterCustomClaimNames(Collection<String> claimNames) {
        HashSet<String> customNames = new HashSet<String>(claimNames);
        for (Claims claim : Claims.values()) {
            customNames.remove(claim.name());
        }
        return customNames;
    }

    private void replaceMap(String name) {
        try {
            Map map = (Map)this.claimsSet.getClaimValue(name, Map.class);
            JsonObject jsonObject = DefaultJWTCallerPrincipal.replaceMap(map);
            this.claimsSet.setClaim(name, (Object)jsonObject);
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)("replaceMap failure for: " + name), (Throwable)e);
        }
    }

    private void replaceList(String name) {
        try {
            JsonArray array = (JsonArray)DefaultJWTCallerPrincipal.wrapValue(this.claimsSet.getClaimValue(name, List.class));
            this.claimsSet.setClaim(name, (Object)array);
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)("replaceList failure for: " + name), (Throwable)e);
        }
    }

    private void replaceNumber(String name) {
        try {
            Number number = (Number)this.claimsSet.getClaimValue(name, Number.class);
            JsonNumber jsonNumber = (JsonNumber)DefaultJWTCallerPrincipal.wrapValue(number);
            this.claimsSet.setClaim(name, (Object)jsonNumber);
        }
        catch (MalformedClaimException e) {
            logger.warn((Object)("replaceNumber failure for: " + name), (Throwable)e);
        }
    }
}

