/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.auth.principal.DefaultJWTCallerPrincipal;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipal;
import io.smallrye.jwt.auth.principal.JWTCallerPrincipalFactory;
import io.smallrye.jwt.auth.principal.KeyLocationResolver;
import io.smallrye.jwt.auth.principal.ParseException;
import java.io.IOException;
import java.security.Key;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jose4j.jwa.AlgorithmConstraints;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.JoseException;

public class DefaultJWTCallerPrincipalFactory
extends JWTCallerPrincipalFactory {
    private HttpsJwks httpsJwks;

    @Override
    public JWTCallerPrincipal parse(String token, JWTAuthContextInfo authContextInfo) throws ParseException {
        DefaultJWTCallerPrincipal principal;
        try {
            JwtConsumerBuilder builder = new JwtConsumerBuilder().setRequireExpirationTime().setRequireSubject().setSkipDefaultAudienceValidation().setJwsAlgorithmConstraints(new AlgorithmConstraints(AlgorithmConstraints.ConstraintType.WHITELIST, new String[]{"RS256"}));
            if (authContextInfo.isRequireIssuer()) {
                builder.setExpectedIssuer(true, authContextInfo.getIssuedBy());
            } else {
                builder.setExpectedIssuer(false, null);
            }
            if (authContextInfo.getSignerKey() != null) {
                builder.setVerificationKey((Key)authContextInfo.getSignerKey());
            } else if (authContextInfo.isFollowMpJwt11Rules()) {
                builder.setVerificationKeyResolver((VerificationKeyResolver)new KeyLocationResolver(authContextInfo.getJwksUri()));
            } else {
                List<JsonWebKey> jsonWebKeys = this.loadJsonWebKeys(authContextInfo);
                builder.setVerificationKeyResolver((VerificationKeyResolver)new JwksVerificationKeyResolver(jsonWebKeys));
            }
            if (authContextInfo.getExpGracePeriodSecs() > 0) {
                builder.setAllowedClockSkewInSeconds(authContextInfo.getExpGracePeriodSecs());
            } else {
                builder.setEvaluationTime(NumericDate.fromSeconds((long)0L));
            }
            JwtConsumer jwtConsumer = builder.build();
            JwtContext jwtContext = jwtConsumer.process(token);
            String type = ((JsonWebStructure)jwtContext.getJoseObjects().get(0)).getHeader("typ");
            jwtConsumer.processContext(jwtContext);
            JwtClaims claimsSet = jwtContext.getJwtClaims();
            principal = new DefaultJWTCallerPrincipal(token, type, claimsSet);
        }
        catch (InvalidJwtException e) {
            throw new ParseException("Failed to verify token", e);
        }
        return principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<JsonWebKey> loadJsonWebKeys(JWTAuthContextInfo authContextInfo) {
        DefaultJWTCallerPrincipalFactory defaultJWTCallerPrincipalFactory = this;
        synchronized (defaultJWTCallerPrincipalFactory) {
            if (authContextInfo.getJwksUri() == null) {
                return Collections.emptyList();
            }
            if (this.httpsJwks == null) {
                this.httpsJwks = new HttpsJwks(authContextInfo.getJwksUri());
                this.httpsJwks.setDefaultCacheDuration(authContextInfo.getJwksRefreshInterval().longValue() * 60L);
            }
        }
        try {
            return this.httpsJwks.getJsonWebKeys().stream().filter(jsonWebKey -> "sig".equals(jsonWebKey.getUse())).filter(jsonWebKey -> "RS256".equals(jsonWebKey.getAlgorithm())).collect(Collectors.toList());
        }
        catch (IOException | JoseException e) {
            throw new IllegalStateException(String.format("Unable to fetch JWKS from %s.", authContextInfo.getJwksUri()), e);
        }
    }
}

