/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.KeyUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.math.BigInteger;
import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.jboss.logging.Logger;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class KeyLocationResolver
implements VerificationKeyResolver {
    private static final Logger log = Logger.getLogger(KeyLocationResolver.class);
    private String location;
    private StringWriter contents;
    private byte[] base64Decode;

    public KeyLocationResolver(String location) {
        this.location = location;
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        PublicKey key = null;
        String kid = jws.getHeaders().getStringHeaderValue("kid");
        try {
            this.loadContents();
        }
        catch (IOException e) {
            throw new UnresolvableKeyException("Failed to load key from: " + this.location, (Throwable)e);
        }
        key = this.tryAsJWKx(kid);
        if (key == null) {
            key = this.tryAsPEM();
        }
        if (key == null) {
            throw new UnresolvableKeyException("Failed to read location as any of JWK, JWKS, PEM; " + this.location);
        }
        return key;
    }

    private PublicKey tryAsPEM() {
        PublicKey publicKey = null;
        try {
            publicKey = KeyUtils.decodePublicKey(this.contents.toString());
        }
        catch (Exception e) {
            log.debug((Object)"Failed to read location as PEM", (Throwable)e);
        }
        return publicKey;
    }

    private PublicKey tryAsJWKx(String kid) {
        PublicKey publicKey = null;
        try {
            log.debugf("Trying location as JWK(S)...", new Object[0]);
            String json = this.base64Decode != null ? new String(this.base64Decode) : this.contents.toString();
            JsonObject jwks = Json.createReader((Reader)new StringReader(json)).readObject();
            JsonArray keys = jwks.getJsonArray("keys");
            JsonObject jwk = keys != null ? keys.getJsonObject(0) : jwks;
            String e = jwk.getString("e");
            String n = jwk.getString("n");
            byte[] ebytes = Base64.getUrlDecoder().decode(e);
            BigInteger publicExponent = new BigInteger(1, ebytes);
            byte[] nbytes = Base64.getUrlDecoder().decode(n);
            BigInteger modulus = new BigInteger(1, nbytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
            publicKey = kf.generatePublic(rsaPublicKeySpec);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to read location as JWK(S)", (Throwable)e);
        }
        return publicKey;
    }

    private void loadContents() throws IOException {
        InputStream is;
        this.contents = new StringWriter();
        if (this.location.startsWith("classpath:") || this.location.indexOf(58) < 0) {
            String path = this.location.startsWith("classpath:") ? this.location.substring(10) : this.location;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            is = loader.getResourceAsStream(path);
        } else {
            URL locationURL = new URL(this.location);
            is = locationURL.openStream();
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = reader.readLine();
            while (line != null) {
                if (!line.startsWith("-----BEGIN") && !line.startsWith("-----END")) {
                    this.contents.write(line);
                }
                line = reader.readLine();
            }
        }
        try {
            this.base64Decode = Base64.getDecoder().decode(this.contents.toString());
        }
        catch (Exception e) {
            this.base64Decode = null;
            log.debug((Object)"contents does not appear to be base64 encoded");
        }
    }
}

