/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.config;

import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.security.interfaces.RSAPublicKey;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Dependent
public class JWTAuthContextInfoProvider {
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String COOKIE_HEADER = "Cookie";
    private static final String NONE = "NONE";
    private static final Logger log = Logger.getLogger(JWTAuthContextInfoProvider.class);
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey", defaultValue="NONE")
    private Optional<String> mpJwtPublicKey;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.issuer", defaultValue="NONE")
    private String mpJwtIssuer;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.location", defaultValue="NONE")
    private Optional<String> mpJwtLocation;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.requireiss", defaultValue="true")
    private Optional<Boolean> mpJwtRequireIss;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.header", defaultValue="Authorization")
    private String tokenHeader;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.cookie")
    private Optional<String> tokenCookie;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.groups")
    private Optional<String> defaultGroupsClaim;

    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        log.debugf("init, mpJwtPublicKey=%s, mpJwtIssuer=%s, mpJwtLocation=%s", (Object)this.mpJwtPublicKey.orElse("missing"), (Object)this.mpJwtIssuer, (Object)this.mpJwtLocation.orElse("missing"));
        if (NONE.equals(this.mpJwtPublicKey.get()) && NONE.equals(this.mpJwtLocation.get())) {
            return Optional.empty();
        }
        JWTAuthContextInfo contextInfo = new JWTAuthContextInfo();
        if (this.mpJwtPublicKey.isPresent() && !NONE.equals(this.mpJwtPublicKey.get())) {
            this.decodeMpJwtPublicKey(contextInfo);
        }
        if (this.mpJwtIssuer != null && !this.mpJwtIssuer.equals(NONE)) {
            contextInfo.setIssuedBy(this.mpJwtIssuer);
        } else {
            contextInfo.setRequireIssuer(false);
        }
        if (this.mpJwtRequireIss != null && this.mpJwtRequireIss.isPresent()) {
            contextInfo.setRequireIssuer(this.mpJwtRequireIss.get());
        } else {
            contextInfo.setRequireIssuer(true);
        }
        if (this.mpJwtLocation.isPresent() && !NONE.equals(this.mpJwtLocation.get())) {
            this.setMpJwtLocation(contextInfo);
        }
        this.setTokenHeadersAndGroups(contextInfo);
        return Optional.of(contextInfo);
    }

    protected void setMpJwtLocation(JWTAuthContextInfo contextInfo) {
        contextInfo.setJwksUri(this.mpJwtLocation.get());
        contextInfo.setFollowMpJwt11Rules(true);
    }

    protected void decodeMpJwtPublicKey(JWTAuthContextInfo contextInfo) {
        try {
            RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodeJWKSPublicKey(this.mpJwtPublicKey.get());
            contextInfo.setSignerKey(pk);
            log.debugf("mpJwtPublicKey parsed as JWK(S)", new Object[0]);
        }
        catch (Exception e) {
            log.debugf("mpJwtPublicKey failed as JWK(S), %s", (Object)e.getMessage());
            try {
                RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey(this.mpJwtPublicKey.get());
                contextInfo.setSignerKey(pk);
                log.debugf("mpJwtPublicKey parsed as PEM", new Object[0]);
            }
            catch (Exception e1) {
                throw new DeploymentException((Throwable)e1);
            }
        }
    }

    protected void setTokenHeadersAndGroups(JWTAuthContextInfo contextInfo) {
        if (this.tokenHeader != null) {
            contextInfo.setTokenHeader(this.tokenHeader);
        }
        if (this.tokenCookie.isPresent()) {
            if (!COOKIE_HEADER.equals(this.tokenHeader)) {
                log.warn((Object)"Token header is not 'Cookie', the cookie name value will be ignored");
            } else {
                contextInfo.setTokenCookie(this.tokenCookie.get());
            }
        }
        if (this.defaultGroupsClaim.isPresent()) {
            contextInfo.setDefaultGroupsClaim(this.defaultGroupsClaim.get());
        }
    }

    public Optional<String> getMpJwtPublicKey() {
        return this.mpJwtPublicKey;
    }

    public String getMpJwtIssuer() {
        return this.mpJwtIssuer;
    }

    public Optional<String> getMpJwtLocation() {
        return this.mpJwtLocation;
    }

    public Optional<Boolean> getMpJwtRequireIss() {
        return this.mpJwtRequireIss;
    }

    @Produces
    public JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().get();
    }
}

