/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.auth.cdi.ClaimValueProducer;
import io.smallrye.jwt.auth.cdi.CommonJwtProducer;
import io.smallrye.jwt.auth.cdi.JsonValueProducer;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.cdi.RawClaimTypeProducer;
import io.smallrye.jwt.auth.jaxrs.JWTAuthenticationFilter;
import io.smallrye.jwt.auth.mechanism.JWTHttpAuthenticationMechanism;
import io.smallrye.jwt.config.JWTAuthContextInfoProvider;
import java.lang.annotation.Annotation;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.Extension;
import org.jboss.logging.Logger;

public class SmallRyeJWTAuthCDIExtension
implements Extension {
    private static Logger logger = Logger.getLogger(SmallRyeJWTAuthCDIExtension.class);

    public static boolean isHttpAuthMechanismEnabled() {
        boolean enabled = false;
        if (SmallRyeJWTAuthCDIExtension.isEESecurityAvailable()) {
            try {
                Instance instance = CDI.current().select(JWTHttpAuthenticationMechanism.class, new Annotation[0]);
                enabled = instance.isResolvable();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return enabled;
    }

    private static boolean isEESecurityAvailable() {
        try {
            Class.forName("javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        logger.debugf("beanManager = %s", (Object)beanManager);
        this.addAnnotatedType(event, beanManager, ClaimValueProducer.class);
        this.addAnnotatedType(event, beanManager, CommonJwtProducer.class);
        this.addAnnotatedType(event, beanManager, JsonValueProducer.class);
        this.addAnnotatedType(event, beanManager, JWTAuthContextInfoProvider.class);
        this.addAnnotatedType(event, beanManager, JWTAuthenticationFilter.class);
        this.addAnnotatedType(event, beanManager, PrincipalProducer.class);
        this.addAnnotatedType(event, beanManager, RawClaimTypeProducer.class);
        if (SmallRyeJWTAuthCDIExtension.isEESecurityAvailable()) {
            this.addAnnotatedType(event, beanManager, JWTHttpAuthenticationMechanism.class);
            logger.debugf("EE Security is available, JWTHttpAuthenticationMechanism has been registered", new Object[0]);
        } else {
            logger.infof("EE Security is not available, JWTHttpAuthenticationMechanism will not be registered", new Object[0]);
        }
    }

    void addAnnotatedType(BeforeBeanDiscovery event, BeanManager beanManager, Class<?> type) {
        String id = "SmallRye" + type.getSimpleName();
        event.addAnnotatedType(beanManager.createAnnotatedType(type), id);
        logger.debugf("Added type: %s", (Object)type.getName());
    }
}

