/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.config;

import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.SmallryeJwtUtils;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.security.interfaces.RSAPublicKey;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.DeploymentException;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Dependent
public class JWTAuthContextInfoProvider {
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String NONE = "NONE";
    private static final String DEFAULT_GROUPS_SEPARATOR = " ";
    private static final Logger log = Logger.getLogger(JWTAuthContextInfoProvider.class);
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey", defaultValue="NONE")
    private Optional<String> mpJwtPublicKey;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.issuer", defaultValue="NONE")
    private String mpJwtIssuer;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.publickey.location", defaultValue="NONE")
    private Optional<String> mpJwtLocation;
    @Inject
    @ConfigProperty(name="mp.jwt.verify.requireiss", defaultValue="true")
    private Optional<Boolean> mpJwtRequireIss;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.header", defaultValue="Authorization")
    private String tokenHeader;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.cookie")
    private Optional<String> tokenCookie;
    @Inject
    @ConfigProperty(name="smallrye.jwt.token.kid")
    private Optional<String> tokenKeyId;
    @Inject
    @ConfigProperty(name="smallrye.jwt.require.named-principal", defaultValue="false")
    private Optional<Boolean> requireNamedPrincipal;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.sub")
    private Optional<String> defaultSubClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.sub")
    private Optional<String> subPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.claims.groups")
    private Optional<String> defaultGroupsClaim;
    @Inject
    @ConfigProperty(name="smallrye.jwt.path.groups")
    private Optional<String> groupsPath;
    @Inject
    @ConfigProperty(name="smallrye.jwt.groups-separator", defaultValue=" ")
    private String groupsSeparator;
    @Inject
    @ConfigProperty(name="smallrye.jwt.expiration.grace", defaultValue="60")
    private Optional<Integer> expGracePeriodSecs;
    @Inject
    @ConfigProperty(name="smallrye.jwt.jwks.refresh-interval", defaultValue="60")
    private Optional<Integer> jwksRefreshInterval;
    @Inject
    @ConfigProperty(name="smallrye.jwt.whitelist.algorithms")
    private Optional<String> whitelistAlgorithms;
    @Inject
    @ConfigProperty(name="smallrye.jwt.verify.aud")
    Optional<Set<String>> expectedAudience;

    public static JWTAuthContextInfoProvider createWithKey(String publicKey, String issuer) {
        return JWTAuthContextInfoProvider.create(publicKey, NONE, issuer);
    }

    public static JWTAuthContextInfoProvider createWithKeyLocation(String publicKeyLocation, String issuer) {
        return JWTAuthContextInfoProvider.create(NONE, publicKeyLocation, issuer);
    }

    private static JWTAuthContextInfoProvider create(String publicKey, String publicKeyLocation, String issuer) {
        JWTAuthContextInfoProvider provider = new JWTAuthContextInfoProvider();
        provider.mpJwtPublicKey = Optional.of(publicKey);
        provider.mpJwtLocation = Optional.of(publicKeyLocation);
        provider.mpJwtIssuer = issuer;
        provider.mpJwtRequireIss = Optional.of(Boolean.TRUE);
        provider.tokenHeader = AUTHORIZATION_HEADER;
        provider.tokenCookie = Optional.empty();
        provider.tokenKeyId = Optional.empty();
        provider.requireNamedPrincipal = Optional.of(Boolean.TRUE);
        provider.defaultSubClaim = Optional.empty();
        provider.subPath = Optional.empty();
        provider.defaultGroupsClaim = Optional.empty();
        provider.groupsPath = Optional.empty();
        provider.expGracePeriodSecs = Optional.of(60);
        provider.jwksRefreshInterval = Optional.empty();
        provider.whitelistAlgorithms = Optional.empty();
        provider.expectedAudience = Optional.empty();
        provider.groupsSeparator = DEFAULT_GROUPS_SEPARATOR;
        return provider;
    }

    @Produces
    Optional<JWTAuthContextInfo> getOptionalContextInfo() {
        log.debugf("init, mpJwtPublicKey=%s, mpJwtIssuer=%s, mpJwtLocation=%s", (Object)this.mpJwtPublicKey.orElse("missing"), (Object)this.mpJwtIssuer, (Object)this.mpJwtLocation.orElse("missing"));
        if (NONE.equals(this.mpJwtPublicKey.get()) && NONE.equals(this.mpJwtLocation.get())) {
            log.debugf("Neither mpJwtPublicKey nor mpJwtLocation properties are configured, JWTAuthContextInfo will not be available", new Object[0]);
            return Optional.empty();
        }
        JWTAuthContextInfo contextInfo = new JWTAuthContextInfo();
        this.decodeMpJwtPublicKey(contextInfo);
        if (this.mpJwtIssuer != null && !this.mpJwtIssuer.equals(NONE)) {
            contextInfo.setIssuedBy(this.mpJwtIssuer);
        } else {
            contextInfo.setRequireIssuer(false);
        }
        contextInfo.setRequireIssuer(this.mpJwtRequireIss.orElse(true));
        if (this.mpJwtLocation.isPresent() && !NONE.equals(this.mpJwtLocation.get())) {
            contextInfo.setPublicKeyLocation(this.mpJwtLocation.get());
        }
        if (this.tokenHeader != null) {
            contextInfo.setTokenHeader(this.tokenHeader);
        }
        contextInfo.setTokenKeyId(this.tokenKeyId.orElse(null));
        contextInfo.setRequireNamedPrincipal((Boolean)this.requireNamedPrincipal.orElse(null));
        SmallryeJwtUtils.setContextTokenCookie(contextInfo, this.tokenCookie);
        contextInfo.setDefaultSubjectClaim(this.defaultSubClaim.orElse(null));
        SmallryeJwtUtils.setContextSubPath(contextInfo, this.subPath);
        contextInfo.setDefaultGroupsClaim(this.defaultGroupsClaim.orElse(null));
        SmallryeJwtUtils.setContextGroupsPath(contextInfo, this.groupsPath);
        contextInfo.setExpGracePeriodSecs((Integer)this.expGracePeriodSecs.orElse(null));
        contextInfo.setJwksRefreshInterval(this.jwksRefreshInterval.orElse(null));
        SmallryeJwtUtils.setWhitelistAlgorithms(contextInfo, this.whitelistAlgorithms);
        contextInfo.setExpectedAudience(this.expectedAudience.orElse(null));
        contextInfo.setGroupsSeparator(this.groupsSeparator);
        return Optional.of(contextInfo);
    }

    protected void decodeMpJwtPublicKey(JWTAuthContextInfo contextInfo) {
        if (!this.mpJwtPublicKey.isPresent() || NONE.equals(this.mpJwtPublicKey.get())) {
            return;
        }
        try {
            RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodeJWKSPublicKey(this.mpJwtPublicKey.get());
            contextInfo.setSignerKey(pk);
            log.debugf("mpJwtPublicKey parsed as JWK(S)", new Object[0]);
        }
        catch (Exception e) {
            log.debugf("mpJwtPublicKey failed as JWK(S), %s", (Object)e.getMessage());
            try {
                RSAPublicKey pk = (RSAPublicKey)KeyUtils.decodePublicKey(this.mpJwtPublicKey.get());
                contextInfo.setSignerKey(pk);
                log.debugf("mpJwtPublicKey parsed as PEM", new Object[0]);
            }
            catch (Exception e1) {
                throw new DeploymentException((Throwable)e1);
            }
        }
    }

    public Optional<String> getMpJwtPublicKey() {
        return this.mpJwtPublicKey;
    }

    public String getMpJwtIssuer() {
        return this.mpJwtIssuer;
    }

    public Optional<String> getMpJwtLocation() {
        return this.mpJwtLocation;
    }

    public Optional<Boolean> getMpJwtRequireIss() {
        return this.mpJwtRequireIss;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public Optional<String> getTokenCookie() {
        return this.tokenCookie;
    }

    public Optional<String> getTokenKeyId() {
        return this.tokenKeyId;
    }

    public Optional<Integer> getExpGracePeriodSecs() {
        return this.expGracePeriodSecs;
    }

    public Optional<Integer> getJwksRefreshInterval() {
        return this.jwksRefreshInterval;
    }

    public Optional<String> getDefaultGroupsClaim() {
        return this.defaultGroupsClaim;
    }

    public Optional<String> getGroupsPath() {
        return this.groupsPath;
    }

    public String getGroupsSeparator() {
        return this.groupsSeparator;
    }

    public Optional<String> getSubjectPath() {
        return this.subPath;
    }

    public Optional<String> getDefaultSubjectClaim() {
        return this.defaultSubClaim;
    }

    public Optional<String> getWhitelistAlgorithms() {
        return this.whitelistAlgorithms;
    }

    public Optional<Set<String>> getExpectedAudience() {
        return this.expectedAudience;
    }

    @Produces
    @ApplicationScoped
    public JWTAuthContextInfo getContextInfo() {
        return this.getOptionalContextInfo().orElseThrow(JWTAuthContextInfoProvider.throwException());
    }

    private static Supplier<IllegalStateException> throwException() {
        String error = "JWTAuthContextInfo has not been initialized. Please make sure that either 'mp.jwt.verify.publickey' or 'mp.jwt.verify.publickey.location' properties are set.";
        return () -> new IllegalStateException("JWTAuthContextInfo has not been initialized. Please make sure that either 'mp.jwt.verify.publickey' or 'mp.jwt.verify.publickey.location' properties are set.");
    }
}

