/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.algorithm;

public enum KeyEncryptionAlgorithm {
    RSA_OAEP_256("RSA-OAEP-256"),
    ECDH_ES_A256KW("ECDH-ES+A256KW"),
    A256KW("A256KW");

    private String algorithmName;

    private KeyEncryptionAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithm() {
        return this.algorithmName;
    }

    public static KeyEncryptionAlgorithm fromAlgorithm(String algorithmName) {
        return KeyEncryptionAlgorithm.valueOf(algorithmName.replaceAll("-", "_").replaceAll("\\+", "_"));
    }
}

