/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.build.impl;

import io.smallrye.jwt.build.JwtEncryptionBuilder;
import io.smallrye.jwt.build.JwtException;
import io.smallrye.jwt.build.JwtSignature;
import io.smallrye.jwt.build.JwtSignatureException;
import io.smallrye.jwt.build.impl.JwtEncryptionImpl;
import io.smallrye.jwt.build.impl.JwtSigningUtils;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.crypto.SecretKey;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jose4j.jwt.JwtClaims;

class JwtSignatureImpl
implements JwtSignature {
    JwtClaims claims = new JwtClaims();
    Map<String, Object> headers = new HashMap<String, Object>();

    JwtSignatureImpl() {
    }

    JwtSignatureImpl(JwtClaims claims) {
        this.claims = claims;
    }

    @Override
    public String sign(PrivateKey signingKey) throws JwtException {
        return JwtSigningUtils.signJwtClaimsInternal(signingKey, this.headers, this.claims);
    }

    @Override
    public String sign(SecretKey signingKey) throws JwtException {
        return JwtSigningUtils.signJwtClaimsInternal(signingKey, this.headers, this.claims);
    }

    @Override
    public String sign() throws JwtException {
        return JwtSigningUtils.signJwtClaimsInternal(this.headers, this.claims);
    }

    @Override
    public JwtEncryptionBuilder innerSign(PrivateKey signingKey) throws JwtSignatureException {
        return new JwtEncryptionImpl(this.sign(signingKey), true);
    }

    @Override
    public JwtEncryptionBuilder innerSign(SecretKey signingKey) throws JwtSignatureException {
        return new JwtEncryptionImpl(this.sign(signingKey), true);
    }

    @Override
    public JwtEncryptionBuilder innerSign() throws JwtSignatureException {
        if (!JwtSignatureImpl.signingKeyConfigured()) {
            if (this.headers.containsKey("alg") && !"none".equals(this.headers.get("alg"))) {
                throw new JwtSignatureException("Inner JWT can not be created, 'smallrye.jwt.sign.key-location' is not set but the 'alg' header is: " + this.headers.get("alg").toString());
            }
            if (this.headers.containsKey("kid")) {
                throw new JwtSignatureException("'none' algorithm is selected but the key id 'kid' header is set");
            }
            this.headers.put("alg", "none");
        }
        return new JwtEncryptionImpl(this.sign(), true);
    }

    private static boolean signingKeyConfigured() {
        try {
            ConfigProvider.getConfig().getValue("smallrye.jwt.sign.key-location", String.class);
            return true;
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }
}

