/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import java.util.Set;
import javax.annotation.Priority;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Priority(value=1)
@Alternative
@RequestScoped
public class PrincipalProducer {
    private JsonWebToken token;

    public void setJsonWebToken(JsonWebToken token) {
        this.token = token;
    }

    @Produces
    @RequestScoped
    JsonWebToken currentJWTPrincipalOrNull() {
        return this.token == null ? new NullJsonWebToken() : this.token;
    }

    private static class NullJsonWebToken
    implements JsonWebToken {
        private NullJsonWebToken() {
        }

        public String getName() {
            return null;
        }

        public Set<String> getClaimNames() {
            return null;
        }

        public <T> T getClaim(String claimName) {
            return null;
        }
    }
}

