/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth;

import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import org.jboss.logging.Logger;

public abstract class AbstractBearerTokenExtractor {
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String COOKIE_HEADER = "Cookie";
    protected static final String BEARER = "Bearer";
    protected static final String BEARER_SCHEME_PREFIX = "Bearer ";
    private static final Logger LOGGER = Logger.getLogger(AbstractBearerTokenExtractor.class);
    private final JWTAuthContextInfo authContextInfo;

    protected AbstractBearerTokenExtractor(JWTAuthContextInfo authContextInfo) {
        this.authContextInfo = authContextInfo;
    }

    public String getBearerToken() {
        String bearerValue;
        String tokenHeaderName = this.authContextInfo.getTokenHeader();
        boolean fallbackToHeader = this.authContextInfo.isAlwaysCheckAuthorization();
        LOGGER.debugf("tokenHeaderName = %s", (Object)tokenHeaderName);
        if (COOKIE_HEADER.equals(tokenHeaderName)) {
            String intermediateBearerValue = this.getBearerTokenCookie();
            bearerValue = intermediateBearerValue == null && fallbackToHeader ? this.getBearerTokenAuthHeader() : intermediateBearerValue;
        } else if (AUTHORIZATION_HEADER.equals(tokenHeaderName)) {
            bearerValue = this.getBearerTokenAuthHeader();
        } else {
            bearerValue = this.getHeaderValue(tokenHeaderName);
            if (bearerValue == null) {
                LOGGER.debugf("Header %s was null", (Object)tokenHeaderName);
            }
        }
        return bearerValue;
    }

    private String getBearerTokenCookie() {
        String tokenCookieName = this.authContextInfo.getTokenCookie();
        if (tokenCookieName == null) {
            tokenCookieName = BEARER;
        }
        LOGGER.debugf("tokenCookieName = %s", (Object)tokenCookieName);
        String bearerValue = this.getCookieValue(tokenCookieName);
        if (bearerValue == null) {
            LOGGER.debugf("Cookie %s was null", (Object)tokenCookieName);
        }
        return bearerValue;
    }

    private String getBearerTokenAuthHeader() {
        String bearerValue;
        String tokenHeader = this.getHeaderValue(AUTHORIZATION_HEADER);
        if (tokenHeader != null) {
            String token = this.getTokenWithConfiguredScheme(tokenHeader);
            if (token != null) {
                bearerValue = token;
            } else {
                LOGGER.debugf("Authorization header does not contain a Bearer prefix", new Object[0]);
                bearerValue = null;
            }
        } else {
            LOGGER.debugf("Authorization header was null", new Object[0]);
            bearerValue = null;
        }
        return bearerValue;
    }

    private String getTokenWithConfiguredScheme(String tokenHeader) {
        for (String scheme : this.authContextInfo.getTokenSchemes()) {
            String schemePrefix = scheme + " ";
            if (!AbstractBearerTokenExtractor.isTokenScheme(tokenHeader, schemePrefix)) continue;
            return tokenHeader.substring(schemePrefix.length());
        }
        return null;
    }

    private static boolean isTokenScheme(String authorizationHeader, String schemePrefix) {
        if (authorizationHeader.length() < schemePrefix.length()) {
            return false;
        }
        String scheme = authorizationHeader.substring(0, schemePrefix.length());
        return schemePrefix.equalsIgnoreCase(scheme);
    }

    protected abstract String getHeaderValue(String var1);

    protected abstract String getCookieValue(String var1);
}

