/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;

public class JWTAuthContextInfo {
    private PublicKey publicVerificationKey;
    private SecretKey secretVerificationKey;
    private PrivateKey privateDecryptionKey;
    private SecretKey secretDecryptionKey;
    private String issuedBy;
    private int expGracePeriodSecs = 60;
    private Long maxTimeToLiveSecs;
    private String publicKeyLocation;
    private String publicKeyContent;
    private String decryptionKeyLocation;
    private String decryptionKeyContent;
    private Integer jwksRefreshInterval;
    private int forcedJwksRefreshInterval = 30;
    private String tokenHeader = "Authorization";
    private String tokenCookie;
    private boolean alwaysCheckAuthorization;
    private String tokenKeyId;
    private String tokenDecryptionKeyId;
    private List<String> tokenSchemes = Collections.singletonList("Bearer");
    private boolean requireNamedPrincipal = true;
    private String defaultSubClaim;
    private String subPath;
    private String defaultGroupsClaim;
    private String groupsPath;
    private List<String> whitelistAlgorithms = new ArrayList<String>();
    private SignatureAlgorithm signatureAlgorithm = SignatureAlgorithm.RS256;
    private KeyEncryptionAlgorithm keyEncryptionAlgorithm = KeyEncryptionAlgorithm.RSA_OAEP;
    private KeyFormat keyFormat = KeyFormat.ANY;
    private Set<String> expectedAudience;
    private String groupsSeparator = " ";
    private Set<String> requiredClaims;
    private boolean relaxVerificationKeyValidation;
    private boolean verifyCertificateThumbprint;
    private boolean requireIssuer = true;

    public JWTAuthContextInfo() {
    }

    public JWTAuthContextInfo(PublicKey verificationKey, String issuedBy) {
        this.publicVerificationKey = verificationKey;
        this.issuedBy = issuedBy;
    }

    public JWTAuthContextInfo(SecretKey verificationKey, String issuedBy) {
        this.secretVerificationKey = verificationKey;
        this.issuedBy = issuedBy;
    }

    public JWTAuthContextInfo(String publicKeyLocation, String issuedBy) {
        this.publicKeyLocation = publicKeyLocation;
        this.issuedBy = issuedBy;
    }

    public JWTAuthContextInfo(JWTAuthContextInfo orig) {
        this.publicVerificationKey = orig.publicVerificationKey;
        this.secretVerificationKey = orig.secretVerificationKey;
        this.privateDecryptionKey = orig.privateDecryptionKey;
        this.secretDecryptionKey = orig.secretDecryptionKey;
        this.issuedBy = orig.issuedBy;
        this.expGracePeriodSecs = orig.expGracePeriodSecs;
        this.maxTimeToLiveSecs = orig.maxTimeToLiveSecs;
        this.publicKeyLocation = orig.publicKeyLocation;
        this.publicKeyContent = orig.publicKeyContent;
        this.decryptionKeyLocation = orig.decryptionKeyLocation;
        this.decryptionKeyContent = orig.decryptionKeyContent;
        this.jwksRefreshInterval = orig.jwksRefreshInterval;
        this.forcedJwksRefreshInterval = orig.forcedJwksRefreshInterval;
        this.tokenHeader = orig.tokenHeader;
        this.tokenCookie = orig.tokenCookie;
        this.alwaysCheckAuthorization = orig.alwaysCheckAuthorization;
        this.tokenKeyId = orig.tokenKeyId;
        this.tokenDecryptionKeyId = orig.tokenDecryptionKeyId;
        this.tokenSchemes = orig.tokenSchemes;
        this.requireNamedPrincipal = orig.requireNamedPrincipal;
        this.defaultSubClaim = orig.defaultSubClaim;
        this.subPath = orig.subPath;
        this.defaultGroupsClaim = orig.defaultGroupsClaim;
        this.groupsPath = orig.groupsPath;
        this.whitelistAlgorithms = orig.whitelistAlgorithms;
        this.signatureAlgorithm = orig.signatureAlgorithm;
        this.keyEncryptionAlgorithm = orig.keyEncryptionAlgorithm;
        this.keyFormat = orig.keyFormat;
        this.expectedAudience = orig.expectedAudience;
        this.groupsSeparator = orig.groupsSeparator;
        this.requiredClaims = orig.requiredClaims;
        this.relaxVerificationKeyValidation = orig.relaxVerificationKeyValidation;
        this.requireIssuer = orig.requireIssuer;
        this.verifyCertificateThumbprint = orig.verifyCertificateThumbprint;
    }

    @Deprecated
    public RSAPublicKey getSignerKey() {
        return (RSAPublicKey)this.publicVerificationKey;
    }

    @Deprecated
    public void setSignerKey(RSAPublicKey signerKey) {
        this.publicVerificationKey = signerKey;
    }

    public PublicKey getPublicVerificationKey() {
        return this.publicVerificationKey;
    }

    public void setPublicVerificationKey(PublicKey verificationKey) {
        this.publicVerificationKey = verificationKey;
    }

    public SecretKey getSecretVerificationKey() {
        return this.secretVerificationKey;
    }

    public void setSecretVerificationKey(SecretKey verificationKey) {
        this.secretVerificationKey = verificationKey;
    }

    public PrivateKey getPrivateDecryptionKey() {
        return this.privateDecryptionKey;
    }

    public void setPrivateDecryptionKey(PrivateKey decryptionKey) {
        this.privateDecryptionKey = decryptionKey;
    }

    public SecretKey getSecretDecryptionKey() {
        return this.secretDecryptionKey;
    }

    public void setSecretDecryptionKey(SecretKey decryptionKey) {
        this.secretDecryptionKey = decryptionKey;
    }

    public String getIssuedBy() {
        return this.issuedBy;
    }

    public void setIssuedBy(String issuedBy) {
        this.issuedBy = issuedBy;
    }

    public int getExpGracePeriodSecs() {
        return this.expGracePeriodSecs;
    }

    public void setExpGracePeriodSecs(int expGracePeriodSecs) {
        this.expGracePeriodSecs = expGracePeriodSecs;
    }

    public Long getMaxTimeToLiveSecs() {
        return this.maxTimeToLiveSecs;
    }

    public void setMaxTimeToLiveSecs(Long maxTimeToLiveSecs) {
        this.maxTimeToLiveSecs = maxTimeToLiveSecs;
    }

    public String getPublicKeyLocation() {
        return this.publicKeyLocation;
    }

    public void setPublicKeyLocation(String publicKeyLocation) {
        this.publicKeyLocation = publicKeyLocation;
    }

    public String getDecryptionKeyLocation() {
        return this.decryptionKeyLocation;
    }

    public void setDecryptionKeyLocation(String keyLocation) {
        this.decryptionKeyLocation = keyLocation;
    }

    public KeyEncryptionAlgorithm getKeyEncryptionAlgorithm() {
        return this.keyEncryptionAlgorithm;
    }

    public void setKeyEncryptionAlgorithm(KeyEncryptionAlgorithm algorithm) {
        this.keyEncryptionAlgorithm = algorithm;
    }

    public String getPublicKeyContent() {
        return this.publicKeyContent;
    }

    public void setPublicKeyContent(String publicKeyContent) {
        this.publicKeyContent = publicKeyContent;
    }

    public String getDecryptionKeyContent() {
        return this.decryptionKeyContent;
    }

    public void setDecryptionKeyContent(String keyContent) {
        this.decryptionKeyContent = keyContent;
    }

    public Integer getJwksRefreshInterval() {
        return this.jwksRefreshInterval;
    }

    public void setJwksRefreshInterval(Integer jwksRefreshInterval) {
        this.jwksRefreshInterval = jwksRefreshInterval;
    }

    public int getForcedJwksRefreshInterval() {
        return this.forcedJwksRefreshInterval;
    }

    public void setForcedJwksRefreshInterval(int forcedJwksRefreshInterval) {
        this.forcedJwksRefreshInterval = forcedJwksRefreshInterval;
    }

    @Deprecated
    public boolean isRequireIssuer() {
        return this.requireIssuer;
    }

    @Deprecated
    public void setRequireIssuer(boolean requireIssuer) {
        this.requireIssuer = requireIssuer;
    }

    public String getTokenHeader() {
        return this.tokenHeader;
    }

    public void setTokenHeader(String tokenHeader) {
        this.tokenHeader = tokenHeader;
    }

    public String getTokenCookie() {
        return this.tokenCookie;
    }

    public void setTokenCookie(String tokenCookie) {
        this.tokenCookie = tokenCookie;
    }

    public boolean isRequireNamedPrincipal() {
        return this.requireNamedPrincipal;
    }

    public void setRequireNamedPrincipal(boolean requireNamedPrincipal) {
        this.requireNamedPrincipal = requireNamedPrincipal;
    }

    public String getDefaultSubjectClaim() {
        return this.defaultSubClaim;
    }

    public void setDefaultSubjectClaim(String defaultSubClaim) {
        this.defaultSubClaim = defaultSubClaim;
    }

    public String getSubjectPath() {
        return this.subPath;
    }

    public void setSubjectPath(String subPath) {
        this.subPath = subPath;
    }

    public String getDefaultGroupsClaim() {
        return this.defaultGroupsClaim;
    }

    public void setDefaultGroupsClaim(String defaultGroupsClaim) {
        this.defaultGroupsClaim = defaultGroupsClaim;
    }

    public String getGroupsPath() {
        return this.groupsPath;
    }

    public void setGroupsPath(String groupsPath) {
        this.groupsPath = groupsPath;
    }

    @Deprecated
    public List<String> getWhitelistAlgorithms() {
        return this.whitelistAlgorithms;
    }

    @Deprecated
    public void setWhitelistAlgorithms(List<String> whitelistAlgorithms) {
        this.whitelistAlgorithms = whitelistAlgorithms;
    }

    public String getTokenKeyId() {
        return this.tokenKeyId;
    }

    public void setTokenKeyId(String tokenKeyId) {
        this.tokenKeyId = tokenKeyId;
    }

    public String getTokenDecryptionKeyId() {
        return this.tokenDecryptionKeyId;
    }

    public void setTokenDecryptionKeyId(String tokenKeyId) {
        this.tokenDecryptionKeyId = tokenKeyId;
    }

    public List<String> getTokenSchemes() {
        return this.tokenSchemes;
    }

    public void setTokenSchemes(List<String> tokenSchemes) {
        this.tokenSchemes = tokenSchemes;
    }

    public Set<String> getExpectedAudience() {
        return this.expectedAudience;
    }

    public void setExpectedAudience(Set<String> expectedAudience) {
        this.expectedAudience = expectedAudience;
    }

    public String getGroupsSeparator() {
        return this.groupsSeparator;
    }

    public void setGroupsSeparator(String groupsSeparator) {
        this.groupsSeparator = groupsSeparator;
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(SignatureAlgorithm signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
    }

    public KeyFormat getKeyFormat() {
        return this.keyFormat;
    }

    public void setKeyFormat(KeyFormat keyFormat) {
        this.keyFormat = keyFormat;
    }

    public boolean isAlwaysCheckAuthorization() {
        return this.alwaysCheckAuthorization;
    }

    public void setAlwaysCheckAuthorization(boolean alwaysCheckAuthorization) {
        this.alwaysCheckAuthorization = alwaysCheckAuthorization;
    }

    public Set<String> getRequiredClaims() {
        return this.requiredClaims;
    }

    public void setRequiredClaims(Set<String> requiredClaims) {
        this.requiredClaims = requiredClaims;
    }

    public String toString() {
        return "JWTAuthContextInfo{publicVerificationKey=" + this.publicVerificationKey + ", secretVerificationKey=" + this.secretVerificationKey + ", privateDecryptionKey=" + this.privateDecryptionKey + ", secretDecryptionKey=" + this.secretDecryptionKey + ", issuedBy='" + this.issuedBy + '\'' + ", expGracePeriodSecs=" + this.expGracePeriodSecs + ", maxTimeToLiveSecs=" + this.maxTimeToLiveSecs + ", publicKeyLocation='" + this.publicKeyLocation + '\'' + ", publicKeyContent='" + this.publicKeyContent + '\'' + ", decryptionKeyLocation='" + this.decryptionKeyLocation + '\'' + ", decryptionKeyContent='" + this.decryptionKeyContent + '\'' + ", jwksRefreshInterval=" + this.jwksRefreshInterval + ", tokenHeader='" + this.tokenHeader + '\'' + ", tokenCookie='" + this.tokenCookie + '\'' + ", alwaysCheckAuthorization=" + this.alwaysCheckAuthorization + ", tokenKeyId='" + this.tokenKeyId + '\'' + ", tokenDecryptionKeyId='" + this.tokenDecryptionKeyId + '\'' + ", tokenSchemes=" + this.tokenSchemes + ", requireNamedPrincipal=" + this.requireNamedPrincipal + ", defaultSubClaim='" + this.defaultSubClaim + '\'' + ", subPath='" + this.subPath + '\'' + ", defaultGroupsClaim='" + this.defaultGroupsClaim + '\'' + ", groupsPath='" + this.groupsPath + '\'' + ", whitelistAlgorithms=" + this.whitelistAlgorithms + ", signatureAlgorithm=" + (Object)((Object)this.signatureAlgorithm) + ", keyEncryptionAlgorithm=" + (Object)((Object)this.keyEncryptionAlgorithm) + ", keyFormat=" + (Object)((Object)this.keyFormat) + ", expectedAudience=" + this.expectedAudience + ", groupsSeparator='" + this.groupsSeparator + '\'' + ", requireIssuer=" + this.requireIssuer + ", relaxVerificationKeyValidation=" + this.relaxVerificationKeyValidation + ", verifyCertificateThumbprint=" + this.verifyCertificateThumbprint + '}';
    }

    public boolean isRelaxVerificationKeyValidation() {
        return this.relaxVerificationKeyValidation;
    }

    public void setRelaxVerificationKeyValidation(boolean relaxVerificationKeyValidation) {
        this.relaxVerificationKeyValidation = relaxVerificationKeyValidation;
    }

    public boolean isVerifyCertificateThumbprint() {
        return this.verifyCertificateThumbprint;
    }

    public void setVerifyCertificateThumbprint(boolean verifyCertificateThumbprint) {
        this.verifyCertificateThumbprint = verifyCertificateThumbprint;
    }
}

