/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt;

import io.smallrye.jwt.JWTLogging;
import io.smallrye.jwt.JWTMessages;
import io.smallrye.jwt.ResourceUtils;
import io.smallrye.jwt.algorithm.KeyEncryptionAlgorithm;
import io.smallrye.jwt.algorithm.SignatureAlgorithm;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;

public final class KeyUtils {
    private static final String RSA = "RSA";
    private static final String EC = "EC";

    private KeyUtils() {
    }

    public static PrivateKey readPrivateKey(String pemResName) throws IOException, GeneralSecurityException {
        return KeyUtils.readPrivateKey(pemResName, SignatureAlgorithm.RS256);
    }

    public static PrivateKey readPrivateKey(String pemResName, SignatureAlgorithm algo) throws IOException, GeneralSecurityException {
        InputStream contentIS = ResourceUtils.getAsClasspathResource(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        return KeyUtils.decodePrivateKey(new String(tmp, 0, length), algo);
    }

    public static PrivateKey readDecryptionPrivateKey(String pemResName) throws IOException, GeneralSecurityException {
        return KeyUtils.readDecryptionPrivateKey(pemResName, KeyEncryptionAlgorithm.RSA_OAEP);
    }

    public static PrivateKey readDecryptionPrivateKey(String pemResName, KeyEncryptionAlgorithm algo) throws IOException, GeneralSecurityException {
        InputStream contentIS = ResourceUtils.getAsClasspathResource(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        return KeyUtils.decodeDecryptionPrivateKey(new String(tmp, 0, length), algo);
    }

    public static PublicKey readPublicKey(String pemResName) throws IOException, GeneralSecurityException {
        return KeyUtils.readPublicKey(pemResName, SignatureAlgorithm.RS256);
    }

    public static PublicKey readPublicKey(String pemResName, SignatureAlgorithm algo) throws IOException, GeneralSecurityException {
        InputStream contentIS = ResourceUtils.getAsClasspathResource(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        return KeyUtils.decodePublicKey(new String(tmp, 0, length), algo);
    }

    public static PublicKey readEncryptionPublicKey(String pemResName) throws IOException, GeneralSecurityException {
        return KeyUtils.readEncryptionPublicKey(pemResName, KeyEncryptionAlgorithm.RSA_OAEP);
    }

    public static PublicKey readEncryptionPublicKey(String pemResName, KeyEncryptionAlgorithm algo) throws IOException, GeneralSecurityException {
        InputStream contentIS = ResourceUtils.getAsClasspathResource(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        return KeyUtils.decodeEncryptionPublicKey(new String(tmp, 0, length), algo);
    }

    public static KeyPair generateKeyPair(int keySize) throws NoSuchAlgorithmException {
        return KeyUtils.generateKeyPair(keySize, SignatureAlgorithm.RS256);
    }

    public static KeyPair generateKeyPair(int keySize, SignatureAlgorithm algo) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KeyUtils.keyFactoryAlgorithm(algo));
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.genKeyPair();
    }

    public static PrivateKey decodePrivateKey(String pemEncoded) throws GeneralSecurityException {
        return KeyUtils.decodePrivateKey(pemEncoded, SignatureAlgorithm.RS256);
    }

    public static PrivateKey decodePrivateKey(String pemEncoded, SignatureAlgorithm algo) throws GeneralSecurityException {
        return KeyUtils.decodePrivateKeyInternal(pemEncoded, KeyUtils.keyFactoryAlgorithm(algo));
    }

    public static PrivateKey decodeDecryptionPrivateKey(String pemEncoded) throws GeneralSecurityException {
        return KeyUtils.decodePrivateKeyInternal(pemEncoded, RSA);
    }

    public static PrivateKey decodeDecryptionPrivateKey(String pemEncoded, KeyEncryptionAlgorithm algo) throws GeneralSecurityException {
        return KeyUtils.decodePrivateKeyInternal(pemEncoded, KeyUtils.encryptionKeyFactoryAlgorithm(algo));
    }

    public static PrivateKey decodePrivateKeyInternal(String pemEncoded, String algo) throws GeneralSecurityException {
        pemEncoded = KeyUtils.removePemKeyBeginEnd(pemEncoded);
        byte[] pkcs8EncodedBytes = Base64.getDecoder().decode(pemEncoded);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pkcs8EncodedBytes);
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePrivate(keySpec);
    }

    @Deprecated
    public static PublicKey decodeJWKSPublicKey(String jwksValue) throws GeneralSecurityException {
        JsonObject jwks;
        Throwable throwable;
        try (StringReader reader = new StringReader(jwksValue);){
            throwable = null;
            try (JsonReader json = Json.createReader((Reader)reader);){
                jwks = json.readObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            byte[] decoded = Base64.getDecoder().decode(jwksValue);
            try {
                throwable = null;
                try (ByteArrayInputStream stream = new ByteArrayInputStream(decoded);
                     JsonReader json2 = Json.createReader((InputStream)stream);){
                    jwks = json2.readObject();
                }
                catch (Throwable json2) {
                    throwable = json2;
                    throw json2;
                }
            }
            catch (IOException ioe) {
                throw JWTMessages.msg.invalidJWKSPublicKey(ioe);
            }
        }
        JsonArray keys = jwks.getJsonArray("keys");
        JsonObject jwk = keys != null ? keys.getJsonObject(0) : jwks;
        String e = jwk.getString("e");
        String n = jwk.getString("n");
        byte[] ebytes = Base64.getUrlDecoder().decode(e);
        BigInteger publicExponent = new BigInteger(1, ebytes);
        byte[] nbytes = Base64.getUrlDecoder().decode(n);
        BigInteger modulus = new BigInteger(1, nbytes);
        KeyFactory kf = KeyFactory.getInstance(RSA);
        RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(modulus, publicExponent);
        return kf.generatePublic(rsaPublicKeySpec);
    }

    public static PublicKey decodePublicKey(String pemEncoded) throws GeneralSecurityException {
        return KeyUtils.decodePublicKey(pemEncoded, SignatureAlgorithm.RS256);
    }

    public static SecretKey createSecretKeyFromSecret(String secret) {
        byte[] secretBytes = secret.getBytes(StandardCharsets.UTF_8);
        return new SecretKeySpec(secretBytes, "AES");
    }

    public static PublicKey decodePublicKey(String pemEncoded, SignatureAlgorithm algo) throws GeneralSecurityException {
        pemEncoded = KeyUtils.removePemKeyBeginEnd(pemEncoded);
        byte[] encodedBytes = Base64.getDecoder().decode(pemEncoded);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance(KeyUtils.keyFactoryAlgorithm(algo));
        return kf.generatePublic(spec);
    }

    public static PublicKey decodeEncryptionPublicKey(String pemEncoded, KeyEncryptionAlgorithm algo) throws GeneralSecurityException {
        pemEncoded = KeyUtils.removePemKeyBeginEnd(pemEncoded);
        byte[] encodedBytes = Base64.getDecoder().decode(pemEncoded);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance(KeyUtils.encryptionKeyFactoryAlgorithm(algo));
        return kf.generatePublic(spec);
    }

    static String keyFactoryAlgorithm(SignatureAlgorithm algo) throws NoSuchAlgorithmException {
        if (algo.name().startsWith("RS")) {
            return RSA;
        }
        if (algo.name().startsWith("ES")) {
            return EC;
        }
        throw JWTMessages.msg.unsupportedAlgorithm(algo.name());
    }

    static String encryptionKeyFactoryAlgorithm(KeyEncryptionAlgorithm algo) throws NoSuchAlgorithmException {
        if (algo.name().startsWith("RS")) {
            return RSA;
        }
        if (algo.name().startsWith(EC)) {
            return EC;
        }
        throw JWTMessages.msg.unsupportedAlgorithm(algo.name());
    }

    public static PublicKey decodeCertificate(String pemEncoded) throws GeneralSecurityException {
        return KeyUtils.getCertificate(pemEncoded).getPublicKey();
    }

    public static X509Certificate getCertificate(String pemEncoded) throws GeneralSecurityException {
        pemEncoded = KeyUtils.removeCertBeginEnd(pemEncoded);
        byte[] encodedBytes = Base64.getDecoder().decode(pemEncoded);
        return (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(encodedBytes));
    }

    public static String removePemKeyBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN(.*?)KEY-----", "");
        pem = pem.replaceAll("-----END(.*?)KEY-----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        pem = pem.replaceAll("\\\\n", "");
        return pem.trim();
    }

    private static String removeCertBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN(.*?)CERTIFICATE-----", "");
        pem = pem.replaceAll("-----END(.*?)CERTIFICATE-----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        pem = pem.replaceAll("\\\\n", "");
        return pem.trim();
    }

    static String readKeyContent(String keyLocation) throws IOException {
        String content = ResourceUtils.readResource(keyLocation);
        if (content == null) {
            throw JWTMessages.msg.keyNotFound(keyLocation);
        }
        return content;
    }

    static PrivateKey tryAsPEMPrivateKey(String content) {
        JWTLogging.log.creatingKeyFromPemKey();
        try {
            return KeyUtils.decodePrivateKey(content);
        }
        catch (Exception e) {
            JWTLogging.log.creatingKeyFromPemKeyFailed(e);
            return null;
        }
    }

    static PublicKey tryAsPEMPublicKey(String content) {
        JWTLogging.log.creatingKeyFromPemKey();
        try {
            return KeyUtils.decodePublicKey(content);
        }
        catch (Exception e) {
            JWTLogging.log.creatingKeyFromPemKeyFailed(e);
            return null;
        }
    }

    static PublicKey tryAsPEMCertificate(String content) {
        JWTLogging.log.creatingKeyFromPemCertificate();
        try {
            return KeyUtils.decodeCertificate(content);
        }
        catch (Exception e) {
            JWTLogging.log.creatingKeyFromPemCertificateFailed(e);
            return null;
        }
    }

    public static List<JsonWebKey> loadJsonWebKeys(String content) {
        JWTLogging.log.loadingJwks();
        JsonObject jwks = null;
        try (JsonReader reader = Json.createReader((Reader)new StringReader(content));){
            jwks = reader.readObject();
        }
        catch (Exception ex) {
            JWTLogging.log.loadingJwksFailed(ex);
            return null;
        }
        List<JsonWebKey> localKeys = null;
        JsonArray keys = jwks.getJsonArray("keys");
        try {
            if (keys != null) {
                localKeys = new ArrayList<JsonWebKey>(keys.size());
                for (int i = 0; i < keys.size(); ++i) {
                    localKeys.add(KeyUtils.createJsonWebKey(keys.getJsonObject(i)));
                }
            } else {
                localKeys = Collections.singletonList(KeyUtils.createJsonWebKey(jwks));
            }
        }
        catch (Exception ex) {
            JWTLogging.log.parsingJwksFailed();
            return null;
        }
        return localKeys;
    }

    static JsonWebKey createJsonWebKey(JsonObject jsonObject) throws Exception {
        return JsonWebKey.Factory.newJwk((Map)JsonUtil.parseJson((String)jsonObject.toString()));
    }

    public static Key readEncryptionKey(String location, String kid) throws IOException {
        List<JsonWebKey> jwks;
        String content = KeyUtils.readKeyContent(location);
        Key key = KeyUtils.tryAsPEMPublicKey(content);
        if (key == null) {
            key = KeyUtils.tryAsPEMCertificate(content);
        }
        if (key == null && (jwks = KeyUtils.loadJsonWebKeys(content)) != null) {
            key = KeyUtils.getEncryptionKeyFromJwkSet(kid, jwks);
        }
        return key;
    }

    static Key getEncryptionKeyFromJwkSet(String kid, List<JsonWebKey> keys) {
        if (kid != null) {
            for (JsonWebKey currentJwk : keys) {
                if (!kid.equals(currentJwk.getKeyId())) continue;
                return KeyUtils.getPublicOrSecretEncryptingKey(currentJwk);
            }
        }
        if (keys.size() == 1 && (kid == null || keys.get(0).getKeyId() == null)) {
            return KeyUtils.getPublicOrSecretEncryptingKey(keys.get(0));
        }
        return null;
    }

    static Key getPublicOrSecretEncryptingKey(JsonWebKey currentJwk) {
        List keyOps = currentJwk.getKeyOps();
        if (keyOps == null || keyOps.contains("encryption")) {
            if ("oct".equals(currentJwk.getKeyType())) {
                return ((OctetSequenceJsonWebKey)OctetSequenceJsonWebKey.class.cast(currentJwk)).getKey();
            }
            return ((PublicJsonWebKey)PublicJsonWebKey.class.cast(currentJwk)).getPublicKey();
        }
        return null;
    }

    public static Key readSigningKey(String location, String kid) throws IOException {
        List<JsonWebKey> jwks;
        String content = KeyUtils.readKeyContent(location);
        Key key = KeyUtils.tryAsPEMPrivateKey(content);
        if (key == null && (jwks = KeyUtils.loadJsonWebKeys(content)) != null) {
            key = KeyUtils.getSigningKeyFromJwkSet(kid, jwks);
        }
        return key;
    }

    static Key getSigningKeyFromJwkSet(String kid, List<JsonWebKey> keys) {
        if (kid != null) {
            for (JsonWebKey currentJwk : keys) {
                if (!kid.equals(currentJwk.getKeyId())) continue;
                return KeyUtils.getPrivateOrSecretSigningKey(currentJwk);
            }
        }
        if (keys.size() == 1 && (kid == null || keys.get(0).getKeyId() == null)) {
            return KeyUtils.getPrivateOrSecretSigningKey(keys.get(0));
        }
        return null;
    }

    static Key getPrivateOrSecretSigningKey(JsonWebKey currentJwk) {
        List keyOps = currentJwk.getKeyOps();
        if (keyOps == null || keyOps.contains("sign")) {
            if ("oct".equals(currentJwk.getKeyType())) {
                return ((OctetSequenceJsonWebKey)OctetSequenceJsonWebKey.class.cast(currentJwk)).getKey();
            }
            return ((PublicJsonWebKey)PublicJsonWebKey.class.cast(currentJwk)).getPrivateKey();
        }
        return null;
    }
}

