/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.principal;

import io.smallrye.jwt.KeyFormat;
import io.smallrye.jwt.KeyUtils;
import io.smallrye.jwt.auth.principal.AbstractKeyLocationResolver;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.PrincipalMessages;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.RsaJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.VerificationKeyResolver;
import org.jose4j.keys.resolvers.X509VerificationKeyResolver;
import org.jose4j.lang.UnresolvableKeyException;

public class X509KeyLocationResolver
extends AbstractKeyLocationResolver
implements VerificationKeyResolver {
    private X509VerificationKeyResolver resolver;

    public X509KeyLocationResolver(JWTAuthContextInfo authContextInfo) throws UnresolvableKeyException {
        super(authContextInfo);
        try {
            this.initializeInternalResolver();
            if (this.resolver == null) {
                throw PrincipalMessages.msg.failedToLoadCertificates();
            }
        }
        catch (Exception e) {
            X509KeyLocationResolver.reportLoadKeyException(authContextInfo.getPublicKeyContent(), authContextInfo.getPublicKeyLocation(), e);
        }
    }

    public Key resolveKey(JsonWebSignature jws, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        return this.resolver.resolveKey(jws, nestingContext);
    }

    protected void initializeInternalResolver() throws Exception {
        String content;
        if (this.isHttpsJwksInitialized(this.authContextInfo.getPublicKeyLocation())) {
            this.initializeInternalResolverFromJwks(this.httpsJwks.getJsonWebKeys());
            return;
        }
        String string = content = this.authContextInfo.getPublicKeyContent() != null ? this.authContextInfo.getPublicKeyContent() : this.readKeyContent(this.authContextInfo.getPublicKeyLocation());
        if (this.mayBeFormat(KeyFormat.JWK) || this.mayBeFormat(KeyFormat.JWK_BASE64URL)) {
            this.loadFromJwk(content, null, null);
            if (this.jsonWebKeys != null) {
                this.initializeInternalResolverFromJwks(this.jsonWebKeys);
                return;
            }
        }
        this.initializeInternalResolverFromPEMCertificate(content);
    }

    private void initializeInternalResolverFromJwks(List<JsonWebKey> jsonWebKeys) throws Exception {
        LinkedList certs = new LinkedList();
        for (JsonWebKey jwk : jsonWebKeys) {
            List encodedChain;
            if (jwk.getAlgorithm() != null && (!this.authContextInfo.getSignatureAlgorithm().getAlgorithm().equals(jwk.getAlgorithm()) || !(jwk instanceof RsaJsonWebKey))) continue;
            List<X509Certificate> x5c = ((RsaJsonWebKey)jwk).getCertificateChain();
            if (x5c == null && (encodedChain = (List)jwk.getOtherParameterValue("x5c", List.class)) != null && !encodedChain.isEmpty()) {
                x5c = Collections.singletonList(KeyUtils.getCertificate((String)encodedChain.get(0)));
            }
            if (x5c == null || x5c.size() <= 0) continue;
            certs.add(x5c.get(0));
        }
        this.resolver = new X509VerificationKeyResolver(certs);
    }

    void initializeInternalResolverFromPEMCertificate(String content) {
        X509Certificate cert = super.loadPEMCertificate(content);
        if (cert != null) {
            this.resolver = new X509VerificationKeyResolver(new X509Certificate[]{cert});
        }
    }
}

