package io.smallrye.jwt;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Object;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.ERROR;

/**
 * Warning this class consists of generated code.
 */
public class JWTLogging_$logger extends DelegatingBasicLogger implements JWTLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JWTLogging_$logger.class.getName();
    public JWTLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void maximumPathDepthReached(final String claimName, final Object pathDepth, final Object maxPathDepthSupported) {
        super.log.logf(FQCN, ERROR, null, maximumPathDepthReached$str(), claimName, pathDepth, maxPathDepthSupported);
    }
    protected String maximumPathDepthReached$str() {
        return "SRJWT01000: path.%s configuration will be ignored because the path depth is too large: %d, maximum depth is %d.";
    }
    @Override
    public final void tokenHeaderIsNotCookieHeader() {
        super.log.logf(FQCN, ERROR, null, tokenHeaderIsNotCookieHeader$str());
    }
    protected String tokenHeaderIsNotCookieHeader$str() {
        return "SRJWT01001: Token header is not 'Cookie', the cookie name value will be ignored";
    }
    @Override
    public final void unsupportedAlgorithm(final String unsupportedAlgorithm) {
        super.log.logf(FQCN, ERROR, null, unsupportedAlgorithm$str(), unsupportedAlgorithm);
    }
    protected String unsupportedAlgorithm$str() {
        return "SRJWT01002: Algorithm %s not supported";
    }
}
