/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.plugin;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JDocComment;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JFiler;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JSourceFile;
import org.jboss.jdeparser.JSources;

@Mojo(name="generate-info", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class SmallRyeInfoMojo
extends AbstractMojo {
    @Parameter(required=true)
    private String specVersion;
    @Parameter(required=true, defaultValue="${project.version}")
    private String implementationVersion;
    @Parameter(required=true)
    private String packageName;
    @Parameter(required=true, defaultValue="SmallRyeInfo")
    private String className;
    @Parameter(required=true, defaultValue="${project.build.directory}/generated-sources/smallrye-info")
    private String sourceOutput;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    private static final Pattern versionPattern = Pattern.compile("([0-9]+)(?:\\.([0-9]+)(?:\\.([0-9]+))?)?(-SNAPSHOT)?");

    public void execute() throws MojoExecutionException {
        Matcher specMatcher = versionPattern.matcher(this.specVersion);
        if (!specMatcher.matches()) {
            throw new MojoExecutionException("The specification version \"" + this.specVersion + "\" does not match the pattern: " + versionPattern);
        }
        int specMajor = Integer.parseInt(specMatcher.group(1));
        int specMinor = Integer.parseInt(Optional.ofNullable(specMatcher.group(2)).orElse("0"));
        int specMicro = Integer.parseInt(Optional.ofNullable(specMatcher.group(3)).orElse("0"));
        boolean specSnapshot = specMatcher.group(4) != null;
        Matcher implMatcher = versionPattern.matcher(this.implementationVersion);
        if (!implMatcher.matches()) {
            throw new MojoExecutionException("The implementation version \"" + this.implementationVersion + "\" does not match the pattern: " + versionPattern);
        }
        int implMajor = Integer.parseInt(implMatcher.group(1));
        int implMinor = Integer.parseInt(Optional.ofNullable(implMatcher.group(2)).orElse("0"));
        int implMicro = Integer.parseInt(Optional.ofNullable(implMatcher.group(3)).orElse("0"));
        boolean implSnapshot = implMatcher.group(4) != null;
        File sourceOutputFile = new File(this.sourceOutput);
        sourceOutputFile.mkdirs();
        this.project.addCompileSourceRoot(this.sourceOutput);
        JSources sources = JDeparser.createSources((JFiler)JFiler.newInstance((File)sourceOutputFile), (FormatPreferences)new FormatPreferences());
        JSourceFile sourceFile = sources.createSourceFile(this.packageName, this.className);
        JClassDef classDef = sourceFile._class(34, this.className);
        JDocComment classDoc = classDef.docComment();
        classDoc.text("Information about the version of this module.");
        classDef.constructor(8);
        JMethodDef method = classDef.method(96, Integer.TYPE, "getSpecMajorVersion");
        method.docComment().text("Get the specification major version.")._return().text("the specification major version");
        method.body()._return(JExprs.decimal((int)specMajor));
        method = classDef.method(96, Integer.TYPE, "getSpecMinorVersion");
        method.docComment().text("Get the specification minor version.")._return().text("the specification minor version");
        method.body()._return(JExprs.decimal((int)specMinor));
        method = classDef.method(96, Integer.TYPE, "getSpecMicroVersion");
        method.docComment().text("Get the specification micro version.")._return().text("the specification micro version");
        method.body()._return(JExprs.decimal((int)specMicro));
        method = classDef.method(96, Boolean.TYPE, "isSpecSnapshot");
        method.docComment().text("Determine whether the specification is a snapshot.")._return().inlineDocTag("code", "true").text(" if the specification is a snapshot, or ").inlineDocTag("code", "false").text(" otherwise");
        method.body()._return(specSnapshot ? JExpr.TRUE : JExpr.FALSE);
        method = classDef.method(96, Integer.TYPE, "getImplMajorVersion");
        method.docComment().text("Get the implementation major version.")._return().text("the implementation major version");
        method.body()._return(JExprs.decimal((int)implMajor));
        method = classDef.method(96, Integer.TYPE, "getImplMinorVersion");
        method.docComment().text("Get the implementation minor version.")._return().text("the implementation minor version");
        method.body()._return(JExprs.decimal((int)implMinor));
        method = classDef.method(96, Integer.TYPE, "getImplMicroVersion");
        method.docComment().text("Get the implementation micro version.")._return().text("the implementation micro version");
        method.body()._return(JExprs.decimal((int)implMicro));
        method = classDef.method(96, Boolean.TYPE, "isImplSnapshot");
        method.docComment().text("Determine whether the implementation is a snapshot.")._return().inlineDocTag("code", "true").text(" if the implementation is a snapshot, or ").inlineDocTag("code", "false").text(" otherwise");
        method.body()._return(implSnapshot ? JExpr.TRUE : JExpr.FALSE);
        method = classDef.method(96, Integer.TYPE, "getInfoVersion");
        method.docComment().text("Get the SmallRye information class API version.  Use this property to determine what methods are available on this class.")._return().text("the version");
        method.body()._return(JExprs.decimal((int)1));
        try {
            sources.writeSources();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write generated sources", (Exception)e);
        }
    }
}

