/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.exporters;

import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.exporters.Exporter;
import io.smallrye.metrics.exporters.ExporterUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metered;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.jboss.logging.Logger;

public class JsonExporter
implements Exporter {
    private static final Logger log = Logger.getLogger((String)"io.smallrye.metrics");
    private static final String COMMA_LF = ",\n";
    private static final String LF = "\n";

    @Override
    public StringBuffer exportOneScope(MetricRegistry.Type scope) {
        StringBuffer sb = new StringBuffer();
        this.getMetricsForAScope(sb, scope);
        return sb;
    }

    @Override
    public StringBuffer exportAllScopes() {
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        boolean first = true;
        for (MetricRegistry.Type scope : MetricRegistry.Type.values()) {
            MetricRegistry registry = MetricRegistries.get(scope);
            if (registry.getNames().size() <= 0) continue;
            if (!first) {
                sb.append(",");
            }
            sb.append('\"').append(scope.getName().toLowerCase()).append('\"').append(" :\n");
            this.getMetricsForAScope(sb, scope);
            sb.append(LF);
            first = false;
        }
        sb.append("}");
        return sb;
    }

    @Override
    public StringBuffer exportOneMetric(MetricRegistry.Type scope, MetricID metricID) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map metricMap = registry.getMetrics();
        Map metadataMap = registry.getMetadata();
        Metric m = (Metric)metricMap.get(metricID);
        HashMap<MetricID, Metric> outMap = new HashMap<MetricID, Metric>(1);
        outMap.put(metricID, m);
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        this.writeMetricsForMap(sb, outMap, metadataMap);
        sb.append("}");
        sb.append(LF);
        return sb;
    }

    @Override
    public StringBuffer exportMetricsByName(MetricRegistry.Type scope, String name) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map<MetricID, Metric> metricMap = registry.getMetrics().entrySet().stream().filter(e -> ((MetricID)e.getKey()).getName().equals(name)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map metadataMap = registry.getMetadata();
        StringBuffer sb = new StringBuffer();
        sb.append("{");
        sb.append(LF);
        this.writeMetricsForMap(sb, metricMap, metadataMap);
        sb.append(LF);
        sb.append("}");
        sb.append(LF);
        return sb;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    private StringBuffer writeMetricsByName(Map<MetricID, Metric> metricMap, Metadata metadata) {
        StringBuffer sb = new StringBuffer();
        switch (metadata.getTypeRaw()) {
            case GAUGE: 
            case COUNTER: {
                String metricsString = metricMap.entrySet().stream().map(metric -> this.writeOneSimpleMetric((MetricID)metric.getKey(), (Metric)metric.getValue(), metadata)).collect(Collectors.joining(COMMA_LF));
                sb.append(metricsString);
                break;
            }
            case METERED: {
                sb.append(this.writeMeters(metricMap, metadata));
                break;
            }
            case CONCURRENT_GAUGE: {
                sb.append(this.writeConcurrentGauges(metricMap, metadata));
                break;
            }
            case TIMER: {
                sb.append(this.writeTimers(metricMap, metadata));
                break;
            }
            case HISTOGRAM: {
                sb.append(this.writeHistograms(metricMap, metadata));
                break;
            }
            default: {
                throw new IllegalArgumentException("Not supported: " + metadata.getTypeRaw());
            }
        }
        return sb;
    }

    private void getMetricsForAScope(StringBuffer sb, MetricRegistry.Type scope) {
        MetricRegistry registry = MetricRegistries.get(scope);
        Map metricMap = registry.getMetrics();
        Map metadataMap = registry.getMetadata();
        sb.append("{\n");
        this.writeMetricsForMap(sb, metricMap, metadataMap);
        sb.append(LF).append("}");
    }

    private void writeMetricsForMap(StringBuffer outSb, Map<MetricID, Metric> metricMap, Map<String, Metadata> metadataMap) {
        Map<String, Map<MetricID, Metric>> metricsGroupedByName = metricMap.entrySet().stream().collect(Collectors.groupingBy(entry -> ((MetricID)entry.getKey()).getName(), Collectors.mapping(e -> e, Collectors.toMap(e -> (MetricID)e.getKey(), e -> (Metric)e.getValue()))));
        String result = metricsGroupedByName.entrySet().stream().map(entry -> this.writeMetricsByName((Map)entry.getValue(), (Metadata)metadataMap.get(entry.getKey()))).collect(Collectors.joining(COMMA_LF));
        outSb.append(result);
    }

    private void writeEndLine(StringBuffer sb) {
        sb.append("  }");
    }

    private void writeStartLine(StringBuffer sb, String key) {
        sb.append("  ").append('\"').append(key).append('\"').append(" : ").append("{\n");
    }

    private StringBuffer writeOneSimpleMetric(MetricID metricID, Metric metric, Metadata metadata) {
        StringBuffer result = new StringBuffer();
        Number val = this.getValueFromMetric(metric, metricID.getName());
        String tags = this.createTagsString(metricID.getTagsAsList());
        result.append("  ").append('\"').append(metricID.getName()).append(tags).append('\"').append(" : ").append(val);
        return result;
    }

    private StringBuffer writeMeters(Map<MetricID, Metric> metricMap, Metadata metadata) {
        StringBuffer sb = new StringBuffer();
        if (metricMap.size() > 0) {
            this.writeStartLine(sb, metadata.getName());
            String values = metricMap.entrySet().stream().map(e -> this.writeMeterValues((Metered)e.getValue(), this.createTagsString(((MetricID)e.getKey()).getTagsAsList()))).collect(Collectors.joining(COMMA_LF));
            sb.append(values).append(LF);
            this.writeEndLine(sb);
        }
        return sb;
    }

    private StringBuffer writeHistograms(Map<MetricID, Metric> metricMap, Metadata metadata) {
        StringBuffer sb = new StringBuffer();
        if (metricMap.size() > 0) {
            this.writeStartLine(sb, metadata.getName());
            String values = metricMap.entrySet().stream().map(e -> {
                String tags = this.createTagsString(((MetricID)e.getKey()).getTagsAsList());
                long count = ((Histogram)e.getValue()).getCount();
                return new StringBuffer().append("    \"count").append(tags).append("\": ").append(count).append(COMMA_LF).append(this.writeSnapshotValues(((Histogram)e.getValue()).getSnapshot(), tags));
            }).collect(Collectors.joining(COMMA_LF));
            sb.append(values).append(LF);
            this.writeEndLine(sb);
        }
        return sb;
    }

    private StringBuffer writeConcurrentGauges(Map<MetricID, Metric> metricMap, Metadata metadata) {
        StringBuffer sb = new StringBuffer();
        if (metricMap.size() > 0) {
            this.writeStartLine(sb, metadata.getName());
            String values = metricMap.entrySet().stream().map(e -> this.writeConcurrentGaugeValues((ConcurrentGauge)e.getValue(), this.createTagsString(((MetricID)e.getKey()).getTagsAsList()))).collect(Collectors.joining(COMMA_LF));
            sb.append(values).append(LF);
            this.writeEndLine(sb);
        }
        return sb;
    }

    private StringBuffer writeTimers(Map<MetricID, Metric> metricMap, Metadata metadata) {
        StringBuffer sb = new StringBuffer();
        if (metricMap.size() > 0) {
            this.writeStartLine(sb, metadata.getName());
            String values = metricMap.entrySet().stream().map(e -> this.writeTimerValues((Timer)e.getValue(), (String)metadata.getUnit().get(), this.createTagsString(((MetricID)e.getKey()).getTagsAsList()))).collect(Collectors.joining(COMMA_LF));
            sb.append(values).append(LF);
            this.writeEndLine(sb);
        }
        return sb;
    }

    private StringBuffer writeMeterValues(Metered meter, String tags) {
        StringBuffer sb = new StringBuffer();
        sb.append("    \"count").append(tags).append("\": ").append(meter.getCount()).append(COMMA_LF);
        sb.append("    \"meanRate").append(tags).append("\": ").append(meter.getMeanRate()).append(COMMA_LF);
        sb.append("    \"oneMinRate").append(tags).append("\": ").append(meter.getOneMinuteRate()).append(COMMA_LF);
        sb.append("    \"fiveMinRate").append(tags).append("\": ").append(meter.getFiveMinuteRate()).append(COMMA_LF);
        sb.append("    \"fifteenMinRate").append(tags).append("\": ").append(meter.getFifteenMinuteRate());
        return sb;
    }

    private StringBuffer writeConcurrentGaugeValues(ConcurrentGauge concurrentGauge, String tags) {
        StringBuffer sb = new StringBuffer();
        sb.append("    \"current").append(tags).append("\": ").append(concurrentGauge.getCount()).append(COMMA_LF);
        sb.append("    \"max").append(tags).append("\": ").append(concurrentGauge.getMax()).append(COMMA_LF);
        sb.append("    \"min").append(tags).append("\": ").append(concurrentGauge.getMin());
        return sb;
    }

    private StringBuffer writeTimerValues(Timer timer, String unit, String tags) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.writeSnapshotValues(timer.getSnapshot(), unit, tags));
        sb.append(COMMA_LF);
        sb.append(this.writeMeterValues((Metered)timer, tags));
        return sb;
    }

    private StringBuffer writeSnapshotValues(Snapshot snapshot, String tags) {
        StringBuffer sb = new StringBuffer();
        sb.append("    \"p50").append(tags).append("\": ").append(snapshot.getMedian()).append(COMMA_LF);
        sb.append("    \"p75").append(tags).append("\": ").append(snapshot.get75thPercentile()).append(COMMA_LF);
        sb.append("    \"p95").append(tags).append("\": ").append(snapshot.get95thPercentile()).append(COMMA_LF);
        sb.append("    \"p98").append(tags).append("\": ").append(snapshot.get98thPercentile()).append(COMMA_LF);
        sb.append("    \"p99").append(tags).append("\": ").append(snapshot.get99thPercentile()).append(COMMA_LF);
        sb.append("    \"p999").append(tags).append("\": ").append(snapshot.get999thPercentile()).append(COMMA_LF);
        sb.append("    \"min").append(tags).append("\": ").append(snapshot.getMin()).append(COMMA_LF);
        sb.append("    \"mean").append(tags).append("\": ").append(snapshot.getMean()).append(COMMA_LF);
        sb.append("    \"max").append(tags).append("\": ").append(snapshot.getMax()).append(COMMA_LF);
        sb.append("    \"stddev").append(tags).append("\": ").append(snapshot.getStdDev());
        return sb;
    }

    private StringBuffer writeSnapshotValues(Snapshot snapshot, String unit, String tags) {
        StringBuffer sb = new StringBuffer();
        sb.append("    \"p50").append(tags).append("\": ").append(this.toBase(snapshot.getMedian(), unit)).append(COMMA_LF);
        sb.append("    \"p75").append(tags).append("\": ").append(this.toBase(snapshot.get75thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p95").append(tags).append("\": ").append(this.toBase(snapshot.get95thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p98").append(tags).append("\": ").append(this.toBase(snapshot.get98thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p99").append(tags).append("\": ").append(this.toBase(snapshot.get99thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"p999").append(tags).append("\": ").append(this.toBase(snapshot.get999thPercentile(), unit)).append(COMMA_LF);
        sb.append("    \"min").append(tags).append("\": ").append(this.toBase(snapshot.getMin(), unit)).append(COMMA_LF);
        sb.append("    \"mean").append(tags).append("\": ").append(this.toBase(snapshot.getMean(), unit)).append(COMMA_LF);
        sb.append("    \"max").append(tags).append("\": ").append(this.toBase(snapshot.getMax(), unit)).append(COMMA_LF);
        sb.append("    \"stddev").append(tags).append("\": ").append(this.toBase(snapshot.getStdDev(), unit));
        return sb;
    }

    private Number toBase(Number count, String unit) {
        return ExporterUtil.convertNanosTo(count.doubleValue(), unit);
    }

    private Number getValueFromMetric(Metric theMetric, String name) {
        if (theMetric instanceof Gauge) {
            Number value = (Number)((Gauge)theMetric).getValue();
            if (value != null) {
                return value;
            }
            log.warn((Object)("Value is null for " + name));
            return -142.142;
        }
        if (theMetric instanceof Counter) {
            return ((Counter)theMetric).getCount();
        }
        log.error((Object)("Not yet supported metric: " + theMetric.getClass().getName()));
        return -42.42;
    }

    private String createTagsString(List<Tag> tagsAsList) {
        if (tagsAsList == null || tagsAsList.isEmpty()) {
            return "";
        }
        return ";" + tagsAsList.stream().map(tag -> tag.getTagName() + "=" + tag.getTagValue().replaceAll(";", "_").replaceAll("\"", "\\\\\"").replaceAll(LF, "\\\\n")).collect(Collectors.joining(";"));
    }
}

