/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.OriginAndMetadata;
import io.smallrye.metrics.TagsUtils;
import io.smallrye.metrics.interceptors.MetricName;
import java.util.SortedMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.RegistryType;

@ApplicationScoped
public class MetricProducer {
    @Inject
    @RegistryType(type=MetricRegistry.Type.APPLICATION)
    MetricRegistry applicationRegistry;
    @Inject
    private MetricName metricName;

    @Produces
    <T extends Number> Gauge<T> getGauge(InjectionPoint ip) {
        return () -> {
            SortedMap gauges = this.applicationRegistry.getGauges();
            String name = this.metricName.of(ip);
            MetricID gaugeId = new MetricID(name);
            return ((Gauge)gauges.get(gaugeId)).getValue();
        };
    }

    @Produces
    Counter getCounter(InjectionPoint ip) {
        Metadata metadata = this.getMetadata(ip, MetricType.COUNTER);
        Tag[] tags = this.getTags(ip);
        return this.applicationRegistry.counter(metadata, tags);
    }

    @Produces
    ConcurrentGauge getConcurrentGauge(InjectionPoint ip) {
        Metadata metadata = this.getMetadata(ip, MetricType.CONCURRENT_GAUGE);
        Tag[] tags = this.getTags(ip);
        return this.applicationRegistry.concurrentGauge(metadata, tags);
    }

    @Produces
    Histogram getHistogram(InjectionPoint ip) {
        Metadata metadata = this.getMetadata(ip, MetricType.HISTOGRAM);
        Tag[] tags = this.getTags(ip);
        return this.applicationRegistry.histogram(metadata, tags);
    }

    @Produces
    Meter getMeter(InjectionPoint ip) {
        Metadata metadata = this.getMetadata(ip, MetricType.METERED);
        Tag[] tags = this.getTags(ip);
        return this.applicationRegistry.meter(metadata, tags);
    }

    @Produces
    Timer getTimer(InjectionPoint ip) {
        Metadata metadata = this.getMetadata(ip, MetricType.TIMER);
        Tag[] tags = this.getTags(ip);
        return this.applicationRegistry.timer(metadata, tags);
    }

    private Metadata getMetadata(InjectionPoint ip, MetricType type) {
        OriginAndMetadata metadata;
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        if (metric != null) {
            Metadata actualMetadata = Metadata.builder().withName(this.metricName.of(ip)).withType(type).withUnit(metric.unit()).withDescription(metric.description()).withDisplayName(metric.displayName()).notReusable().build();
            metadata = new OriginAndMetadata(ip, actualMetadata);
        } else {
            Metadata actualMetadata = Metadata.builder().withName(this.metricName.of(ip)).withType(type).withUnit("none").withDescription("").withDisplayName("").notReusable().build();
            metadata = new OriginAndMetadata(ip, actualMetadata);
        }
        return metadata;
    }

    private Tag[] getTags(InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        if (metric != null && metric.tags().length > 0) {
            return TagsUtils.parseTagsAsArray(metric.tags());
        }
        return new Tag[0];
    }
}

