/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api;

import io.smallrye.openapi.api.OpenApiConfig;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.microprofile.config.Config;

public class OpenApiConfigImpl
implements OpenApiConfig {
    private Config config;
    private String modelReader;
    private String filter;
    private Boolean scanDisable;
    private Set<String> scanPackages;
    private Set<String> scanClasses;
    private Set<String> scanExcludePackages;
    private Set<String> scanExcludeClasses;
    private Set<String> servers;
    private Boolean scanDependenciesDisable;
    private Set<String> scanDependenciesJars;
    private Boolean schemaReferencesEnable;
    private String customSchemaRegistryClass;

    public OpenApiConfigImpl(Config config) {
        this.config = config;
    }

    protected Config getConfig() {
        return this.config;
    }

    @Override
    public String modelReader() {
        if (this.modelReader == null) {
            this.modelReader = this.getConfig().getOptionalValue("mp.openapi.model.reader", String.class).orElse(null);
        }
        return this.modelReader;
    }

    @Override
    public String filter() {
        if (this.filter == null) {
            this.filter = this.getConfig().getOptionalValue("mp.openapi.filter", String.class).orElse(null);
        }
        return this.filter;
    }

    @Override
    public boolean scanDisable() {
        if (this.scanDisable == null) {
            this.scanDisable = this.getConfig().getOptionalValue("mp.openapi.scan.disable", Boolean.class).orElse(false);
        }
        return this.scanDisable;
    }

    @Override
    public Set<String> scanPackages() {
        if (this.scanPackages == null) {
            String packages = this.getConfig().getOptionalValue("mp.openapi.scan.packages", String.class).orElse(null);
            this.scanPackages = OpenApiConfigImpl.asCsvSet(packages);
        }
        return this.scanPackages;
    }

    @Override
    public Set<String> scanClasses() {
        if (this.scanClasses == null) {
            String classes = this.getConfig().getOptionalValue("mp.openapi.scan.classes", String.class).orElse(null);
            this.scanClasses = OpenApiConfigImpl.asCsvSet(classes);
        }
        return this.scanClasses;
    }

    @Override
    public Set<String> scanExcludePackages() {
        if (this.scanExcludePackages == null) {
            String packages = this.getConfig().getOptionalValue("mp.openapi.scan.exclude.packages", String.class).orElse(null);
            this.scanExcludePackages = OpenApiConfigImpl.asCsvSet(packages);
        }
        return this.scanExcludePackages;
    }

    @Override
    public Set<String> scanExcludeClasses() {
        if (this.scanExcludeClasses == null) {
            String classes = this.getConfig().getOptionalValue("mp.openapi.scan.exclude.classes", String.class).orElse(null);
            this.scanExcludeClasses = OpenApiConfigImpl.asCsvSet(classes);
        }
        return this.scanExcludeClasses;
    }

    @Override
    public Set<String> servers() {
        if (this.servers == null) {
            String theServers = this.getConfig().getOptionalValue("mp.openapi.servers", String.class).orElse(null);
            this.servers = OpenApiConfigImpl.asCsvSet(theServers);
        }
        return this.servers;
    }

    @Override
    public Set<String> pathServers(String path) {
        String servers = this.getConfig().getOptionalValue("mp.openapi.servers.path." + path, String.class).orElse(null);
        return OpenApiConfigImpl.asCsvSet(servers);
    }

    @Override
    public Set<String> operationServers(String operationId) {
        String servers = this.getConfig().getOptionalValue("mp.openapi.servers.operation." + operationId, String.class).orElse(null);
        return OpenApiConfigImpl.asCsvSet(servers);
    }

    @Override
    public boolean scanDependenciesDisable() {
        if (this.scanDependenciesDisable == null) {
            this.scanDependenciesDisable = this.getConfig().getOptionalValue("mp.openapi.extensions.scan-dependencies.disable", Boolean.class).orElse(false);
        }
        return this.scanDependenciesDisable;
    }

    @Override
    public Set<String> scanDependenciesJars() {
        if (this.scanDependenciesJars == null) {
            String classes = this.getConfig().getOptionalValue("mp.openapi.extensions.scan-dependencies.jars", String.class).orElse(null);
            this.scanDependenciesJars = OpenApiConfigImpl.asCsvSet(classes);
        }
        return this.scanDependenciesJars;
    }

    @Override
    public boolean schemaReferencesEnable() {
        if (this.schemaReferencesEnable == null) {
            this.schemaReferencesEnable = this.getConfig().getOptionalValue("mp.openapi.extensions.schema-references.enable", Boolean.class).orElse(false);
        }
        return this.schemaReferencesEnable;
    }

    @Override
    public String customSchemaRegistryClass() {
        if (this.customSchemaRegistryClass == null) {
            this.customSchemaRegistryClass = this.getConfig().getOptionalValue("mp.openapi.extensions.custom-schema-registry.class", String.class).orElse(null);
        }
        return this.customSchemaRegistryClass;
    }

    private static Set<String> asCsvSet(String items) {
        HashSet<String> rval = new HashSet<String>();
        if (items != null) {
            String[] split;
            for (String item : split = items.split(",")) {
                rval.add(item.trim());
            }
        }
        return rval;
    }
}

