/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeProcessor;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.SchemaFactory;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.util.HashMap;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class AnnotationTargetProcessor {
    private static final Logger LOG = Logger.getLogger(AnnotationTargetProcessor.class);
    private final AugmentedIndexView index;
    private final DataObjectDeque objectStack;
    private final DataObjectDeque.PathEntry parentPathEntry;
    private final TypeResolver typeResolver;
    private final String entityName;
    private final Type entityType;
    private Schema fieldSchema;
    private AnnotationTarget annotationTarget;

    public AnnotationTargetProcessor(AugmentedIndexView index, DataObjectDeque objectStack, DataObjectDeque.PathEntry parentPathEntry, TypeResolver typeResolver, AnnotationTarget annotationTarget, String entityName, Type entityType) {
        this.index = index;
        this.objectStack = objectStack;
        this.parentPathEntry = parentPathEntry;
        this.typeResolver = typeResolver;
        this.entityName = entityName;
        this.entityType = entityType;
        this.annotationTarget = annotationTarget;
        this.fieldSchema = new SchemaImpl();
    }

    public AnnotationTargetProcessor(AugmentedIndexView index, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry, FieldInfo fieldInfo) {
        this(index, objectStack, parentPathEntry, typeResolver, (AnnotationTarget)fieldInfo, fieldInfo.name(), fieldInfo.type());
    }

    public AnnotationTargetProcessor(AugmentedIndexView index, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry, Type type) {
        this(index, objectStack, parentPathEntry, typeResolver, (AnnotationTarget)index.getClass(type), type.name().toString(), type);
    }

    public static Schema process(AugmentedIndexView index, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry, FieldInfo field) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(index, objectStack, typeResolver, parentPathEntry, field);
        return fp.processField();
    }

    public static Schema process(AugmentedIndexView index, DataObjectDeque objectStack, TypeResolver typeResolver, DataObjectDeque.PathEntry parentPathEntry, Type type) {
        AnnotationTargetProcessor fp = new AnnotationTargetProcessor(index, objectStack, typeResolver, parentPathEntry, type);
        return fp.processField();
    }

    Schema processField() {
        AnnotationInstance schemaAnnotation = TypeUtil.getSchemaAnnotation(this.annotationTarget);
        String propertyKey = this.readPropertyKey(schemaAnnotation);
        if (schemaAnnotation == null && this.shouldInferUnannotatedFields()) {
            this.readUnannotatedField();
        } else {
            this.readSchemaAnnotatedField(propertyKey, schemaAnnotation);
        }
        BeanValidationScanner.applyConstraints(this.annotationTarget, this.fieldSchema, this.parentPathEntry.getSchema(), propertyKey);
        this.fieldSchema = SchemaRegistry.checkRegistration(this.entityType, this.typeResolver, this.fieldSchema);
        this.parentPathEntry.getSchema().addProperty(propertyKey, this.fieldSchema);
        return this.fieldSchema;
    }

    private String readPropertyKey(AnnotationInstance schemaAnnotation) {
        String key = null;
        if (schemaAnnotation != null) {
            key = JandexUtil.stringValue(schemaAnnotation, "name");
        }
        if (key == null) {
            AnnotationInstance jsonbAnnotation = TypeUtil.getAnnotation(this.annotationTarget, OpenApiConstants.DOTNAME_JSONB_PROPERTY);
            if (jsonbAnnotation != null) {
                key = JandexUtil.stringValue(jsonbAnnotation, "value");
                if (key == null) {
                    key = this.entityName;
                }
            } else {
                key = this.entityName;
            }
        }
        return key;
    }

    private void readSchemaAnnotatedField(String propertyKey, @NotNull AnnotationInstance annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException("Annotation must not be null");
        }
        LOG.debugv("Processing @Schema annotation {0} on a field {1}", (Object)annotation, (Object)propertyKey);
        if (JandexUtil.booleanValueWithDefault(annotation, "required").booleanValue()) {
            this.parentPathEntry.getSchema().addRequired(propertyKey);
        }
        TypeProcessor typeProcessor = new TypeProcessor(this.index, this.objectStack, this.parentPathEntry, this.typeResolver, this.entityType, this.fieldSchema, this.annotationTarget);
        Type postProcessedField = typeProcessor.processType();
        this.fieldSchema = typeProcessor.getSchema();
        TypeUtil.TypeWithFormat typeFormat = TypeUtil.getTypeFormat(postProcessedField);
        HashMap<String, Object> overrides = new HashMap<String, Object>();
        overrides.put("type", typeFormat.getSchemaType());
        overrides.put("format", typeFormat.getFormat().format());
        this.fieldSchema = SchemaFactory.readSchema(this.index, this.fieldSchema, annotation, overrides);
    }

    private void readUnannotatedField() {
        LOG.debugv("Processing unannotated field {0}", (Object)this.entityType);
        TypeProcessor typeProcessor = new TypeProcessor(this.index, this.objectStack, this.parentPathEntry, this.typeResolver, this.entityType, this.fieldSchema, this.annotationTarget);
        Type postProcessedField = typeProcessor.processType();
        this.fieldSchema = typeProcessor.getSchema();
        TypeUtil.TypeWithFormat typeFormat = TypeUtil.getTypeFormat(postProcessedField);
        this.fieldSchema.setType(typeFormat.getSchemaType());
        if (typeFormat.getFormat().hasFormat()) {
            this.fieldSchema.setFormat(typeFormat.getFormat().format());
        }
    }

    private boolean shouldInferUnannotatedFields() {
        String infer = System.getProperties().getProperty("openapi.infer-unannotated-types", "true");
        return Boolean.parseBoolean(infer);
    }
}

