/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.openapi.models.media.Content;
import org.eclipse.microprofile.openapi.models.media.MediaType;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;

public class ResourceParameters {
    private static final Comparator<Parameter> PARAMETER_COMPARATOR = Comparator.comparing(Parameter::getIn).thenComparing(Parameter::getName);
    static final Pattern TEMPLATE_PARAM_PATTERN = Pattern.compile("\\{(\\w[\\w\\.-]*)\\}");
    private String pathItemPath;
    private List<Parameter> pathItemParameters;
    private String operationPath;
    private List<Parameter> operationParameters;
    private Content formBodyContent;

    public List<Parameter> getPathItemParameters() {
        return this.pathItemParameters;
    }

    public String getOperationPath() {
        return this.operationPath;
    }

    public String getFullOperationPath() {
        return this.pathItemPath + this.operationPath;
    }

    public List<Parameter> getOperationParameters() {
        return this.operationParameters;
    }

    public void addOperationParameter(Parameter parameter) {
        if (this.operationParameters == null) {
            this.operationParameters = new ArrayList<Parameter>();
        }
        this.operationParameters.add(parameter);
    }

    public Content getFormBodyContent() {
        return this.formBodyContent;
    }

    public Schema getFormBodySchema() {
        if (this.formBodyContent != null) {
            return ((MediaType)this.formBodyContent.getMediaTypes().values().iterator().next()).getSchema();
        }
        return null;
    }

    public List<Parameter> getAllParameters() {
        ArrayList<Parameter> all = new ArrayList<Parameter>();
        if (this.pathItemParameters != null) {
            all.addAll(this.pathItemParameters);
        }
        if (this.operationParameters != null) {
            all.addAll(this.operationParameters);
        }
        return all;
    }

    public void setPathItemPath(String pathItemPath) {
        this.pathItemPath = pathItemPath;
    }

    public void setPathItemParameters(List<Parameter> pathItemParameters) {
        this.pathItemParameters = pathItemParameters;
    }

    public void setOperationPath(String operationPath) {
        this.operationPath = operationPath;
    }

    public void setOperationParameters(List<Parameter> operationParameters) {
        this.operationParameters = operationParameters;
    }

    public void setFormBodyContent(Content formBodyContent) {
        this.formBodyContent = formBodyContent;
    }

    public void sort() {
        if (this.pathItemParameters != null) {
            this.pathItemParameters.sort(PARAMETER_COMPARATOR);
        }
        if (this.operationParameters != null) {
            this.operationParameters.sort(PARAMETER_COMPARATOR);
        }
    }

    public List<String> getPathParameterTemplateNames() {
        return ResourceParameters.getPathParameterTemplateName(this.pathItemPath, this.operationPath);
    }

    private static List<String> getPathParameterTemplateName(String ... paths) {
        ArrayList<String> templateNames = new ArrayList<String>();
        for (String path : paths) {
            Matcher m = TEMPLATE_PARAM_PATTERN.matcher(path);
            while (m.find()) {
                templateNames.add(m.group(1));
            }
        }
        return templateNames;
    }
}

