/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner;

import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.models.media.SchemaImpl;
import io.smallrye.openapi.api.models.media.XMLImpl;
import io.smallrye.openapi.runtime.io.schema.SchemaFactory;
import io.smallrye.openapi.runtime.scanner.CollectionStandin;
import io.smallrye.openapi.runtime.scanner.IterableStandin;
import io.smallrye.openapi.runtime.scanner.MapStandin;
import io.smallrye.openapi.runtime.scanner.ScannerLogging;
import io.smallrye.openapi.runtime.scanner.SchemaRegistry;
import io.smallrye.openapi.runtime.scanner.dataobject.AnnotationTargetProcessor;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectDeque;
import io.smallrye.openapi.runtime.scanner.dataobject.TypeResolver;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;

public class OpenApiDataObjectScanner {
    public static final DotName COLLECTION_INTERFACE_NAME = DotName.createSimple((String)Collection.class.getName());
    public static final Type COLLECTION_TYPE = Type.create((DotName)COLLECTION_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName ITERABLE_INTERFACE_NAME = DotName.createSimple((String)Iterable.class.getName());
    public static final Type ITERABLE_TYPE = Type.create((DotName)ITERABLE_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName MAP_INTERFACE_NAME = DotName.createSimple((String)Map.class.getName());
    public static final Type MAP_TYPE = Type.create((DotName)MAP_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName SET_INTERFACE_NAME = DotName.createSimple((String)Set.class.getName());
    public static final Type SET_TYPE = Type.create((DotName)SET_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final DotName ENUM_INTERFACE_NAME = DotName.createSimple((String)Enum.class.getName());
    public static final Type ENUM_TYPE = Type.create((DotName)ENUM_INTERFACE_NAME, (Type.Kind)Type.Kind.CLASS);
    public static final Type STRING_TYPE = Type.create((DotName)DotName.createSimple((String)String.class.getName()), (Type.Kind)Type.Kind.CLASS);
    public static final Type ARRAY_TYPE_OBJECT = Type.create((DotName)DotName.createSimple((String)Map[].class.getName()), (Type.Kind)Type.Kind.ARRAY);
    private static ClassInfo collectionStandin;
    private static ClassInfo iterableStandin;
    private static ClassInfo mapStandin;
    private Schema rootSchema;
    private AnnotationTarget rootAnnotationTarget;
    private final Type rootClassType;
    private final ClassInfo rootClassInfo;
    private final AnnotationScannerContext context;
    private final AugmentedIndexView index;
    private final DataObjectDeque objectStack;

    private static void index(Indexer indexer, String resourceName) {
        try (InputStream stream = OpenApiDataObjectScanner.class.getResourceAsStream(resourceName);){
            indexer.index(stream);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    public OpenApiDataObjectScanner(AnnotationScannerContext context, Type classType) {
        this(context, null, classType);
    }

    public OpenApiDataObjectScanner(AnnotationScannerContext context, AnnotationTarget annotationTarget, Type classType) {
        this.context = context;
        this.index = context.getAugmentedIndex();
        this.objectStack = new DataObjectDeque(this.index);
        this.rootClassType = classType;
        this.rootSchema = new SchemaImpl();
        this.rootClassInfo = this.initialType(classType);
        this.rootAnnotationTarget = annotationTarget;
    }

    public static Schema process(AnnotationScannerContext context, Type type) {
        try {
            context.getScanStack().push(type);
            Schema schema = new OpenApiDataObjectScanner(context, type).process();
            return schema;
        }
        finally {
            context.getScanStack().pop();
        }
    }

    public static Schema process(PrimitiveType primitive) {
        SchemaImpl primitiveSchema = new SchemaImpl();
        TypeUtil.applyTypeAttributes((Type)primitive, primitiveSchema);
        return primitiveSchema;
    }

    Schema process() {
        ScannerLogging.logger.startProcessing(this.rootClassType.name());
        if (TypeUtil.isTerminalType(this.rootClassType)) {
            SchemaImpl simpleSchema = new SchemaImpl();
            TypeUtil.applyTypeAttributes(this.rootClassType, simpleSchema);
            return simpleSchema;
        }
        if (this.isA(this.rootClassType, ENUM_TYPE) && this.index.containsClass(this.rootClassType)) {
            return SchemaFactory.enumToSchema(this.context, this.rootClassType);
        }
        if (this.rootClassInfo == null && this.objectStack.isEmpty()) {
            ScannerLogging.logger.schemaTypeNotFound(this.rootClassType.name());
            return new SchemaImpl().type(Schema.SchemaType.OBJECT);
        }
        DataObjectDeque.PathEntry root = this.objectStack.rootNode(this.rootAnnotationTarget, this.rootClassInfo, this.rootClassType, this.rootSchema);
        if (this.isSpecialType(this.rootClassType)) {
            this.resolveSpecial(root, this.rootClassType);
        } else {
            this.objectStack.push(root);
        }
        this.depthFirstGraphSearch();
        return this.rootSchema;
    }

    private void depthFirstGraphSearch() {
        while (!this.objectStack.isEmpty()) {
            DataObjectDeque.PathEntry currentPathEntry = this.objectStack.pop();
            Type currentType = currentPathEntry.getClazzType();
            if (SchemaRegistry.hasSchema(currentType, this.context.getJsonViews(), null)) continue;
            ClassInfo currentClass = currentPathEntry.getClazz();
            Schema currentSchema = currentPathEntry.getSchema();
            currentSchema = this.readKlass(currentClass, currentType, currentSchema);
            TypeUtil.mapDeprecated((AnnotationTarget)currentClass, () -> ((Schema)currentSchema).getDeprecated(), arg_0 -> ((Schema)currentSchema).setDeprecated(arg_0));
            currentPathEntry.setSchema(currentSchema);
            if (currentSchema.getType() == null) {
                currentSchema.setType(Schema.SchemaType.OBJECT);
            } else {
                SchemaFactory.schemaRegistration(this.context, currentType, currentSchema);
            }
            if (currentSchema.getType() != Schema.SchemaType.OBJECT) continue;
            ScannerLogging.logger.gettingFields(currentType, currentClass);
            AnnotationTarget reference = currentPathEntry.getAnnotationTarget();
            Map<String, TypeResolver> properties = TypeResolver.getAllFields(this.context, currentType, currentClass, reference);
            this.processClassAnnotations(currentSchema, currentClass);
            properties.values().stream().filter(resolver -> !resolver.isIgnored()).forEach(resolver -> AnnotationTargetProcessor.process(this.context, this.objectStack, resolver, currentPathEntry));
            this.processInheritance(currentPathEntry);
        }
    }

    private void processClassAnnotations(Schema schema, ClassInfo classInfo) {
        String xmlElementName = (String)TypeUtil.getAnnotationValue((AnnotationTarget)classInfo, JaxbConstants.XML_ROOTELEMENT, "name");
        if (xmlElementName != null && !classInfo.simpleName().equals(xmlElementName)) {
            schema.setXml(new XMLImpl().name(xmlElementName));
        }
    }

    private void processInheritance(DataObjectDeque.PathEntry currentPathEntry) {
        ClassInfo currentClass = currentPathEntry.getClazz();
        Schema currentSchema = currentPathEntry.getSchema();
        Type currentType = currentPathEntry.getClazzType();
        if (TypeUtil.isIncludedAllOf(currentClass, currentType)) {
            Schema enclosingSchema = new SchemaImpl().allOf(currentSchema.getAllOf()).addAllOf(currentSchema);
            currentSchema.setAllOf(null);
            currentSchema = enclosingSchema;
            currentPathEntry.setSchema(currentSchema);
            if (this.rootClassType.equals((Object)currentType)) {
                this.rootSchema = enclosingSchema;
            }
            if (SchemaRegistry.hasSchema(currentType, this.context.getJsonViews(), null)) {
                SchemaRegistry.currentInstance().register(currentType, this.context.getJsonViews(), enclosingSchema);
            }
        }
    }

    private Schema readKlass(ClassInfo currentClass, Type currentType, Schema currentSchema) {
        AnnotationInstance annotation = TypeUtil.getSchemaAnnotation(currentClass);
        Schema classSchema = annotation != null ? SchemaFactory.readSchema(this.context, currentSchema, annotation, currentClass) : (this.isA(currentType, ENUM_TYPE) ? SchemaFactory.enumToSchema(this.context, currentType) : currentSchema);
        return classSchema;
    }

    private void resolveSpecial(DataObjectDeque.PathEntry root, Type type) {
        if (this.typeArgumentMismatch(type, this.rootClassInfo)) {
            ParameterizedType standinInterface = ((Type)this.rootClassInfo.interfaceTypes().get(0)).asParameterizedType();
            type = TypeResolver.resolveParameterizedAncestor(this.context, type.asParameterizedType(), (Type)standinInterface);
        }
        Map<String, TypeResolver> fieldResolution = TypeResolver.getAllFields(this.context, type, this.rootClassInfo, root.getAnnotationTarget());
        this.rootSchema = this.preProcessSpecial(type, fieldResolution.values().iterator().next(), root);
    }

    private boolean typeArgumentMismatch(Type type, ClassInfo standin) {
        if (type.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return false;
        }
        return standin.typeParameters().size() < type.asParameterizedType().arguments().size();
    }

    private Schema preProcessSpecial(Type type, TypeResolver typeResolver, DataObjectDeque.PathEntry currentPathEntry) {
        return AnnotationTargetProcessor.process(this.context, this.objectStack, typeResolver, currentPathEntry, type);
    }

    private boolean isA(Type testSubject, Type test) {
        return TypeUtil.isA(this.context, testSubject, test);
    }

    private boolean isSpecialType(Type type) {
        return this.isA(type, COLLECTION_TYPE) || this.isA(type, ITERABLE_TYPE) || this.isA(type, MAP_TYPE);
    }

    private ClassInfo initialType(Type type) {
        if (this.isA(type, COLLECTION_TYPE)) {
            return collectionStandin;
        }
        if (this.isA(type, ITERABLE_TYPE)) {
            return iterableStandin;
        }
        if (this.isA(type, MAP_TYPE)) {
            return mapStandin;
        }
        return this.index.getClass(type);
    }

    static {
        Indexer indexer = new Indexer();
        OpenApiDataObjectScanner.index(indexer, "CollectionStandin.class");
        OpenApiDataObjectScanner.index(indexer, "IterableStandin.class");
        OpenApiDataObjectScanner.index(indexer, "MapStandin.class");
        Index index = indexer.complete();
        collectionStandin = index.getClassByName(DotName.createSimple((String)CollectionStandin.class.getName()));
        iterableStandin = index.getClassByName(DotName.createSimple((String)IterableStandin.class.getName()));
        mapStandin = index.getClassByName(DotName.createSimple((String)MapStandin.class.getName()));
    }
}

