/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.api.constants.JDKConstants;
import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.constants.MutinyConstants;
import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.FilteredIndexView;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.UtilMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TransferQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.RecordComponentInfo;
import org.jboss.jandex.Type;
import org.jboss.jandex.WildcardType;

public class TypeUtil {
    private static final DotName DOTNAME_OBJECT = DotName.createSimple((String)Object.class.getName());
    private static final Type OBJECT_TYPE = Type.create((DotName)DOTNAME_OBJECT, (Type.Kind)Type.Kind.CLASS);
    private static final DotName DOTNAME_VOID = DotName.createSimple((String)Void.class.getName());
    private static final String UUID_PATTERN = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private static final TypeWithFormat ANY = TypeWithFormat.anyType().build();
    private static final TypeWithFormat STRING_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).build();
    private static final TypeWithFormat BINARY_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("binary").build();
    private static final TypeWithFormat BYTE_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("byte").build();
    private static final TypeWithFormat CHAR_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("byte").build();
    private static final TypeWithFormat UUID_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("uuid").pattern("[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}").build();
    private static final TypeWithFormat URI_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("uri").build();
    private static final TypeWithFormat NUMBER_FORMAT = TypeWithFormat.of(Schema.SchemaType.NUMBER).build();
    private static final TypeWithFormat BIGDECIMAL_FORMAT = TypeWithFormat.of(Schema.SchemaType.NUMBER).build();
    private static final TypeWithFormat DOUBLE_FORMAT = TypeWithFormat.of(Schema.SchemaType.NUMBER).format("double").build();
    private static final TypeWithFormat FLOAT_FORMAT = TypeWithFormat.of(Schema.SchemaType.NUMBER).format("float").build();
    private static final TypeWithFormat BIGINTEGER_FORMAT = TypeWithFormat.of(Schema.SchemaType.INTEGER).build();
    private static final TypeWithFormat INTEGER_FORMAT = TypeWithFormat.of(Schema.SchemaType.INTEGER).format("int32").build();
    private static final TypeWithFormat LONG_FORMAT = TypeWithFormat.of(Schema.SchemaType.INTEGER).format("int64").build();
    private static final TypeWithFormat SHORT_FORMAT = TypeWithFormat.of(Schema.SchemaType.INTEGER).build();
    private static final TypeWithFormat BOOLEAN_FORMAT = TypeWithFormat.of(Schema.SchemaType.BOOLEAN).build();
    private static final TypeWithFormat ARRAY_FORMAT = TypeWithFormat.of(Schema.SchemaType.ARRAY).build();
    private static final TypeWithFormat OBJECT_FORMAT = TypeWithFormat.of(Schema.SchemaType.OBJECT).build();
    private static final TypeWithFormat ARRAY_OPAQUE_FORMAT = TypeWithFormat.of(Schema.SchemaType.ARRAY).opaque().build();
    private static final TypeWithFormat OBJECT_OPAQUE_FORMAT = TypeWithFormat.of(Schema.SchemaType.OBJECT).opaque().build();
    private static final TypeWithFormat DATE_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("date").example("2022-03-10").build();
    private static final TypeWithFormat LOCAL_DATE_TIME_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("date-time").example("2022-03-10T12:15:50").build();
    private static final TypeWithFormat OFFSET_DATE_TIME_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("date-time").example("2022-03-10T12:15:50-04:00").build();
    private static final TypeWithFormat INSTANT_DATE_TIME_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("date-time").example("2022-03-10T16:15:50Z").build();
    private static final TypeWithFormat DURATION_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("duration").example("P1D").build();
    private static final TypeWithFormat TIME_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("time").externalDocumentation("As defined by 'full-time' in RFC3339", "https://xml2rfc.ietf.org/public/rfc/html/rfc3339.html#anchor14").example("13:45.30.123456789+02:00").build();
    private static final TypeWithFormat TIME_LOCAL_FORMAT = TypeWithFormat.of(Schema.SchemaType.STRING).format("local-time").externalDocumentation("As defined by 'partial-time' in RFC3339", "https://xml2rfc.ietf.org/public/rfc/html/rfc3339.html#anchor14").example("13:45.30.123456789").build();
    private static final Map<DotName, TypeWithFormat> TYPE_MAP = new LinkedHashMap<DotName, TypeWithFormat>();
    public static final IndexView jdkIndex;
    private static final Set<DotName> wrapperTypes;

    private static void index(Indexer indexer, Class<?> klazz) {
        try (InputStream stream = klazz.getResourceAsStream(klazz.getSimpleName() + ".class");){
            indexer.index(stream);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private TypeUtil() {
    }

    private static TypeWithFormat getTypeFormat(Type type) {
        if (type.kind() == Type.Kind.ARRAY) {
            return TYPE_MAP.getOrDefault(type.name(), TypeUtil.arrayFormat());
        }
        return TYPE_MAP.getOrDefault(TypeUtil.getName(type), TypeUtil.objectFormat());
    }

    public static boolean allowRegistration(AnnotationScannerContext context, Type classType) {
        TypeWithFormat typeFormat = TypeUtil.getTypeFormat(classType);
        if (typeFormat.isSchemaType(Schema.SchemaType.ARRAY, Schema.SchemaType.OBJECT)) {
            return !typeFormat.isOpaque() && !TypeUtil.knownJavaType(classType.name()) && context.getIndex().getClassByName(classType.name()) != null;
        }
        return typeFormat.getProperties().size() > 2;
    }

    public static boolean knownJavaType(DotName name) {
        return jdkIndex.getClassByName(name) != null;
    }

    public static Map<String, Object> getTypeAttributes(Type classType) {
        return TypeUtil.getTypeFormat(classType).getProperties();
    }

    public static boolean isTypeOverridden(Type classType, AnnotationInstance schemaAnnotation) {
        Schema.SchemaType providedType = JandexUtil.enumValue(schemaAnnotation, "type", Schema.SchemaType.class);
        TypeWithFormat typeFormat = TypeUtil.getTypeFormat(classType);
        return providedType != null && !typeFormat.isSchemaType(providedType);
    }

    public static void applyTypeAttributes(Type classType, Schema schema) {
        Map<String, Object> properties = TypeUtil.getTypeAttributes(classType);
        schema.setType((Schema.SchemaType)properties.get("type"));
        schema.setFormat((String)properties.get("format"));
        schema.setPattern((String)properties.get("pattern"));
        schema.setExample(properties.get("example"));
        schema.setExternalDocs((ExternalDocumentation)properties.get("externalDocs"));
    }

    public static void clearMatchingDefaultAttributes(Schema fieldSchema, Schema typeSchema) {
        TypeUtil.clearIfEqual(fieldSchema.getFormat(), typeSchema.getFormat(), arg_0 -> ((Schema)fieldSchema).setFormat(arg_0));
        TypeUtil.clearIfEqual(fieldSchema.getPattern(), typeSchema.getPattern(), arg_0 -> ((Schema)fieldSchema).setPattern(arg_0));
        TypeUtil.clearIfEqual(fieldSchema.getExample(), typeSchema.getExample(), arg_0 -> ((Schema)fieldSchema).setExample(arg_0));
        TypeUtil.clearIfEqual(fieldSchema.getExternalDocs(), typeSchema.getExternalDocs(), arg_0 -> ((Schema)fieldSchema).setExternalDocs(arg_0));
    }

    static <T> void clearIfEqual(T fieldSchemaVal, T typeSchemaVal, Consumer<T> setter) {
        if (Objects.equals(fieldSchemaVal, typeSchemaVal)) {
            setter.accept(null);
        }
    }

    private static TypeWithFormat arrayFormat() {
        return ARRAY_FORMAT;
    }

    private static TypeWithFormat objectFormat() {
        return OBJECT_FORMAT;
    }

    private static Class<?> getClass(DotName name, ClassLoader cl) throws ClassNotFoundException {
        return Class.forName(name.toString(), false, cl);
    }

    private static boolean isAssignableFrom(DotName subject, DotName object, ClassLoader cl) {
        try {
            Class<?> subjectKlazz = TypeUtil.getClass(subject, cl);
            Class<?> objectKlazz = TypeUtil.getClass(object, cl);
            return objectKlazz.isAssignableFrom(subjectKlazz);
        }
        catch (ClassNotFoundException nfe) {
            return false;
        }
    }

    static ClassInfo getClassInfo(IndexView appIndex, Type type) {
        return TypeUtil.getClassInfo(appIndex, TypeUtil.getName(type));
    }

    static ClassInfo getClassInfo(IndexView appIndex, DotName className) {
        ClassInfo clazz = appIndex.getClassByName(className);
        if (clazz == null) {
            clazz = jdkIndex.getClassByName(className);
        }
        return clazz;
    }

    public static boolean isA(AnnotationScannerContext context, Type testSubject, Type testObject) {
        FilteredIndexView index = context.getIndex();
        ClassLoader cl = context.getClassLoader();
        if (TypeUtil.getName(testSubject).equals((Object)TypeUtil.getName(testObject))) {
            return true;
        }
        if (testSubject.kind() == Type.Kind.PRIMITIVE && testObject.kind() != Type.Kind.PRIMITIVE) {
            return false;
        }
        ClassInfo subJandexKlazz = TypeUtil.getClassInfo((IndexView)index, testSubject);
        if (subJandexKlazz != null && TypeUtil.superTypes(index, subJandexKlazz).contains(TypeUtil.getName(testObject))) {
            return true;
        }
        return TypeUtil.isAssignableFrom(testSubject.name(), testObject.name(), cl);
    }

    private static Set<DotName> superTypes(IndexView index, ClassInfo testSubject) {
        HashSet<DotName> superTypes = new HashSet<DotName>();
        testSubject.interfaceNames().forEach(iface -> {
            superTypes.add((DotName)iface);
            ClassInfo superIFace = TypeUtil.getClassInfo(index, iface);
            if (superIFace != null) {
                superTypes.addAll(TypeUtil.superTypes(index, superIFace));
            }
        });
        Type superType = testSubject.superClassType();
        if (superType != null) {
            superTypes.add(TypeUtil.getName(superType));
            ClassInfo superKlazz = TypeUtil.getClassInfo(index, superType);
            if (superKlazz != null) {
                superTypes.addAll(TypeUtil.superTypes(index, superKlazz));
            }
        }
        return superTypes;
    }

    public static boolean isTerminalType(Type type) {
        boolean terminal;
        switch (type.kind()) {
            case PRIMITIVE: 
            case VOID: {
                terminal = true;
                break;
            }
            case TYPE_VARIABLE: 
            case WILDCARD_TYPE: {
                terminal = false;
                break;
            }
            case CLASS: {
                if (DOTNAME_OBJECT.equals((Object)type.name())) {
                    terminal = true;
                    break;
                }
            }
            default: {
                terminal = !TypeUtil.getTypeFormat(type).isSchemaType(Schema.SchemaType.ARRAY, Schema.SchemaType.OBJECT);
            }
        }
        return terminal;
    }

    public static boolean isWrappedType(Type type) {
        if (type != null) {
            return TypeUtil.isOptional(type) || wrapperTypes.contains(type.name());
        }
        return false;
    }

    public static Type unwrapType(Type type) {
        if (type != null) {
            if (TypeUtil.isOptional(type)) {
                return TypeUtil.getOptionalType(type);
            }
            if (wrapperTypes.contains(type.name())) {
                return (Type)type.asParameterizedType().arguments().get(0);
            }
        }
        return type;
    }

    public static boolean isVoid(Type type) {
        if (type == null) {
            return false;
        }
        switch (type.kind()) {
            case VOID: {
                return true;
            }
            case CLASS: {
                return DOTNAME_VOID.equals((Object)type.name());
            }
        }
        return false;
    }

    public static boolean isOptional(Type type) {
        return type != null && JDKConstants.DOTNAME_OPTIONALS.contains(type.name());
    }

    public static Type getOptionalType(Type type) {
        if (type == null) {
            return null;
        }
        if (JDKConstants.DOTNAME_OPTIONAL.equals((Object)type.name())) {
            return (Type)type.asParameterizedType().arguments().get(0);
        }
        if (JDKConstants.DOTNAME_OPTIONAL_DOUBLE.equals((Object)type.name())) {
            return PrimitiveType.DOUBLE;
        }
        if (JDKConstants.DOTNAME_OPTIONAL_INT.equals((Object)type.name())) {
            return PrimitiveType.INT;
        }
        if (JDKConstants.DOTNAME_OPTIONAL_LONG.equals((Object)type.name())) {
            return PrimitiveType.LONG;
        }
        return null;
    }

    public static DotName getName(Type type) {
        if (type.kind() == Type.Kind.ARRAY) {
            return type.asArrayType().component().name();
        }
        if (type.kind() == Type.Kind.WILDCARD_TYPE) {
            return TypeUtil.getBound(type.asWildcardType()).name();
        }
        return type.name();
    }

    public static Type getBound(WildcardType wct) {
        if (wct.extendsBound() != null) {
            return wct.extendsBound();
        }
        return OBJECT_TYPE;
    }

    public static Type resolveWildcard(WildcardType wildcardType) {
        return TypeUtil.getBound(wildcardType);
    }

    public static Type resolveWildcard(Type type) {
        if (type.kind() != Type.Kind.WILDCARD_TYPE) {
            return type;
        }
        return TypeUtil.getBound(type.asWildcardType());
    }

    public static boolean equalTypes(Type type1, Type type2) {
        if (type1.name().equals((Object)type2.name())) {
            return true;
        }
        return TypeUtil.equalWrappedTypes(type1, type2) || TypeUtil.equalWrappedTypes(type2, type1);
    }

    public static boolean equalWrappedTypes(Type primitiveCandidate, Type wrappedCandidate) {
        return primitiveCandidate.kind().equals((Object)Type.Kind.PRIMITIVE) && wrappedCandidate.kind().equals((Object)Type.Kind.CLASS) && TypeUtil.isPrimitiveWrapper(primitiveCandidate.asPrimitiveType(), wrappedCandidate);
    }

    public static boolean isPrimitiveWrapper(PrimitiveType primitive, Type wrapped) {
        Class wrapperType;
        switch (primitive.primitive()) {
            case BOOLEAN: {
                wrapperType = Boolean.class;
                break;
            }
            case BYTE: {
                wrapperType = Byte.class;
                break;
            }
            case CHAR: {
                wrapperType = Character.class;
                break;
            }
            case DOUBLE: {
                wrapperType = Double.class;
                break;
            }
            case FLOAT: {
                wrapperType = Float.class;
                break;
            }
            case INT: {
                wrapperType = Integer.class;
                break;
            }
            case LONG: {
                wrapperType = Long.class;
                break;
            }
            case SHORT: {
                wrapperType = Short.class;
                break;
            }
            default: {
                throw UtilMessages.msg.unknownPrimitive(primitive);
            }
        }
        return DotName.createSimple((String)wrapperType.getName()).equals((Object)wrapped.name());
    }

    public static AnnotationInstance getSchemaAnnotation(AnnotationTarget annotationTarget) {
        return TypeUtil.getAnnotation(annotationTarget, SchemaConstant.DOTNAME_SCHEMA);
    }

    public static AnnotationInstance getSchemaAnnotation(ClassInfo field) {
        return TypeUtil.getAnnotation(field, SchemaConstant.DOTNAME_SCHEMA);
    }

    public static AnnotationInstance getSchemaAnnotation(FieldInfo field) {
        return TypeUtil.getAnnotation(field, SchemaConstant.DOTNAME_SCHEMA);
    }

    public static AnnotationInstance getSchemaAnnotation(Type type) {
        return TypeUtil.getAnnotation(type, SchemaConstant.DOTNAME_SCHEMA);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isIncludedAllOf(ClassInfo annotatedClass, Type type) {
        Type[] allOfTypes = (Type[])TypeUtil.getAnnotationValue((AnnotationTarget)annotatedClass, SchemaConstant.DOTNAME_SCHEMA, "allOf");
        if (allOfTypes == null) return false;
        if (!Arrays.stream(allOfTypes).map(Type::name).anyMatch(arg_0 -> ((DotName)type.name()).equals(arg_0))) return false;
        return true;
    }

    public static boolean hasAnnotation(AnnotationTarget target, List<DotName> annotationNames) {
        for (DotName dn : annotationNames) {
            if (!TypeUtil.hasAnnotation(target, dn)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnnotation(AnnotationTarget target, DotName annotationName) {
        if (target == null) {
            return false;
        }
        switch (target.kind()) {
            case CLASS: {
                return target.asClass().classAnnotation(annotationName) != null;
            }
            case FIELD: {
                return target.asField().hasAnnotation(annotationName);
            }
            case METHOD: {
                return target.asMethod().hasAnnotation(annotationName);
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = target.asMethodParameter();
                return parameter.method().annotations().stream().filter(a -> a.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(a -> a.target().asMethodParameter().position() == parameter.position()).anyMatch(a -> a.name().equals((Object)annotationName));
            }
        }
        return false;
    }

    public static AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, DotName annotationName) {
        if (annotationTarget == null) {
            return null;
        }
        return TypeUtil.getAnnotations(annotationTarget).stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, Collection<DotName> annotationNames) {
        if (annotationTarget == null) {
            return null;
        }
        for (DotName dn : annotationNames) {
            AnnotationInstance ai = TypeUtil.getAnnotation(annotationTarget, dn);
            if (ai == null) continue;
            return ai;
        }
        return null;
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName) {
        return TypeUtil.getAnnotationValue(target, Arrays.asList(annotationName), "value");
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames) {
        return TypeUtil.getAnnotationValue(target, annotationNames, "value", null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName, String propertyName) {
        return TypeUtil.getAnnotationValue(target, Arrays.asList(annotationName), propertyName);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames, String propertyName) {
        return TypeUtil.getAnnotationValue(target, annotationNames, propertyName, null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, List<DotName> annotationNames, String propertyName, T defaultValue) {
        AnnotationInstance annotation = TypeUtil.getAnnotation(target, annotationNames);
        T value = null;
        if (annotation != null) {
            value = JandexUtil.value(annotation, propertyName);
        }
        return value != null ? value : (T)defaultValue;
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName, String propertyName, T defaultValue) {
        return TypeUtil.getAnnotationValue(target, Arrays.asList(annotationName), propertyName, defaultValue);
    }

    public static Collection<AnnotationInstance> getAnnotations(AnnotationTarget type) {
        switch (type.kind()) {
            case CLASS: {
                return type.asClass().classAnnotations();
            }
            case FIELD: {
                return type.asField().annotations();
            }
            case METHOD: {
                return type.asMethod().annotations();
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = type.asMethodParameter();
                return parameter.method().annotations().stream().filter(a -> a.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(a -> a.target().asMethodParameter().position() == parameter.position()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public static <T> T getDeclaredAnnotationValue(AnnotationTarget type, DotName annotationName, String propertyName) {
        AnnotationInstance annotation = TypeUtil.getDeclaredAnnotation(type, annotationName);
        T value = null;
        if (annotation != null) {
            value = JandexUtil.value(annotation, propertyName);
        }
        return value;
    }

    public static <T> T getDeclaredAnnotationValue(AnnotationTarget type, DotName annotationName) {
        return TypeUtil.getDeclaredAnnotationValue(type, annotationName, "value");
    }

    public static AnnotationInstance getDeclaredAnnotation(AnnotationTarget type, DotName annotationName) {
        Function<DotName, AnnotationInstance> lookup;
        switch (type.kind()) {
            case CLASS: {
                lookup = arg_0 -> ((ClassInfo)type.asClass()).classAnnotation(arg_0);
                break;
            }
            case FIELD: {
                lookup = arg_0 -> ((FieldInfo)type.asField()).annotation(arg_0);
                break;
            }
            case METHOD: {
                lookup = name -> type.asMethod().annotations(name).stream().filter(a -> type.equals(a.target())).findFirst().orElse(null);
                break;
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = type.asMethodParameter();
                lookup = name -> parameter.method().annotations(name).stream().filter(a -> a.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(a -> a.target().asMethodParameter().position() == parameter.position()).findFirst().orElse(null);
                break;
            }
            case RECORD_COMPONENT: {
                lookup = arg_0 -> ((RecordComponentInfo)type.asRecordComponent()).annotation(arg_0);
                break;
            }
            default: {
                lookup = name -> null;
            }
        }
        return lookup.apply(annotationName);
    }

    public static ClassInfo getDeclaringClass(AnnotationTarget type) {
        switch (type.kind()) {
            case FIELD: {
                return type.asField().declaringClass();
            }
            case METHOD: {
                return type.asMethod().declaringClass();
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = type.asMethodParameter();
                return parameter.method().declaringClass();
            }
        }
        return null;
    }

    public static AnnotationInstance getAnnotation(Type type, DotName annotationName) {
        return type.annotations().stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static AnnotationInstance getAnnotation(ClassInfo field, DotName annotationName) {
        return field.classAnnotations().stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static AnnotationInstance getAnnotation(FieldInfo field, DotName annotationName) {
        return field.annotations().stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static void mapDeprecated(AnnotationTarget target, Supplier<Boolean> getDeprecated, Consumer<Boolean> setDeprecated) {
        if (getDeprecated.get() != null) {
            return;
        }
        AnnotationInstance deprecated = TypeUtil.getAnnotation(target, JDKConstants.DOTNAME_DEPRECATED);
        if (deprecated != null && JandexUtil.equals(deprecated.target(), target)) {
            setDeprecated.accept(Boolean.TRUE);
        }
    }

    static {
        wrapperTypes = new HashSet<DotName>();
        TYPE_MAP.put(DOTNAME_OBJECT, ANY);
        TYPE_MAP.put(DotName.createSimple((String)String.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)StringBuffer.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)StringBuilder.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)CharSequence.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)URI.class.getName()), URI_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)UUID.class.getName()), UUID_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Byte.class.getName()), BYTE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Byte.TYPE.getName()), BYTE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Character.class.getName()), CHAR_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Character.TYPE.getName()), CHAR_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)byte[].class.getName()), BINARY_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)InputStream.class.getName()), BINARY_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Number.class.getName()), NUMBER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)BigDecimal.class.getName()), BIGDECIMAL_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Double.class.getName()), DOUBLE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Double.TYPE.getName()), DOUBLE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Float.class.getName()), FLOAT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Float.TYPE.getName()), FLOAT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)BigInteger.class.getName()), BIGINTEGER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Integer.class.getName()), INTEGER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Integer.TYPE.getName()), INTEGER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Long.class.getName()), LONG_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Long.TYPE.getName()), LONG_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Short.class.getName()), SHORT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Short.TYPE.getName()), SHORT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Boolean.class.getName()), BOOLEAN_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Boolean.TYPE.getName()), BOOLEAN_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Date.class.getName()), DATE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)java.sql.Date.class.getName()), DATE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)LocalDate.class.getName()), DATE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)LocalDateTime.class.getName()), LOCAL_DATE_TIME_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)ZonedDateTime.class.getName()), OFFSET_DATE_TIME_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)OffsetDateTime.class.getName()), OFFSET_DATE_TIME_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Instant.class.getName()), INSTANT_DATE_TIME_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Duration.class.getName()), DURATION_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Period.class.getName()), DURATION_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)LocalTime.class.getName()), TIME_LOCAL_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)OffsetTime.class.getName()), TIME_FORMAT);
        for (String qualifier : Arrays.asList("jakarta.", "javax.")) {
            TYPE_MAP.put(DotName.createSimple((String)(qualifier + "json.JsonArray")), ARRAY_OPAQUE_FORMAT);
            TYPE_MAP.put(DotName.createSimple((String)(qualifier + "json.JsonNumber")), NUMBER_FORMAT);
            TYPE_MAP.put(DotName.createSimple((String)(qualifier + "json.JsonObject")), OBJECT_OPAQUE_FORMAT);
            TYPE_MAP.put(DotName.createSimple((String)(qualifier + "json.JsonString")), STRING_FORMAT);
        }
        Indexer indexer = new Indexer();
        TypeUtil.index(indexer, Enum.class);
        TypeUtil.index(indexer, Object.class);
        TypeUtil.index(indexer, Boolean.class);
        TypeUtil.index(indexer, Byte.class);
        TypeUtil.index(indexer, Character.class);
        TypeUtil.index(indexer, Double.class);
        TypeUtil.index(indexer, Float.class);
        TypeUtil.index(indexer, Integer.class);
        TypeUtil.index(indexer, Long.class);
        TypeUtil.index(indexer, Number.class);
        TypeUtil.index(indexer, Short.class);
        TypeUtil.index(indexer, String.class);
        TypeUtil.index(indexer, Void.class);
        TypeUtil.index(indexer, UUID.class);
        TypeUtil.index(indexer, Collection.class);
        TypeUtil.index(indexer, Deque.class);
        TypeUtil.index(indexer, List.class);
        TypeUtil.index(indexer, Map.class);
        TypeUtil.index(indexer, NavigableMap.class);
        TypeUtil.index(indexer, NavigableSet.class);
        TypeUtil.index(indexer, Queue.class);
        TypeUtil.index(indexer, Set.class);
        TypeUtil.index(indexer, SortedMap.class);
        TypeUtil.index(indexer, SortedSet.class);
        TypeUtil.index(indexer, BlockingDeque.class);
        TypeUtil.index(indexer, BlockingQueue.class);
        TypeUtil.index(indexer, ConcurrentMap.class);
        TypeUtil.index(indexer, ConcurrentNavigableMap.class);
        TypeUtil.index(indexer, TransferQueue.class);
        TypeUtil.index(indexer, AbstractCollection.class);
        TypeUtil.index(indexer, AbstractList.class);
        TypeUtil.index(indexer, AbstractMap.class);
        TypeUtil.index(indexer, AbstractQueue.class);
        TypeUtil.index(indexer, AbstractSequentialList.class);
        TypeUtil.index(indexer, AbstractSet.class);
        TypeUtil.index(indexer, EnumSet.class);
        TypeUtil.index(indexer, ArrayDeque.class);
        TypeUtil.index(indexer, ArrayList.class);
        TypeUtil.index(indexer, EnumMap.class);
        TypeUtil.index(indexer, HashMap.class);
        TypeUtil.index(indexer, HashSet.class);
        TypeUtil.index(indexer, Hashtable.class);
        TypeUtil.index(indexer, IdentityHashMap.class);
        TypeUtil.index(indexer, LinkedHashMap.class);
        TypeUtil.index(indexer, LinkedHashSet.class);
        TypeUtil.index(indexer, LinkedList.class);
        TypeUtil.index(indexer, PriorityQueue.class);
        TypeUtil.index(indexer, Properties.class);
        TypeUtil.index(indexer, Stack.class);
        TypeUtil.index(indexer, TreeMap.class);
        TypeUtil.index(indexer, TreeSet.class);
        TypeUtil.index(indexer, Vector.class);
        TypeUtil.index(indexer, ArrayBlockingQueue.class);
        TypeUtil.index(indexer, ConcurrentHashMap.class);
        TypeUtil.index(indexer, ConcurrentLinkedDeque.class);
        TypeUtil.index(indexer, ConcurrentLinkedQueue.class);
        TypeUtil.index(indexer, ConcurrentSkipListMap.class);
        TypeUtil.index(indexer, ConcurrentSkipListSet.class);
        TypeUtil.index(indexer, CopyOnWriteArrayList.class);
        TypeUtil.index(indexer, CopyOnWriteArraySet.class);
        TypeUtil.index(indexer, DelayQueue.class);
        TypeUtil.index(indexer, LinkedBlockingDeque.class);
        TypeUtil.index(indexer, LinkedBlockingQueue.class);
        TypeUtil.index(indexer, LinkedTransferQueue.class);
        TypeUtil.index(indexer, PriorityBlockingQueue.class);
        TypeUtil.index(indexer, SynchronousQueue.class);
        TypeUtil.index(indexer, BaseStream.class);
        TypeUtil.index(indexer, Stream.class);
        TypeUtil.index(indexer, IntStream.class);
        TypeUtil.index(indexer, LongStream.class);
        TypeUtil.index(indexer, DoubleStream.class);
        TypeUtil.index(indexer, CompletionStage.class);
        TypeUtil.index(indexer, CompletableFuture.class);
        jdkIndex = indexer.complete();
        wrapperTypes.addAll(JaxbConstants.JAXB_ELEMENT);
        wrapperTypes.add(MutinyConstants.UNI_TYPE.name());
    }

    private static class DataFormat {
        static final String INT32 = "int32";
        static final String INT64 = "int64";
        static final String FLOAT = "float";
        static final String DOUBLE = "double";
        static final String BINARY = "binary";
        static final String BYTE = "byte";
        static final String DATE = "date";
        static final String DATE_TIME = "date-time";
        static final String DURATION = "duration";
        static final String URI = "uri";
        static final String UUID = "uuid";
        static final String TIME = "time";
        static final String TIME_LOCAL = "local-time";

        private DataFormat() {
        }
    }

    static final class TypeWithFormat {
        private final Map<String, Object> properties;
        private final boolean opaque;

        static Builder of(Schema.SchemaType schemaType) {
            Objects.requireNonNull(schemaType);
            return new Builder(schemaType);
        }

        static Builder anyType() {
            return new Builder(null);
        }

        private TypeWithFormat(Map<String, Object> properties, boolean opaque) {
            this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
            this.opaque = opaque;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isSchemaType(Schema.SchemaType ... schemaTypes) {
            Schema.SchemaType type = (Schema.SchemaType)this.properties.get("type");
            if (type == null) return false;
            if (!Arrays.stream(schemaTypes).anyMatch(arg_0 -> type.equals(arg_0))) return false;
            return true;
        }

        Map<String, Object> getProperties() {
            return this.properties;
        }

        public boolean isOpaque() {
            return this.opaque;
        }

        static class Builder {
            private final Map<String, Object> properties = new HashMap<String, Object>();
            private boolean opaque;

            Builder(Schema.SchemaType schemaType) {
                this.properties.put("type", schemaType);
            }

            Builder opaque(boolean opaque) {
                this.opaque = opaque;
                return this;
            }

            Builder opaque() {
                return this.opaque(true);
            }

            Builder format(String format) {
                this.properties.put("format", format);
                return this;
            }

            Builder pattern(String pattern) {
                this.properties.put("pattern", pattern);
                return this;
            }

            Builder example(Object example) {
                this.properties.put("example", example);
                return this;
            }

            Builder externalDocumentation(String description, String url) {
                ExternalDocumentationImpl doc = new ExternalDocumentationImpl();
                doc.setDescription(description);
                doc.setUrl(url);
                this.properties.put("externalDocs", doc);
                return this;
            }

            TypeWithFormat build() {
                return new TypeWithFormat(this.properties, this.opaque);
            }
        }
    }
}

