/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.smallrye.openapi.runtime.io.Format;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.definition.DefinitionWriter;
import java.io.IOException;
import org.eclipse.microprofile.openapi.models.OpenAPI;

public class OpenApiSerializer {
    private OpenApiSerializer() {
    }

    public static final String serialize(OpenAPI openApi, Format format) throws IOException {
        try {
            ObjectNode tree = JsonUtil.objectNode();
            DefinitionWriter.writeOpenAPI(tree, openApi);
            if (format == Format.JSON) {
                ObjectMapper mapper = new ObjectMapper();
                return mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tree);
            }
            YAMLFactory factory = new YAMLFactory();
            factory.enable(YAMLGenerator.Feature.MINIMIZE_QUOTES);
            factory.enable(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS);
            factory.enable(YAMLGenerator.Feature.ALLOW_LONG_KEYS);
            ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
            return mapper.writer().writeValueAsString((Object)tree);
        }
        catch (JsonProcessingException e) {
            throw new IOException(e);
        }
    }
}

